/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock;

import de.gematik.test.tiger.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpActionHandler;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpForwardActionResult;
import de.gematik.test.tiger.mockserver.model.Action;
import de.gematik.test.tiger.mockserver.model.HttpOverrideForwardedRequest;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.netty.responsewriter.NettyResponseWriter;
import io.netty.channel.Channel;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpAction.class);
    private final Action action;
    private ExpectationForwardAndResponseCallback expectationForwardAndResponseCallback;

    public static HttpAction of(Action actionToTake) {
        return new HttpAction(actionToTake);
    }

    public void handle(HttpRequest request, Channel incomingChannel, HttpActionHandler actionHandler, NettyResponseWriter responseWriter, boolean synchronous) {
        Optional<Action> cannedResponse = this.expectationForwardAndResponseCallback.cannedResponse(request);
        if (cannedResponse.isPresent()) {
            cannedResponse.get().write(responseWriter, request);
        } else {
            this.performActualRequestAndWriteResponse(request, incomingChannel, actionHandler, responseWriter, synchronous);
        }
    }

    public void performActualRequestAndWriteResponse(HttpRequest request, Channel incomingChannel, HttpActionHandler actionHandler, NettyResponseWriter responseWriter, boolean synchronous) {
        HttpRequest overriddenRequest = this.getOverridenRequest(request);
        if (this.action instanceof HttpOverrideForwardedRequest) {
            HttpForwardActionResult responseFuture = actionHandler.getHttpForwardActionHandler().sendRequest(overriddenRequest, incomingChannel, null, null);
            actionHandler.executeAfterForwardActionResponse(responseFuture, (httpResponse, exception) -> {
                if (httpResponse != null) {
                    try {
                        HttpResponse callbackResponse = this.expectationForwardAndResponseCallback.handle(overriddenRequest, (HttpResponse)httpResponse);
                        actionHandler.writeForwardActionResponse(callbackResponse, responseWriter, request);
                    }
                    catch (Exception e) {
                        log.warn("returning error because client response callback threw an exception", (Throwable)e);
                        actionHandler.writeForwardActionResponse(HttpAction.notFoundFuture(request), responseWriter, request, this.action, synchronous);
                    }
                } else if (exception != null) {
                    actionHandler.handleExceptionDuringForwardingRequest(this.expectationForwardAndResponseCallback.handleException((Throwable)exception, request), request, responseWriter, (Throwable)exception);
                }
            }, synchronous);
        }
    }

    private static HttpForwardActionResult notFoundFuture(HttpRequest httpRequest) {
        CompletableFuture<HttpResponse> notFoundFuture = new CompletableFuture<HttpResponse>();
        notFoundFuture.complete(HttpResponse.notFoundResponse());
        return new HttpForwardActionResult(httpRequest, notFoundFuture, null);
    }

    private HttpRequest getOverridenRequest(HttpRequest request) {
        HttpRequest overriddenRequest = request;
        if (this.expectationForwardAndResponseCallback != null) {
            overriddenRequest = this.expectationForwardAndResponseCallback.handle(request);
        }
        return overriddenRequest;
    }

    @ConstructorProperties(value={"action"})
    @Generated
    public HttpAction(Action action) {
        this.action = action;
    }

    @Generated
    public Action getAction() {
        return this.action;
    }

    @Generated
    public ExpectationForwardAndResponseCallback getExpectationForwardAndResponseCallback() {
        return this.expectationForwardAndResponseCallback;
    }

    @Generated
    public HttpAction setExpectationForwardAndResponseCallback(ExpectationForwardAndResponseCallback expectationForwardAndResponseCallback) {
        this.expectationForwardAndResponseCallback = expectationForwardAndResponseCallback;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpAction)) {
            return false;
        }
        HttpAction other = (HttpAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        ExpectationForwardAndResponseCallback this$expectationForwardAndResponseCallback = this.getExpectationForwardAndResponseCallback();
        ExpectationForwardAndResponseCallback other$expectationForwardAndResponseCallback = other.getExpectationForwardAndResponseCallback();
        return !(this$expectationForwardAndResponseCallback == null ? other$expectationForwardAndResponseCallback != null : !this$expectationForwardAndResponseCallback.equals(other$expectationForwardAndResponseCallback));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        ExpectationForwardAndResponseCallback $expectationForwardAndResponseCallback = this.getExpectationForwardAndResponseCallback();
        result = result * 59 + ($expectationForwardAndResponseCallback == null ? 43 : $expectationForwardAndResponseCallback.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpAction(action=" + this.getAction() + ", expectationForwardAndResponseCallback=" + this.getExpectationForwardAndResponseCallback() + ")";
    }
}

