/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock;

import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRoute;
import de.gematik.test.tiger.mockserver.mock.HttpAction;
import de.gematik.test.tiger.mockserver.mock.action.ExpectationCallback;
import de.gematik.test.tiger.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import de.gematik.test.tiger.mockserver.model.HttpOverrideForwardedRequest;
import de.gematik.test.tiger.mockserver.model.HttpProtocol;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.ObjectWithJsonToString;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expectation
extends ObjectWithJsonToString
implements Comparable<Expectation> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Expectation.class);
    private String id = UUID.randomUUID().toString();
    private TigerRoute tigerRoute;
    private final int priority;
    private final HttpRequest requestPattern;
    private HttpAction httpAction;
    private final List<String> hostRegexes;
    private final boolean ignorePortsInHostHeader;
    private ExpectationCallback expectationCallback;

    public Expectation(HttpRequest requestDefinition, int priority, List<String> hostRegexes) {
        this.requestPattern = requestDefinition;
        this.priority = priority;
        if (hostRegexes == null) {
            this.hostRegexes = List.of();
            this.ignorePortsInHostHeader = true;
        } else {
            this.hostRegexes = hostRegexes.stream().map(String::trim).toList();
            this.ignorePortsInHostHeader = hostRegexes.stream().noneMatch(h -> h.contains(":"));
        }
    }

    public Expectation thenForward(ExpectationForwardAndResponseCallback callback) {
        this.httpAction = HttpAction.of(new HttpOverrideForwardedRequest()).setExpectationForwardAndResponseCallback(callback);
        this.expectationCallback = callback;
        return this;
    }

    public boolean matches(HttpRequest request) {
        return this.protocolMatches(this.requestPattern.getProtocol(), request.getProtocol()) && this.secureMatches(request) && this.hostMatches(request) && this.pathMatches(this.requestPattern.getPath(), request.getPath()) && (this.expectationCallback == null || this.expectationCallback.matches(request));
    }

    private boolean secureMatches(HttpRequest request) {
        if (this.requestPattern.isSecure() == null || request.isSecure() == null) {
            return true;
        }
        boolean equals = this.requestPattern.isSecure().equals(request.isSecure());
        if (!equals) {
            log.atTrace().addArgument(request::isSecure).addArgument(() -> ((TigerRoute)this.tigerRoute).createShortDescription()).log("secure [{}] is not matching for route {}");
        }
        return equals;
    }

    private boolean hostMatches(HttpRequest request) {
        String cleanedPatternHostHeader;
        if (!this.requestPattern.getHeaders().containsEntry("Host") && (this.hostRegexes == null || this.hostRegexes.isEmpty())) {
            return true;
        }
        String cleanedHostHeader = this.ignorePortsInHostHeader ? request.getFirstHeader("Host").trim().split(":")[0] : request.getFirstHeader("Host").trim();
        String string = cleanedPatternHostHeader = this.ignorePortsInHostHeader ? this.requestPattern.getFirstHeader("Host").split(":")[0] : this.requestPattern.getFirstHeader("Host");
        if (StringUtils.equals((CharSequence)cleanedPatternHostHeader, (CharSequence)cleanedHostHeader)) {
            return true;
        }
        boolean anyHostHeaderMatch = this.hostRegexes.stream().anyMatch(hostMatchCriterion -> cleanedHostHeader.equals(hostMatchCriterion) || cleanedHostHeader.matches((String)hostMatchCriterion));
        if (!anyHostHeaderMatch) {
            log.atTrace().addArgument(() -> cleanedHostHeader).addArgument(() -> ((TigerRoute)this.tigerRoute).createShortDescription()).addArgument((Object)this.ignorePortsInHostHeader).log("host [{}] is not matching for route {} ({})");
        }
        return anyHostHeaderMatch;
    }

    private boolean protocolMatches(HttpProtocol protocol, HttpProtocol otherProtocol) {
        if (protocol == null) {
            return true;
        }
        if (protocol.equals((Object)otherProtocol)) {
            return true;
        }
        log.atTrace().addArgument((Object)protocol).addArgument((Object)otherProtocol).addArgument(() -> ((TigerRoute)this.tigerRoute).createShortDescription()).log("protocol [{}] is not matching [{}] for route {}");
        return false;
    }

    public boolean pathMatches(String blueprint, String actualValue) {
        if (blueprint == null) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)blueprint)) {
            return true;
        }
        if (actualValue != null) {
            if (actualValue.equalsIgnoreCase(blueprint)) {
                return true;
            }
            try {
                if (actualValue.matches(blueprint)) {
                    return true;
                }
            }
            catch (PatternSyntaxException pse) {
                log.debug("error while matching regex [{}] for string [{}]", new Object[]{blueprint, actualValue, pse});
            }
            try {
                if (blueprint.matches(actualValue)) {
                    return true;
                }
            }
            catch (PatternSyntaxException pse) {
                log.debug("error while matching regex [{}] for string [{}]", new Object[]{actualValue, blueprint, pse});
            }
        }
        log.atTrace().addArgument((Object)actualValue).addArgument(() -> ((TigerRoute)this.tigerRoute).createShortDescription()).log("path [{}] is not matching for route {}");
        return false;
    }

    @Override
    public int compareTo(Expectation o) {
        if (o == null) {
            return 1;
        }
        if (this.priority == o.priority) {
            String otherPath;
            if (this.requestPattern == null || o.requestPattern == null || this.requestPattern.getPath() == null || o.requestPattern.getPath() == null) {
                return 0;
            }
            String thisPath = this.requestPattern.getPath();
            if (Expectation.uriTwoIsBelowUriOne(thisPath, otherPath = o.requestPattern.getPath())) {
                return -1;
            }
            if (Expectation.uriTwoIsBelowUriOne(otherPath, thisPath)) {
                return 1;
            }
            return 0;
        }
        return Integer.compare(o.priority, this.priority);
    }

    private static boolean uriTwoIsBelowUriOne(String value1, String value2) {
        try {
            URI uri1 = new URI(value1);
            URI uri2WithUri1Scheme = new URIBuilder(value2).setScheme(uri1.getScheme()).build();
            return !uri1.relativize(uri2WithUri1Scheme).equals(uri2WithUri1Scheme);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public String createShortDescription() {
        if (this.tigerRoute != null) {
            return this.tigerRoute.createShortDescription();
        }
        return this.requestPattern.printLogLineDescription();
    }

    @Generated
    public static ExpectationBuilder builder() {
        return new ExpectationBuilder();
    }

    @Generated
    public ExpectationBuilder toBuilder() {
        return new ExpectationBuilder().id(this.id).tigerRoute(this.tigerRoute).priority(this.priority).requestPattern(this.requestPattern).httpAction(this.httpAction).hostRegexes(this.hostRegexes).ignorePortsInHostHeader(this.ignorePortsInHostHeader).expectationCallback(this.expectationCallback);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Expectation)) {
            return false;
        }
        Expectation other = (Expectation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (this.isIgnorePortsInHostHeader() != other.isIgnorePortsInHostHeader()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        TigerRoute this$tigerRoute = this.getTigerRoute();
        TigerRoute other$tigerRoute = other.getTigerRoute();
        if (this$tigerRoute == null ? other$tigerRoute != null : !this$tigerRoute.equals(other$tigerRoute)) {
            return false;
        }
        HttpRequest this$requestPattern = this.getRequestPattern();
        HttpRequest other$requestPattern = other.getRequestPattern();
        if (this$requestPattern == null ? other$requestPattern != null : !((Object)this$requestPattern).equals(other$requestPattern)) {
            return false;
        }
        HttpAction this$httpAction = this.getHttpAction();
        HttpAction other$httpAction = other.getHttpAction();
        if (this$httpAction == null ? other$httpAction != null : !((Object)this$httpAction).equals(other$httpAction)) {
            return false;
        }
        List<String> this$hostRegexes = this.getHostRegexes();
        List<String> other$hostRegexes = other.getHostRegexes();
        if (this$hostRegexes == null ? other$hostRegexes != null : !((Object)this$hostRegexes).equals(other$hostRegexes)) {
            return false;
        }
        ExpectationCallback this$expectationCallback = this.getExpectationCallback();
        ExpectationCallback other$expectationCallback = other.getExpectationCallback();
        return !(this$expectationCallback == null ? other$expectationCallback != null : !this$expectationCallback.equals(other$expectationCallback));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Expectation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        result = result * 59 + (this.isIgnorePortsInHostHeader() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        TigerRoute $tigerRoute = this.getTigerRoute();
        result = result * 59 + ($tigerRoute == null ? 43 : $tigerRoute.hashCode());
        HttpRequest $requestPattern = this.getRequestPattern();
        result = result * 59 + ($requestPattern == null ? 43 : ((Object)$requestPattern).hashCode());
        HttpAction $httpAction = this.getHttpAction();
        result = result * 59 + ($httpAction == null ? 43 : ((Object)$httpAction).hashCode());
        List<String> $hostRegexes = this.getHostRegexes();
        result = result * 59 + ($hostRegexes == null ? 43 : ((Object)$hostRegexes).hashCode());
        ExpectationCallback $expectationCallback = this.getExpectationCallback();
        result = result * 59 + ($expectationCallback == null ? 43 : $expectationCallback.hashCode());
        return result;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public TigerRoute getTigerRoute() {
        return this.tigerRoute;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public HttpRequest getRequestPattern() {
        return this.requestPattern;
    }

    @Generated
    public HttpAction getHttpAction() {
        return this.httpAction;
    }

    @Generated
    public List<String> getHostRegexes() {
        return this.hostRegexes;
    }

    @Generated
    public boolean isIgnorePortsInHostHeader() {
        return this.ignorePortsInHostHeader;
    }

    @Generated
    public ExpectationCallback getExpectationCallback() {
        return this.expectationCallback;
    }

    @ConstructorProperties(value={"id", "tigerRoute", "priority", "requestPattern", "httpAction", "hostRegexes", "ignorePortsInHostHeader", "expectationCallback"})
    @Generated
    public Expectation(String id, TigerRoute tigerRoute, int priority, HttpRequest requestPattern, HttpAction httpAction, List<String> hostRegexes, boolean ignorePortsInHostHeader, ExpectationCallback expectationCallback) {
        this.id = id;
        this.tigerRoute = tigerRoute;
        this.priority = priority;
        this.requestPattern = requestPattern;
        this.httpAction = httpAction;
        this.hostRegexes = hostRegexes;
        this.ignorePortsInHostHeader = ignorePortsInHostHeader;
        this.expectationCallback = expectationCallback;
    }

    @Generated
    public Expectation setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public Expectation setTigerRoute(TigerRoute tigerRoute) {
        this.tigerRoute = tigerRoute;
        return this;
    }

    @Generated
    public Expectation setHttpAction(HttpAction httpAction) {
        this.httpAction = httpAction;
        return this;
    }

    @Generated
    public static class ExpectationBuilder {
        @Generated
        private String id;
        @Generated
        private TigerRoute tigerRoute;
        @Generated
        private int priority;
        @Generated
        private HttpRequest requestPattern;
        @Generated
        private HttpAction httpAction;
        @Generated
        private List<String> hostRegexes;
        @Generated
        private boolean ignorePortsInHostHeader;
        @Generated
        private ExpectationCallback expectationCallback;

        @Generated
        ExpectationBuilder() {
        }

        @Generated
        public ExpectationBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ExpectationBuilder tigerRoute(TigerRoute tigerRoute) {
            this.tigerRoute = tigerRoute;
            return this;
        }

        @Generated
        public ExpectationBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Generated
        public ExpectationBuilder requestPattern(HttpRequest requestPattern) {
            this.requestPattern = requestPattern;
            return this;
        }

        @Generated
        public ExpectationBuilder httpAction(HttpAction httpAction) {
            this.httpAction = httpAction;
            return this;
        }

        @Generated
        public ExpectationBuilder hostRegexes(List<String> hostRegexes) {
            this.hostRegexes = hostRegexes;
            return this;
        }

        @Generated
        public ExpectationBuilder ignorePortsInHostHeader(boolean ignorePortsInHostHeader) {
            this.ignorePortsInHostHeader = ignorePortsInHostHeader;
            return this;
        }

        @Generated
        public ExpectationBuilder expectationCallback(ExpectationCallback expectationCallback) {
            this.expectationCallback = expectationCallback;
            return this;
        }

        @Generated
        public Expectation build() {
            return new Expectation(this.id, this.tigerRoute, this.priority, this.requestPattern, this.httpAction, this.hostRegexes, this.ignorePortsInHostHeader, this.expectationCallback);
        }

        @Generated
        public String toString() {
            return "Expectation.ExpectationBuilder(id=" + this.id + ", tigerRoute=" + this.tigerRoute + ", priority=" + this.priority + ", requestPattern=" + this.requestPattern + ", httpAction=" + this.httpAction + ", hostRegexes=" + this.hostRegexes + ", ignorePortsInHostHeader=" + this.ignorePortsInHostHeader + ", expectationCallback=" + this.expectationCallback + ")";
        }
    }
}

