/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.httpclient;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.httpclient.HttpClientInitializer;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.httpclient.RequestInfo;
import de.gematik.test.tiger.mockserver.httpclient.ReusableChannel;
import de.gematik.test.tiger.mockserver.model.Message;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBootstrapFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientBootstrapFactory.class);
    private final MockServerConfiguration configuration;
    private final EventLoopGroup eventLoop;
    private final ReusableChannelMap channelMap = new ReusableChannelMap();

    private ChannelFuture createOrReuseChannel(boolean isSecure, @Nullable RequestInfo<?> requestInfo, @Nullable Channel incomingChannel, @Nullable InetSocketAddress remoteAddress, HttpClientInitializer clientInitializer, boolean errorIfChannelClosedWithoutResponse, @Nullable CompletableFuture<Message> responseFuture, @Nullable ChannelFutureListener onCreationListener, @Nullable ChannelFutureListener onReuseListener, @Nullable Long timeoutInMilliseconds, @Nullable EventLoopGroup eventLoopGroup) {
        ChannelFuture existingChannel = null;
        if (requestInfo != null) {
            existingChannel = this.channelMap.getChannelToReuse(requestInfo);
            remoteAddress = requestInfo.getRemoteServerAddress();
            incomingChannel = requestInfo.getIncomingChannel();
        }
        if (existingChannel != null) {
            log.trace("reusing already existing channel");
            existingChannel.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    Optional.ofNullable((CompletableFuture)future.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get()).ifPresent(oldFuture -> oldFuture.complete(null));
                    future.channel().attr(NettyHttpClient.RESPONSE_FUTURE).set((Object)responseFuture);
                }
            }));
            if (onReuseListener != null) {
                existingChannel.addListener((GenericFutureListener)onReuseListener);
            }
            return existingChannel;
        }
        log.trace("creating a new channel");
        if (timeoutInMilliseconds == null) {
            timeoutInMilliseconds = this.configuration.socketConnectionTimeoutInMillis();
        }
        if (eventLoopGroup == null) {
            eventLoopGroup = this.eventLoop;
        }
        Integer timeout = timeoutInMilliseconds != null ? Integer.valueOf(timeoutInMilliseconds.intValue()) : null;
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeout)).attr(NettyHttpClient.SECURE, (Object)isSecure)).attr(NettyHttpClient.REMOTE_SOCKET, (Object)remoteAddress)).attr(NettyHttpClient.ERROR_IF_CHANNEL_CLOSED_WITHOUT_RESPONSE, (Object)errorIfChannelClosedWithoutResponse)).handler((ChannelHandler)clientInitializer);
        if (responseFuture != null) {
            bootstrap.attr(NettyHttpClient.RESPONSE_FUTURE, responseFuture);
        }
        ChannelFuture channelFuture = bootstrap.connect((SocketAddress)remoteAddress);
        this.channelMap.addChannel(ReusableChannelMap.ChannelId.from(incomingChannel, remoteAddress), channelFuture);
        if (onCreationListener != null) {
            channelFuture.addListener((GenericFutureListener)onCreationListener);
        }
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> future.channel().closeFuture().addListener(f -> this.channelMap.remove((ChannelFuture)future))));
        return channelFuture;
    }

    @Generated
    public ChannelFutureBuilder configureChannel() {
        return new ChannelFutureBuilder();
    }

    @ConstructorProperties(value={"configuration", "eventLoop"})
    @Generated
    public ClientBootstrapFactory(MockServerConfiguration configuration, EventLoopGroup eventLoop) {
        this.configuration = configuration;
        this.eventLoop = eventLoop;
    }

    @Generated
    public ReusableChannelMap getChannelMap() {
        return this.channelMap;
    }

    public static class ReusableChannelMap {
        private final Multimap<ChannelId, ReusableChannel> channelMap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

        public synchronized ChannelFuture getChannelToReuse(RequestInfo<?> requestInfo) {
            return this.channelMap.get((Object)ChannelId.from(requestInfo)).stream().filter(ReusableChannel::canBeReused).findAny().map(ReusableChannel::getFutureOutgoingChannel).orElse(null);
        }

        public synchronized ChannelFuture getChannelInUse(RequestInfo<?> requestInfo) {
            return this.channelMap.get((Object)ChannelId.from(requestInfo)).stream().findAny().map(ReusableChannel::getFutureOutgoingChannel).orElse(null);
        }

        public synchronized void addChannel(ChannelId channelId, ChannelFuture channelFuture) {
            this.channelMap.put((Object)channelId, (Object)new ReusableChannel(channelFuture));
        }

        public synchronized void remove(ChannelFuture channelFuture) {
            List<Map.Entry> toRemove = this.channelMap.entries().stream().filter(entry -> ((ReusableChannel)entry.getValue()).getFutureOutgoingChannel().equals(channelFuture)).toList();
            toRemove.forEach(entry -> this.channelMap.remove(entry.getKey(), entry.getValue()));
        }

        public record ChannelId(Channel incomingChannel, InetSocketAddress remoteAddress) {
            public static ChannelId from(RequestInfo<?> info) {
                return ChannelId.from(info.getIncomingChannel(), info.getRemoteServerAddress());
            }

            public static ChannelId from(Channel incomingChannel, InetSocketAddress remoteAddress) {
                return new ChannelId(incomingChannel, remoteAddress);
            }
        }
    }

    @Generated
    public class ChannelFutureBuilder {
        @Generated
        private boolean isSecure;
        @Generated
        private RequestInfo<?> requestInfo;
        @Generated
        private Channel incomingChannel;
        @Generated
        private InetSocketAddress remoteAddress;
        @Generated
        private HttpClientInitializer clientInitializer;
        @Generated
        private boolean errorIfChannelClosedWithoutResponse;
        @Generated
        private CompletableFuture<Message> responseFuture;
        @Generated
        private ChannelFutureListener onCreationListener;
        @Generated
        private ChannelFutureListener onReuseListener;
        @Generated
        private Long timeoutInMilliseconds;
        @Generated
        private EventLoopGroup eventLoopGroup;

        @Generated
        ChannelFutureBuilder() {
        }

        @Generated
        public ChannelFutureBuilder isSecure(boolean isSecure) {
            this.isSecure = isSecure;
            return this;
        }

        @Generated
        public ChannelFutureBuilder requestInfo(@Nullable RequestInfo<?> requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @Generated
        public ChannelFutureBuilder incomingChannel(@Nullable Channel incomingChannel) {
            this.incomingChannel = incomingChannel;
            return this;
        }

        @Generated
        public ChannelFutureBuilder remoteAddress(@Nullable InetSocketAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        @Generated
        public ChannelFutureBuilder clientInitializer(HttpClientInitializer clientInitializer) {
            this.clientInitializer = clientInitializer;
            return this;
        }

        @Generated
        public ChannelFutureBuilder errorIfChannelClosedWithoutResponse(boolean errorIfChannelClosedWithoutResponse) {
            this.errorIfChannelClosedWithoutResponse = errorIfChannelClosedWithoutResponse;
            return this;
        }

        @Generated
        public ChannelFutureBuilder responseFuture(@Nullable CompletableFuture<Message> responseFuture) {
            this.responseFuture = responseFuture;
            return this;
        }

        @Generated
        public ChannelFutureBuilder onCreationListener(@Nullable ChannelFutureListener onCreationListener) {
            this.onCreationListener = onCreationListener;
            return this;
        }

        @Generated
        public ChannelFutureBuilder onReuseListener(@Nullable ChannelFutureListener onReuseListener) {
            this.onReuseListener = onReuseListener;
            return this;
        }

        @Generated
        public ChannelFutureBuilder timeoutInMilliseconds(@Nullable Long timeoutInMilliseconds) {
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            return this;
        }

        @Generated
        public ChannelFutureBuilder eventLoopGroup(@Nullable EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        @Generated
        public ChannelFuture connectToChannel() {
            return ClientBootstrapFactory.this.createOrReuseChannel(this.isSecure, this.requestInfo, this.incomingChannel, this.remoteAddress, this.clientInitializer, this.errorIfChannelClosedWithoutResponse, this.responseFuture, this.onCreationListener, this.onReuseListener, this.timeoutInMilliseconds, this.eventLoopGroup);
        }

        @Generated
        public String toString() {
            return "ClientBootstrapFactory.ChannelFutureBuilder(isSecure=" + this.isSecure + ", requestInfo=" + this.requestInfo + ", incomingChannel=" + this.incomingChannel + ", remoteAddress=" + this.remoteAddress + ", clientInitializer=" + this.clientInitializer + ", errorIfChannelClosedWithoutResponse=" + this.errorIfChannelClosedWithoutResponse + ", responseFuture=" + this.responseFuture + ", onCreationListener=" + this.onCreationListener + ", onReuseListener=" + this.onReuseListener + ", timeoutInMilliseconds=" + this.timeoutInMilliseconds + ", eventLoopGroup=" + this.eventLoopGroup + ")";
        }
    }
}

