/*
 * Copyright 2024 gematik GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.gematik.test.tiger.mockserver.model;

import de.gematik.test.tiger.mockserver.netty.responsewriter.NettyResponseWriter;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/** Signifies a graceful channel close. */
@Slf4j
@Getter
@Setter
public class CloseChannel implements Action {

  private String expectationId;

  @Override
  public Type getType() {
    return null;
  }

  @Override
  public void write(NettyResponseWriter nettyResponseWriter, HttpRequest request) {
    log.debug("closing channel due to close action");
    nettyResponseWriter.closeChannel();
  }
}
