/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tracing;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.facet.TigerNonPairedMessageFacet;
import de.gematik.rbellogger.data.facet.TracingMessagePairFacet;
import de.gematik.rbellogger.file.MessageTimeWriter;
import de.gematik.rbellogger.file.RbelFileWriter;
import de.gematik.rbellogger.file.TcpIpMessageFacetWriter;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.client.TigerExceptionDto;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessagePart;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.SimpMessagingTemplate;

public class TracingPushService {
    public static final int MAX_MESSAGE_SIZE = 524288;
    private final SimpMessagingTemplate template;
    private final TigerProxy tigerProxy;
    private final ConcurrentHashMap<String, Long> nextSequenceNumberToBePushed = new ConcurrentHashMap();
    private final Map<String, Map<Long, Runnable>> pendingMessagesPerUrl = new ConcurrentHashMap<String, Map<Long, Runnable>>();
    private Logger log = LoggerFactory.getLogger(TracingPushService.class);

    public void addWebSocketListener() {
        this.tigerProxy.addRbelMessageListener(this::propagateRbelMessageSafe);
        this.tigerProxy.addNewExceptionConsumer(this::propagateExceptionSafe);
        this.log = LoggerFactory.getLogger((String)(TracingPushService.class.getName() + "(" + this.tigerProxy.proxyName() + ")"));
    }

    private void propagateExceptionSafe(Throwable exc) {
        try {
            this.propagateException(exc);
        }
        catch (RuntimeException e) {
            this.log.error("Error while propagating Exception", (Throwable)e);
            throw e;
        }
    }

    private synchronized void propagateRbelMessageSafe(RbelElement msg) {
        try {
            if (!msg.hasFacet(RbelTcpIpMessageFacet.class)) {
                return;
            }
            long sequenceNumber = ((RbelTcpIpMessageFacet)msg.getFacetOrFail(RbelTcpIpMessageFacet.class)).getSequenceNumber();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Transmitting message #{}: {}", (Object)sequenceNumber, (Object)msg.printHttpDescription());
            }
            if (sequenceNumber < this.nextSequenceNumberFor(msg)) {
                throw new IllegalStateException("Received message with sequence number lower than expected! (We are at " + this.nextSequenceNumberFor(msg) + ", received " + sequenceNumber + ")");
            }
            if (sequenceNumber == this.nextSequenceNumberFor(msg)) {
                this.propagateMessageAndUpdateSequenceCounter(msg, sequenceNumber);
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Received message with sequence number {}. Waiting... (we are at {})", (Object)sequenceNumber, (Object)this.nextSequenceNumberFor(msg));
                }
                this.addNewPendingMessage(msg, sequenceNumber);
            }
        }
        catch (RuntimeException e) {
            this.log.error("Error while propagating new Rbel-Message", (Throwable)e);
            throw e;
        }
    }

    private void addNewPendingMessage(RbelElement msg, long sequenceNumber) {
        String remoteUrl = TracingPushService.extractRemoteUrl(msg);
        this.pendingMessagesPerUrl.computeIfAbsent(remoteUrl, k -> new ConcurrentHashMap());
        this.pendingMessagesPerUrl.get(remoteUrl).put(sequenceNumber, () -> this.propagateMessageAndUpdateSequenceCounter(msg, sequenceNumber));
    }

    private Long nextSequenceNumberFor(RbelElement msg) {
        return this.nextSequenceNumberToBePushed.getOrDefault(TracingPushService.extractRemoteUrl(msg), 0L);
    }

    private void propagateMessageAndUpdateSequenceCounter(RbelElement msg, long sequenceNumber) {
        this.log.trace("Received message with sequence number {}. Pushing...", (Object)sequenceNumber);
        this.propagateRbelMessage(msg);
        this.nextSequenceNumberToBePushed.put(TracingPushService.extractRemoteUrl(msg), sequenceNumber + 1L);
        this.log.trace("Pushed message with sequence number {}. Now treating waiting messages (sequence numbers are {})", (Object)sequenceNumber, this.nextSequenceNumberToBePushed);
        this.queryAndRemovePendingMessageFuture(msg, sequenceNumber).ifPresent(future -> {
            this.log.info("Completing future for sequence number {}", (Object)sequenceNumber);
            future.run();
        });
    }

    private static String extractRemoteUrl(RbelElement msg) {
        return msg.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getReceivedFromRemoteWithUrl).orElse("local");
    }

    private Optional<Runnable> queryAndRemovePendingMessageFuture(RbelElement msg, long sequenceNumber) {
        String remoteUrl = TracingPushService.extractRemoteUrl(msg);
        return Optional.ofNullable(this.pendingMessagesPerUrl.get(remoteUrl)).map(map -> (Runnable)map.remove(sequenceNumber + 1L));
    }

    private void propagateRbelMessage(RbelElement msg) {
        if (!msg.hasFacet(RbelTcpIpMessageFacet.class)) {
            this.log.trace("Skipping propagation, not a TCP/IP message {}", (Object)msg.getUuid());
            return;
        }
        if (msg.hasFacet(TigerNonPairedMessageFacet.class)) {
            this.sendNonPairedMessage(msg);
        } else if (msg.hasFacet(RbelHttpResponseFacet.class) || msg.getFacet(TracingMessagePairFacet.class).map(facet -> facet.isResponse(msg)).orElse(false).booleanValue()) {
            this.sendPairedMessage(msg);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("Skipping propagation, not a response (facets: {}, uuid: {})", (Object)msg.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ")), (Object)msg.getUuid());
        }
    }

    private void sendNonPairedMessage(RbelElement msg) {
        try {
            RbelTcpIpMessageFacet rbelTcpIpMessageFacet = (RbelTcpIpMessageFacet)msg.getFacetOrFail(RbelTcpIpMessageFacet.class);
            RbelHostname sender = RbelHostname.fromString((String)rbelTcpIpMessageFacet.getSender().getRawStringContent()).orElse(null);
            RbelHostname receiver = RbelHostname.fromString((String)rbelTcpIpMessageFacet.getReceiver().getRawStringContent()).orElse(null);
            this.log.trace("Propagating new non-paired message (ID: {})", (Object)msg.getUuid());
            this.template.convertAndSend((Object)"/topic/traces", (Object)TigerTracingDto.builder().receiver(receiver).sender(sender).requestUuid(msg.getUuid()).requestTransmissionTime(msg.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null)).additionalInformationRequest(this.gatherAdditionalInformation(msg)).sequenceNumberRequest(rbelTcpIpMessageFacet.getSequenceNumber()).build());
            this.mapRbelMessageAndSent(msg);
        }
        catch (RuntimeException e) {
            this.log.error("Error while sending non-paired message: {}", (Object)e.getMessage());
            throw e;
        }
    }

    private void sendPairedMessage(RbelElement response) {
        RbelElement request = response.getFacet(TracingMessagePairFacet.class).map(TracingMessagePairFacet::getRequest).or(() -> response.getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::getRequest)).orElseThrow(() -> new TigerRemoteProxyClientException("Failure to correctly push message with id '" + response.getUuid() + "': Unable to find matching request"));
        RbelTcpIpMessageFacet requestTcpIpFacet = (RbelTcpIpMessageFacet)request.getFacetOrFail(RbelTcpIpMessageFacet.class);
        RbelTcpIpMessageFacet responseTcpIpFacet = (RbelTcpIpMessageFacet)response.getFacetOrFail(RbelTcpIpMessageFacet.class);
        RbelHostname sender = RbelHostname.fromString((String)requestTcpIpFacet.getSender().getRawStringContent()).orElse(null);
        RbelHostname receiver = RbelHostname.fromString((String)requestTcpIpFacet.getReceiver().getRawStringContent()).orElse(null);
        this.log.trace("Propagating new request/response pair (IDs: {} and {})", (Object)request.getUuid(), (Object)response.getUuid());
        this.template.convertAndSend((Object)"/topic/traces", (Object)TigerTracingDto.builder().receiver(receiver).sender(sender).responseUuid(response.getUuid()).requestUuid(request.getUuid()).responseTransmissionTime(response.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null)).requestTransmissionTime(request.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null)).additionalInformationRequest(this.gatherAdditionalInformation(request)).additionalInformationResponse(this.gatherAdditionalInformation(response)).sequenceNumberRequest(requestTcpIpFacet.getSequenceNumber()).sequenceNumberResponse(responseTcpIpFacet.getSequenceNumber()).build());
        this.mapRbelMessageAndSent(request);
        this.mapRbelMessageAndSent(response);
    }

    private Map<String, String> gatherAdditionalInformation(RbelElement msg) {
        JSONObject infoObject = new JSONObject();
        RbelFileWriter.DEFAULT_PRE_SAVE_LISTENER.stream().filter(listener -> !(listener instanceof TcpIpMessageFacetWriter) && !(listener instanceof MessageTimeWriter)).forEach(listener -> listener.preSaveCallback(msg, infoObject));
        return infoObject.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
    }

    private void propagateException(Throwable exception) {
        this.template.convertAndSend((Object)"/topic/errors", (Object)TigerExceptionDto.builder().className(exception.getClass().getName()).message(exception.getMessage()).stacktrace(ExceptionUtils.getStackTrace((Throwable)exception)).build());
    }

    private void mapRbelMessageAndSent(RbelElement rbelMessage) {
        if (rbelMessage == null) {
            return;
        }
        int numberOfParts = rbelMessage.getRawContent().length / 524288 + 1;
        for (int i = 0; i < numberOfParts; ++i) {
            byte[] partContent = Arrays.copyOfRange(rbelMessage.getRawContent(), i * 524288, Math.min((i + 1) * 524288, rbelMessage.getRawContent().length));
            this.log.trace("sending part {} of {} for UUID {}...", new Object[]{i + 1, numberOfParts, rbelMessage.getUuid()});
            this.template.convertAndSend((Object)"/topic/data", (Object)TracingMessagePart.builder().data(partContent).index(i).uuid(rbelMessage.getUuid()).numberOfMessages(numberOfParts).build());
        }
    }

    @ConstructorProperties(value={"template", "tigerProxy"})
    @Generated
    public TracingPushService(SimpMessagingTemplate template, TigerProxy tigerProxy) {
        this.template = template;
        this.tigerProxy = tigerProxy;
    }
}

