/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelElementConvertionPair;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelBinaryFacet;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelNoteFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.facet.TigerNonPairedMessageFacet;
import de.gematik.rbellogger.data.facet.TracingMessagePairFacet;
import de.gematik.rbellogger.util.RbelException;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.mockserver.model.BinaryProxyListener;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.handler.BundledServerNamesAdder;
import de.gematik.test.tiger.proxy.handler.TigerExceptionUtils;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryExchangeHandler
implements BinaryProxyListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryExchangeHandler.class);
    private final BundledServerNamesAdder bundledServerNamesAdder = new BundledServerNamesAdder();
    private final TigerProxy tigerProxy;
    private final Map<Pair<SocketAddress, SocketAddress>, byte[]> bufferedParts = new ConcurrentHashMap<Pair<SocketAddress, SocketAddress>, byte[]>();
    private final Map<Pair<SocketAddress, SocketAddress>, Long> currentSequenceNumber = new ConcurrentHashMap<Pair<SocketAddress, SocketAddress>, Long>();

    @Override
    public void onProxy(BinaryMessage binaryRequest, Optional<CompletableFuture<BinaryMessage>> binaryResponseFuture, SocketAddress serverAddress, SocketAddress clientAddress) {
        try {
            log.trace("Finalizing binary exchange...");
            Optional<RbelElement> convertedRequest = this.convertBinaryMessageOrPushToBuffer(binaryRequest, clientAddress, serverAddress);
            boolean shouldWaitForResponse = this.shouldWaitForResponse(convertedRequest);
            log.trace("Converted request, waiting on response: {}", (Object)shouldWaitForResponse);
            if (!shouldWaitForResponse) {
                convertedRequest.ifPresent(msg -> {
                    msg.addFacet((RbelFacet)new TigerNonPairedMessageFacet());
                    this.getTigerProxy().triggerListener((RbelElement)msg);
                });
            }
            binaryResponseFuture.ifPresent(f -> ((CompletableFuture)((CompletableFuture)f.thenApply(binaryResponse -> this.convertBinaryMessageOrPushToBuffer((BinaryMessage)binaryResponse, serverAddress, clientAddress))).thenAccept(convertedResponse -> {
                if (shouldWaitForResponse) {
                    if (convertedResponse.isPresent() && convertedRequest.isPresent()) {
                        RbelElement request = (RbelElement)convertedRequest.get();
                        RbelElement response = (RbelElement)convertedResponse.get();
                        TracingMessagePairFacet pairFacet = new TracingMessagePairFacet(response, request);
                        request.addOrReplaceFacet((RbelFacet)pairFacet);
                        response.addOrReplaceFacet((RbelFacet)pairFacet);
                        this.getTigerProxy().triggerListener(request);
                        this.getTigerProxy().triggerListener(response);
                    } else {
                        convertedRequest.or(() -> convertedResponse).ifPresent(msg -> {
                            msg.addOrReplaceFacet((RbelFacet)new TigerNonPairedMessageFacet());
                            this.getTigerProxy().triggerListener((RbelElement)msg);
                        });
                    }
                } else {
                    convertedResponse.ifPresent(msg -> {
                        msg.addOrReplaceFacet((RbelFacet)new TigerNonPairedMessageFacet());
                        this.getTigerProxy().triggerListener((RbelElement)msg);
                    });
                }
            })).exceptionally(t -> {
                if (BinaryExchangeHandler.isConnectionResetException(t)) {
                    log.trace("Connection reset:", t);
                } else {
                    log.warn("Exception during Direct-Proxy handling:", t);
                    this.propagateExceptionMessageSafe((Throwable)t);
                }
                return null;
            }));
            log.trace("Returning from BinaryExchangeHandler!");
        }
        catch (RuntimeException e) {
            log.warn("Uncaught exception during handling of request", (Throwable)e);
            this.propagateExceptionMessageSafe(e);
            throw e;
        }
    }

    private static boolean isConnectionResetException(Throwable t) {
        return TigerExceptionUtils.getCauseWithType((Throwable)t, SocketException.class).filter(e -> "Connection reset".equals(e.getMessage())).isPresent();
    }

    private boolean shouldWaitForResponse(Optional<RbelElement> convertedRequest) {
        return convertedRequest.map(RbelElement::getFacets).stream().flatMap(Collection::stream).anyMatch(RbelFacet::shouldExpectReplyMessage);
    }

    private Optional<RbelElement> convertBinaryMessageOrPushToBuffer(BinaryMessage message, SocketAddress senderAddress, SocketAddress receiverAddress) {
        if (message == null) {
            return Optional.empty();
        }
        Optional<RbelElement> rbelMessageOptional = this.tryToConvertMessageAndBufferUnusedBytes(message, senderAddress, receiverAddress);
        if (rbelMessageOptional.isEmpty()) {
            return Optional.empty();
        }
        rbelMessageOptional.get().addFacet((RbelFacet)RbelMessageTimingFacet.builder().transmissionTime(message.getTimestamp().atZone(ZoneId.systemDefault())).build());
        rbelMessageOptional.get().addFacet((RbelFacet)new RbelBinaryFacet());
        log.debug("Finalized binary exchange {}", (Object)rbelMessageOptional.flatMap(msg -> msg.getFacet(RbelTcpIpMessageFacet.class)).map(RbelTcpIpMessageFacet::getSenderHostname).map(Objects::toString).orElse(""));
        return rbelMessageOptional;
    }

    private Optional<RbelElement> tryToConvertMessageAndBufferUnusedBytes(BinaryMessage message, SocketAddress senderAddress, SocketAddress receiverAddress) {
        Pair key = Pair.of((Object)senderAddress, (Object)receiverAddress);
        Optional<RbelElement> requestOptional = this.tryToConvertMessage(this.addBufferToMessage(message, (Pair<SocketAddress, SocketAddress>)key), senderAddress, receiverAddress, (Pair<SocketAddress, SocketAddress>)key);
        if (requestOptional.isPresent()) {
            this.bufferedParts.remove(key);
            this.currentSequenceNumber.remove(key);
        }
        return requestOptional;
    }

    private byte[] addBufferToMessage(BinaryMessage message, Pair<SocketAddress, SocketAddress> key) {
        byte[] bufferedBytes = this.bufferedParts.get(key);
        byte[] resultMessage = message.getBytes();
        if (bufferedBytes != null) {
            resultMessage = Arrays.concatenate((byte[])bufferedBytes, (byte[])resultMessage);
        }
        this.bufferedParts.put(key, resultMessage);
        return resultMessage;
    }

    private Optional<RbelElement> tryToConvertMessage(byte[] messageContent, SocketAddress senderAddress, SocketAddress receiverAddress, Pair<SocketAddress, SocketAddress> connectionKey) {
        RbelElement messageElement = new RbelElement(messageContent, null);
        RbelElement result = this.getTigerProxy().getRbelLogger().getRbelConverter().parseMessage(new RbelElementConvertionPair(messageElement), this.toRbelHostname(senderAddress), this.toRbelHostname(receiverAddress), Optional.empty(), Optional.ofNullable(this.currentSequenceNumber.get(connectionKey)));
        if (result.getFacets().stream().filter(f -> !(f instanceof RbelNoteFacet)).count() <= 1L) {
            Long sequenceNumber = ((RbelTcpIpMessageFacet)result.getFacet(RbelTcpIpMessageFacet.class).orElseThrow(() -> new RbelException("cannot retrieve sequence number"))).getSequenceNumber();
            this.currentSequenceNumber.put(connectionKey, sequenceNumber);
            this.getTigerProxy().getRbelLogger().getRbelConverter().removeMessage(result);
            return Optional.empty();
        }
        this.bundledServerNamesAdder.addBundledServerNameToHostnameFacet(result);
        return Optional.of(result);
    }

    private void propagateExceptionMessageSafe(Throwable exception) {
        try {
            this.tigerProxy.propagateException(exception);
        }
        catch (Exception handlingException) {
            log.warn("While propagating an exception another error occured (ignoring):", (Throwable)handlingException);
        }
    }

    private RbelHostname toRbelHostname(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return RbelHostname.builder().hostname(inetSocketAddress.getHostName()).port(inetSocketAddress.getPort()).build();
        }
        log.warn("Incompatible socketAddress encountered: " + socketAddress.getClass().getSimpleName());
        return null;
    }

    @Generated
    public BundledServerNamesAdder getBundledServerNamesAdder() {
        return this.bundledServerNamesAdder;
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public Map<Pair<SocketAddress, SocketAddress>, byte[]> getBufferedParts() {
        return this.bufferedParts;
    }

    @Generated
    public Map<Pair<SocketAddress, SocketAddress>, Long> getCurrentSequenceNumber() {
        return this.currentSequenceNumber;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryExchangeHandler)) {
            return false;
        }
        BinaryExchangeHandler other = (BinaryExchangeHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BundledServerNamesAdder this$bundledServerNamesAdder = this.getBundledServerNamesAdder();
        BundledServerNamesAdder other$bundledServerNamesAdder = other.getBundledServerNamesAdder();
        if (this$bundledServerNamesAdder == null ? other$bundledServerNamesAdder != null : !this$bundledServerNamesAdder.equals(other$bundledServerNamesAdder)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !((Object)this$tigerProxy).equals(other$tigerProxy)) {
            return false;
        }
        Map<Pair<SocketAddress, SocketAddress>, byte[]> this$bufferedParts = this.getBufferedParts();
        Map<Pair<SocketAddress, SocketAddress>, byte[]> other$bufferedParts = other.getBufferedParts();
        if (this$bufferedParts == null ? other$bufferedParts != null : !((Object)this$bufferedParts).equals(other$bufferedParts)) {
            return false;
        }
        Map<Pair<SocketAddress, SocketAddress>, Long> this$currentSequenceNumber = this.getCurrentSequenceNumber();
        Map<Pair<SocketAddress, SocketAddress>, Long> other$currentSequenceNumber = other.getCurrentSequenceNumber();
        return !(this$currentSequenceNumber == null ? other$currentSequenceNumber != null : !((Object)this$currentSequenceNumber).equals(other$currentSequenceNumber));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BinaryExchangeHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BundledServerNamesAdder $bundledServerNamesAdder = this.getBundledServerNamesAdder();
        result = result * 59 + ($bundledServerNamesAdder == null ? 43 : $bundledServerNamesAdder.hashCode());
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : ((Object)$tigerProxy).hashCode());
        Map<Pair<SocketAddress, SocketAddress>, byte[]> $bufferedParts = this.getBufferedParts();
        result = result * 59 + ($bufferedParts == null ? 43 : ((Object)$bufferedParts).hashCode());
        Map<Pair<SocketAddress, SocketAddress>, Long> $currentSequenceNumber = this.getCurrentSequenceNumber();
        result = result * 59 + ($currentSequenceNumber == null ? 43 : ((Object)$currentSequenceNumber).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BinaryExchangeHandler(bundledServerNamesAdder=" + this.getBundledServerNamesAdder() + ", tigerProxy=" + this.getTigerProxy() + ", bufferedParts=" + this.getBufferedParts() + ", currentSequenceNumber=" + this.getCurrentSequenceNumber() + ")";
    }

    @ConstructorProperties(value={"tigerProxy"})
    @Generated
    public BinaryExchangeHandler(TigerProxy tigerProxy) {
        this.tigerProxy = tigerProxy;
    }
}

