/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.controller;

import com.google.common.html.HtmlEscapers;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.TracingMessagePairFacet;
import de.gematik.rbellogger.data.util.RbelElementTreePrinter;
import de.gematik.rbellogger.file.RbelFileWriter;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.rbellogger.util.RbelJexlExecutor;
import de.gematik.rbellogger.util.RbelPathAble;
import de.gematik.test.tiger.common.exceptions.TigerJexlException;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.configuration.ApplicationConfiguration;
import de.gematik.test.tiger.proxy.data.GetMessagesAfterDto;
import de.gematik.test.tiger.proxy.data.HtmlMessage;
import de.gematik.test.tiger.proxy.data.JexlQueryResponseDto;
import de.gematik.test.tiger.proxy.data.MessageMetaDataDto;
import de.gematik.test.tiger.proxy.data.ResetMessagesDto;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyConfigurationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyWebUiException;
import de.gematik.test.tiger.spring_utils.TigerBuildPropertiesService;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.ButtonTag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.NavTag;
import j2html.tags.specialized.SpanTag;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"webui", "/"})
@Validated
public class TigerWebUiController
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerWebUiController.class);
    private static final String ATTR_DATA_BS_TARGET = "data-bs-target";
    private static final String ATTR_DATA_BS_TOGGLE = "data-bs-toggle";
    private static final String ATTR_ARIA_HASPOPUP = "aria-haspopup";
    private static final String ATTR_ARIA_CONTROLS = "aria-controls";
    private static final String ATTR_ON_CLICK = "onClick";
    private static final String CSS_BTN_DARK = "btn btn-dark";
    private static final String CSS_BTN_OUTLINE_SUCCESS = "btn btn-outline-success";
    private static final String CSS_COLOR_INHERIT = "color:inherit;";
    private static final String CSS_DROPDOWN_TOGGLE_BTN_BTN_DARK = "btn btn-dark dropdown-toggle";
    private static final String CSS_DROPDOWN_ITEM = "dropdown-item";
    private static final String CSS_NAVBAR_ITEM = "navbar-item test-navbar-item";
    private static final String CSS_NAVBAR_ITEM_NOT4EMBEDDED = "navbar-item test-navbar-item not4embedded test-webui-navbar-item-notembedded";
    private static final String DROPDOWN_MENU = "dropdown-menu";
    private static final String VALUE_MODAL = "modal";
    private static final String HIDE_QUIT = "display:none;";
    private static final String BUTTON_GROUP_DROPUP = "btn-group dropup";
    public static final String REGEX_STATUSCODE_TOKEN = ".*:\\d* ";
    public static final String DROPDOWN = "dropdown";
    private TigerProxy tigerProxy;
    private final RbelHtmlRenderer renderer;
    private final ApplicationConfiguration applicationConfiguration;
    private ApplicationContext applicationContext;
    public final SimpMessagingTemplate template;
    private final TigerBuildPropertiesService buildProperties;
    private static final String WS_NEWMESSAGES = "/topic/ws";

    @PostConstruct
    public void addWebSocketListener() {
        this.renderer.setSubTitle(this.getVersionStringAsRawHtml() + this.renderer.getSubTitle());
    }

    public void informClientOfNewMessageArrival(RbelElement element) {
        log.trace("Pushing new message (uUID: {}) from proxy {} to webUI-clients", (Object)element.getUuid(), (Object)this.tigerProxy.proxyName());
        this.template.convertAndSend((Object)WS_NEWMESSAGES, (Object)element.getUuid());
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.applicationContext = appContext;
    }

    @GetMapping(value={"/trafficLog*.tgr"}, produces={"application/octet-stream"})
    public String downloadTraffic(@RequestParam(name="lastMsgUuid", required=false) String lastMsgUuid, @RequestParam(name="filterCriterion", required=false) String filterCriterion, @RequestParam(name="pageSize", required=false) Optional<Integer> pageSize, HttpServletResponse response) {
        int actualPageSize = pageSize.orElse(this.getApplicationConfiguration().getMaximumTrafficDownloadPageSize());
        List<RbelElement> filteredMessages = this.loadMessagesMatchingFilter(lastMsgUuid, filterCriterion);
        int returnedMessages = Math.min(filteredMessages.size(), actualPageSize);
        response.addHeader("available-messages", String.valueOf(filteredMessages.size()));
        response.addHeader("returned-messages", String.valueOf(returnedMessages));
        String result = filteredMessages.stream().limit(actualPageSize).map(arg_0 -> ((RbelFileWriter)this.tigerProxy.getRbelFileWriter()).convertToRbelFileString(arg_0)).collect(Collectors.joining("\n\n"));
        if (!result.isEmpty()) {
            response.addHeader("last-uuid", filteredMessages.get(returnedMessages - 1).getUuid());
        }
        return result;
    }

    @GetMapping(value={"/tiger-report*.html"}, produces={"text/html"})
    public String downloadHtml(@RequestParam(name="lastMsgUuid", required=false) String lastMsgUuid, @RequestParam(name="filterCriterion", required=false) String filterCriterion) {
        RbelHtmlRenderer rbelRenderer = new RbelHtmlRenderer();
        rbelRenderer.setVersionInfo(this.buildProperties.tigerVersionAsString());
        rbelRenderer.setTitle("RbelLog f\u00fcr " + this.tigerProxy.getName().orElse("Tiger Proxy - Port") + ":" + this.tigerProxy.getProxyPort());
        List<RbelElement> rbelMessages = this.loadMessagesMatchingFilter(lastMsgUuid, filterCriterion);
        return rbelRenderer.doRender(rbelMessages);
    }

    @GetMapping(value={""}, produces={"text/html"})
    public String getUI(@RequestParam(name="embedded", defaultValue="false") boolean embedded) {
        String html = this.renderer.getEmptyPage(this.applicationConfiguration.isLocalResources());
        String targetDiv = embedded ? "<div class=\"col msglist embeddedlist\" id=\"rbelembeddedlist\">" : "<div class=\"col ms-6 msglist\" id=\"rbelmsglist\">";
        html = this.addTigerProxyJsAndCss(html.replace("<div class=\"col ms-6\">", targetDiv));
        String showQuit = this.tigerProxy.getTigerProxyConfiguration().isStandalone() ? "" : HIDE_QUIT;
        String navbar = embedded ? this.createNavbar(this.tigerProxy, "margin-bottom: 3.5em;", "margin-inline: auto;", showQuit) : this.createNavbar(this.tigerProxy, "", "", showQuit);
        return html.replace("<div id=\"navbardiv\"></div>", navbar + this.loadResourceToString("/routeModal.html") + this.loadResourceToString("/filterModal.html") + this.loadResourceToString("/jexlModal.html") + this.loadResourceToString("/saveModal.html") + this.loadResourceToString("/errorMessagesModal.html"));
    }

    private String getVersionStringAsRawHtml() {
        return "<div class=\"is-size-6\" style=\"text-align: right;margin-bottom: 1rem!important;margin-right: 1.5em;\">" + this.buildProperties.tigerVersionAsString() + " - " + this.buildProperties.tigerBuildDateAsString() + "</div>";
    }

    private String createNavbar(TigerProxy tigerProxy, String styleNavbar, String styleNavbarStart, String styleQuit) {
        return ((NavTag)((NavTag)((NavTag)((NavTag)TagCreator.nav().withClass("navbar bg-dark fixed-bottom")).withId("webui-navbar")).withStyle(styleNavbar)).with((DomContent)((DivTag)TagCreator.div().withClass("container-fluid")).with((DomContent)((DivTag)TagCreator.div().withStyle(styleNavbarStart)).with(new DomContent[]{((DivTag)TagCreator.div().withClass(CSS_NAVBAR_ITEM_NOT4EMBEDDED)).with((DomContent)((ButtonTag)((ButtonTag)((ButtonTag)((ButtonTag)TagCreator.button().withId("routeModalBtn")).withClass(CSS_BTN_OUTLINE_SUCCESS)).attr(ATTR_DATA_BS_TARGET, (Object)"#routeModalDialog")).attr(ATTR_DATA_BS_TOGGLE, (Object)VALUE_MODAL)).with(new DomContent[]{TagCreator.i().withClass("fas fa-exchange-alt"), ((SpanTag)TagCreator.span((String)"Routes").withClass("ms-2")).withStyle(CSS_COLOR_INHERIT)})), ((DivTag)TagCreator.div().withClass(CSS_NAVBAR_ITEM_NOT4EMBEDDED)).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("scrollLockBtn")).withClass(CSS_BTN_DARK)).with(new DomContent[]{((DivTag)TagCreator.div().withId("scrollLockLed")).withClass("led"), TagCreator.span((String)"Scroll Lock")})), ((DivTag)TagCreator.div().withClass(CSS_NAVBAR_ITEM)).with((DomContent)((DivTag)((DivTag)TagCreator.div().withId("dropdown-hide-button")).withClass(BUTTON_GROUP_DROPUP)).with(new DomContent[]{((ButtonTag)((ButtonTag)((ButtonTag)((ButtonTag)((ButtonTag)TagCreator.button().withClass(CSS_DROPDOWN_TOGGLE_BTN_BTN_DARK)).attr(ATTR_DATA_BS_TOGGLE, (Object)DROPDOWN)).attr(ATTR_ARIA_HASPOPUP, (Object)"true")).attr(ATTR_ARIA_CONTROLS, (Object)DROPDOWN_MENU)).attr("type", (Object)"button")).with((DomContent)((SpanTag)TagCreator.span().withClass("icon is-small")).with((DomContent)TagCreator.i().withClass("fa-solid fa-toggle-on"))), ((DivTag)((DivTag)TagCreator.div().withClass("dropdown-menu bg-dark")).attr("type", (Object)"menu")).with(new DomContent[]{((DivTag)TagCreator.div().withClass(CSS_DROPDOWN_ITEM)).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("collapsibleMessageHeaderBtn")).withClass(CSS_BTN_DARK)).with(new DomContent[]{((DivTag)TagCreator.div().withId("collapsibleMessageHeader")).withClass("led"), TagCreator.span((String)"Hide Headers")})), ((DivTag)TagCreator.div().withClass(CSS_DROPDOWN_ITEM)).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("collapsibleMessageDetailsBtn")).withClass(CSS_BTN_DARK)).with(new DomContent[]{((DivTag)TagCreator.div().withId("collapsibleMessageDetails")).withClass("led"), TagCreator.span((String)"Hide Details")}))})})), ((DivTag)TagCreator.div().withClass(CSS_NAVBAR_ITEM)).with((DomContent)((ButtonTag)((ButtonTag)((ButtonTag)((ButtonTag)TagCreator.button().withId("filterModalBtn")).withClass(CSS_BTN_OUTLINE_SUCCESS)).attr(ATTR_DATA_BS_TARGET, (Object)"#filterModalDialog")).attr(ATTR_DATA_BS_TOGGLE, (Object)VALUE_MODAL)).with(new DomContent[]{TagCreator.i().withClass("fas fa-filter"), ((SpanTag)TagCreator.span((String)"Filter").withClass("ms-2")).withStyle(CSS_COLOR_INHERIT)})), ((DivTag)TagCreator.div().withClass(CSS_NAVBAR_ITEM_NOT4EMBEDDED)).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("resetMsgs")).withClass("btn btn-outline-danger")).with(new DomContent[]{TagCreator.i().withClass("far fa-trash-alt"), ((SpanTag)TagCreator.span((String)"Reset").withClass("ms-2")).withStyle(CSS_COLOR_INHERIT)})), ((DivTag)TagCreator.div().withClass(CSS_NAVBAR_ITEM)).with((DomContent)((DivTag)((DivTag)TagCreator.div().withId("dropdown-page-selection")).withClass(BUTTON_GROUP_DROPUP)).with(new DomContent[]{((ButtonTag)((ButtonTag)((ButtonTag)((ButtonTag)((ButtonTag)TagCreator.button().withClass(CSS_DROPDOWN_TOGGLE_BTN_BTN_DARK)).attr(ATTR_DATA_BS_TOGGLE, (Object)DROPDOWN)).attr(ATTR_ARIA_HASPOPUP, (Object)"true")).attr(ATTR_ARIA_CONTROLS, (Object)DROPDOWN_MENU)).attr("type", (Object)"button")).with((DomContent)((SpanTag)TagCreator.span().withText("Page 1")).withId("pageNumberDisplay")), ((DivTag)((DivTag)TagCreator.div().withClass(DROPDOWN_MENU)).attr("type", (Object)"menu")).with((DomContent)((DivTag)((DivTag)TagCreator.div().withClass("dropdown-content")).withId("pageSelector")).with((DomContent)((ATag)((ATag)TagCreator.a().withClass(CSS_DROPDOWN_ITEM)).attr(ATTR_ON_CLICK, (Object)"setPageNumber(0)")).withText("1")))})), ((DivTag)TagCreator.div().withClass(CSS_NAVBAR_ITEM)).with((DomContent)((DivTag)((DivTag)TagCreator.div().withId("dropdown-page-size")).withClass(BUTTON_GROUP_DROPUP)).with(new DomContent[]{((ButtonTag)((ButtonTag)((ButtonTag)((ButtonTag)TagCreator.button().withClass(CSS_DROPDOWN_TOGGLE_BTN_BTN_DARK)).attr(ATTR_DATA_BS_TOGGLE, (Object)DROPDOWN)).attr(ATTR_ARIA_HASPOPUP, (Object)"true")).attr(ATTR_ARIA_CONTROLS, (Object)DROPDOWN_MENU)).with((DomContent)((SpanTag)TagCreator.span().withId("pageSizeDisplay")).withText("Size")), ((DivTag)((DivTag)TagCreator.div().withClass(DROPDOWN_MENU)).attr("role", (Object)"menu")).with((DomContent)((DivTag)((DivTag)TagCreator.div().withClass("dropdown-content")).withId("sizeSelector")).with(new DomContent[]{((ATag)((ATag)TagCreator.a().withClass(CSS_DROPDOWN_ITEM)).attr(ATTR_ON_CLICK, (Object)"setPageSize(10);")).withText("10"), ((ATag)((ATag)TagCreator.a().withClass(CSS_DROPDOWN_ITEM)).attr(ATTR_ON_CLICK, (Object)"setPageSize(20);")).withText("20"), ((ATag)((ATag)TagCreator.a().withClass(CSS_DROPDOWN_ITEM)).attr(ATTR_ON_CLICK, (Object)"setPageSize(50);")).withText("50"), ((ATag)((ATag)TagCreator.a().withClass(CSS_DROPDOWN_ITEM)).attr(ATTR_ON_CLICK, (Object)"setPageSize(100);")).withText("100")}))})), ((DivTag)TagCreator.div().withClass(CSS_NAVBAR_ITEM_NOT4EMBEDDED)).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("importMsgs")).withClass(CSS_BTN_OUTLINE_SUCCESS)).with(new DomContent[]{TagCreator.i().withClass("fa-solid fa-file-import"), ((SpanTag)TagCreator.span((String)"Import").withClass("ms-2")).withStyle(CSS_COLOR_INHERIT)})), ((DivTag)TagCreator.div().withClass(CSS_NAVBAR_ITEM)).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("exportMsgs")).withClass(CSS_BTN_OUTLINE_SUCCESS)).with(new DomContent[]{TagCreator.i().withClass("fa-solid fa-file-export"), ((SpanTag)TagCreator.span((String)"Export").withClass("ms-2")).withStyle(CSS_COLOR_INHERIT)})), ((DivTag)TagCreator.div().withClass(CSS_NAVBAR_ITEM_NOT4EMBEDDED)).with(new DomContent[]{TagCreator.span((String)"Proxy port "), TagCreator.b((String)String.valueOf(tigerProxy.getProxyPort())).withClass("ms-3")}), ((DivTag)((DivTag)TagCreator.div().withClass(CSS_NAVBAR_ITEM_NOT4EMBEDDED)).withStyle(styleQuit)).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("quitProxy")).withClass("btn btn-outline-danger")).with(new DomContent[]{TagCreator.i().withClass("fas fa-power-off"), ((SpanTag)TagCreator.span((String)"Quit").withClass("ms-2")).withStyle(CSS_COLOR_INHERIT)}))})))).render();
    }

    private String addTigerProxyJsAndCss(String html) {
        Document jsoup = Jsoup.parse((String)html);
        Element mainWebUiScript = jsoup.getElementById("mainWebUiScript");
        if (mainWebUiScript == null) {
            throw new TigerProxyWebUiException("Unable to embed proxy scripts into webui!");
        }
        Element addScript = new Element("script");
        addScript.attr("type", "module");
        addScript.attr("id", "tigerProxyScript");
        addScript.appendChild((Node)new DataNode(this.loadResourceToString("/tigerProxy.js")));
        mainWebUiScript.after((Node)addScript);
        Element rbelCss = jsoup.getElementById("rbel_css");
        if (rbelCss == null) {
            throw new TigerProxyWebUiException("Unable to embed proxy css into webui!");
        }
        Element addCss = new Element("style");
        addCss.attr("id", "tigerProxy_css");
        addCss.appendChild((Node)new DataNode(this.loadResourceToString("/proxy.css")));
        rbelCss.after((Node)addCss);
        return jsoup.html();
    }

    private String loadResourceToString(String resourceName) {
        InputStream resource = this.getClass().getResourceAsStream(resourceName);
        if (resource == null) {
            throw new TigerProxyConfigurationException("Unable to load resource '" + resourceName + "' !");
        }
        try {
            return IOUtils.toString((InputStream)resource, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new TigerProxyWebUiException("Exception while loading resource '" + resourceName + "'", e);
        }
    }

    @GetMapping(value={"/css/{cssfile}"}, produces={"text/css"})
    public String getCSS(@PathVariable(value="cssfile") String cssFile) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/css/" + cssFile);){
            if (is == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "css file " + cssFile + " not found");
            }
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @GetMapping(value={"/testJexlQuery"}, produces={"application/json"})
    public JexlQueryResponseDto testJexlQuery(@RequestParam(name="msgUuid") String msgUuid, @RequestParam(name="query") String query) {
        RbelElement targetMessage = this.getTigerProxy().getRbelLogger().getMessageHistory().stream().filter(msg -> msg.getUuid().equals(msgUuid)).findFirst().orElseThrow();
        TigerJexlContext messageContext = TigerJexlExecutor.buildJexlMapContext((Object)targetMessage, Optional.empty());
        try {
            return JexlQueryResponseDto.builder().rbelTreeHtml(this.createRbelTreeForElement(targetMessage, false)).matchSuccessful(TigerJexlExecutor.matchesAsJexlExpression((Object)targetMessage, (String)query)).messageContext((Map<String, Object>)messageContext).build();
        }
        catch (TigerJexlException | JexlException jexlException) {
            log.warn("Failed to perform JEXL query '" + query + "'", jexlException);
            String msg2 = jexlException.getMessage();
            msg2 = msg2.replaceAll(REGEX_STATUSCODE_TOKEN, "");
            return JexlQueryResponseDto.builder().rbelTreeHtml(this.createRbelTreeForElement(targetMessage, false)).errorMessage(msg2).build();
        }
        catch (RuntimeException rte) {
            log.warn("Runtime failure while performing JEXL query '" + query + "'", (Throwable)rte);
            String msg3 = rte.getMessage();
            msg3 = msg3.replaceAll(REGEX_STATUSCODE_TOKEN, "");
            return JexlQueryResponseDto.builder().rbelTreeHtml(this.createRbelTreeForElement(targetMessage, false)).errorMessage(msg3).build();
        }
    }

    @GetMapping(value={"/testRbelExpression"}, produces={"application/json"})
    public JexlQueryResponseDto testRbelExpression(@RequestParam(name="msgUuid") String msgUuid, @RequestParam(name="rbelPath") String rbelPath) {
        List targetElements = this.getTigerProxy().getRbelLogger().getMessageHistory().stream().filter(msg -> msg.getUuid().equals(msgUuid)).map(msg -> msg.findRbelPathMembers(rbelPath)).flatMap(Collection::stream).toList();
        if (targetElements.isEmpty()) {
            return JexlQueryResponseDto.builder().build();
        }
        try {
            return JexlQueryResponseDto.builder().rbelTreeHtml(this.createRbelTreeForElement((RbelElement)targetElements.get(0), true)).elements(targetElements.stream().map(RbelPathAble::findNodePath).map(key -> "$." + key).toList()).build();
        }
        catch (TigerJexlException | JexlException jexlException) {
            log.warn("Failed to perform RBelPath query '" + rbelPath + "'", jexlException);
            String msg2 = jexlException.getMessage();
            msg2 = msg2.replaceAll(REGEX_STATUSCODE_TOKEN, "");
            return JexlQueryResponseDto.builder().rbelTreeHtml("<span>RbelPath is invalid '" + msg2 + "'</span>").errorMessage(msg2).build();
        }
        catch (RuntimeException rte) {
            log.warn("Runtime failure while performing RbelPath query '" + rbelPath + "'", (Throwable)rte);
            String msg3 = rte.getMessage();
            msg3 = msg3.replaceAll(REGEX_STATUSCODE_TOKEN, "");
            return JexlQueryResponseDto.builder().rbelTreeHtml("<span>Error while parsing RbelPath '" + msg3 + "'</span>").errorMessage(msg3).build();
        }
    }

    private String createRbelTreeForElement(RbelElement targetElement, boolean addJexlResponseLinkCssClass) {
        return HtmlEscapers.htmlEscaper().escape(RbelElementTreePrinter.builder().rootElement(targetElement).printFacets(false).build().execute()).replace(RbelAnsiColors.RESET.toString(), "</span>").replace(RbelAnsiColors.RED_BOLD.toString(), "<span class='text-warning " + (addJexlResponseLinkCssClass ? "jexlResponseLink' style='cursor: pointer;'" : "'") + ">").replace(RbelAnsiColors.CYAN.toString(), "<span class='text-info'>").replace(RbelAnsiColors.YELLOW_BRIGHT.toString(), "<span class='text-danger has-text-weight-bold'>").replace(RbelAnsiColors.GREEN.toString(), "<span class='text-warning'>").replace(RbelAnsiColors.BLUE.toString(), "<span class='text-success'>").replace("\n", "<br/>");
    }

    @GetMapping(value={"/webfonts/{fontfile}"}, produces={"text/css"})
    public ResponseEntity<byte[]> getWebFont(@PathVariable(value="fontfile") String fontFile) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/webfonts/" + fontFile);){
            if (is == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "webfont file " + fontFile + " not found");
            }
            ResponseEntity responseEntity = new ResponseEntity((Object)IOUtils.toByteArray((InputStream)is), (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
    }

    @GetMapping(value={"/getMsgAfter"}, produces={"application/json"})
    public GetMessagesAfterDto getMessagesAfter(@RequestParam(name="lastMsgUuid", required=false) String lastMsgUuid, @RequestParam(name="filterCriterion", required=false) String filterCriterion, @RequestParam(name="pageSize", defaultValue="1000000") int pageSize, @RequestParam(name="pageNumber", defaultValue="0") int pageNumber) {
        log.debug("requesting messages since " + lastMsgUuid + " (filtered by . " + filterCriterion + ")");
        List<RbelElement> msgs = this.loadMessagesMatchingFilter(lastMsgUuid, filterCriterion);
        GetMessagesAfterDto result = new GetMessagesAfterDto();
        result.setLastMsgUuid(lastMsgUuid);
        result.setHtmlMsgList(msgs.stream().skip((long)pageNumber * (long)pageSize).limit(pageSize).map(msg -> HtmlMessage.builder().html(new RbelHtmlRenderingToolkit(this.renderer).convertMessage(msg).render()).uuid(msg.getUuid()).sequenceNumber(MessageMetaDataDto.getElementSequenceNumber(msg)).build()).toList());
        result.setMetaMsgList(msgs.stream().map(MessageMetaDataDto::createFrom).toList());
        result.setTotalMsgCount(this.tigerProxy.getRbelLogger().getMessageHistory().size());
        log.info("Returning {} messages ({} in menu, {} filtered) of total {}", new Object[]{result.getHtmlMsgList().size(), result.getMetaMsgList().size(), msgs.size(), this.tigerProxy.getRbelLogger().getMessageHistory().size()});
        return result;
    }

    private List<RbelElement> loadMessagesMatchingFilter(String lastMsgUuid, String filterCriterion) {
        return this.getTigerProxy().getRbelLogger().getMessageHistory().stream().filter(msg -> {
            if (StringUtils.isEmpty((CharSequence)filterCriterion)) {
                return true;
            }
            if (filterCriterion.startsWith("\"") && filterCriterion.endsWith("\"")) {
                String textFilter = filterCriterion.substring(1, filterCriterion.length() - 1);
                return RbelJexlExecutor.matchAsTextExpression((Object)msg, (String)textFilter) || RbelJexlExecutor.matchAsTextExpression((Object)this.findPartner((RbelElement)msg), (String)textFilter);
            }
            return TigerJexlExecutor.matchesAsJexlExpression((Object)msg, (String)filterCriterion, Optional.empty()) || TigerJexlExecutor.matchesAsJexlExpression((Object)this.findPartner((RbelElement)msg), (String)filterCriterion, Optional.empty());
        }).dropWhile(TigerWebUiController.messageIsBefore(lastMsgUuid)).filter(msg -> !msg.getUuid().equals(lastMsgUuid)).toList();
    }

    private static Predicate<RbelElement> messageIsBefore(String lastMsgUuid) {
        return msg -> {
            if (StringUtils.isEmpty((CharSequence)lastMsgUuid)) {
                return false;
            }
            return !msg.getUuid().equals(lastMsgUuid);
        };
    }

    private RbelElement findPartner(RbelElement msg) {
        return msg.getFacet(TracingMessagePairFacet.class).map(pairFacet -> {
            if (pairFacet.getRequest() == msg) {
                return pairFacet.getResponse();
            }
            return pairFacet.getRequest();
        }).orElse(null);
    }

    @GetMapping(value={"/resetMsgs"}, produces={"application/json"})
    public ResetMessagesDto resetMessages() {
        log.info("Resetting currently recorded messages on rbel logger..");
        int size = this.getTigerProxy().getRbelLogger().getMessageHistory().size();
        ResetMessagesDto result = new ResetMessagesDto();
        result.setNumMsgs(size);
        this.getTigerProxy().getRbelLogger().clearAllMessages();
        return result;
    }

    @GetMapping(value={"/quit"}, produces={"application/json"})
    public void quitProxy(@RequestParam(name="noSystemExit", required=false) String noSystemExit) {
        log.info("Shutting down tiger standalone proxy at port " + this.tigerProxy.getProxyPort() + "...");
        this.tigerProxy.close();
        log.info("Shutting down tiger standalone proxy ui...");
        int exitCode = SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        if (exitCode != 0) {
            log.warn("Exit of tiger proxy ui not successful - exit code: " + exitCode);
        }
        if (StringUtils.isEmpty((CharSequence)noSystemExit)) {
            System.exit(0);
        }
    }

    @PostMapping(value={"/importTraffic"})
    public void importTrafficFromFile(@RequestBody String rawTraffic) {
        this.tigerProxy.readTrafficFromString(rawTraffic);
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public RbelHtmlRenderer getRenderer() {
        return this.renderer;
    }

    @Generated
    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public SimpMessagingTemplate getTemplate() {
        return this.template;
    }

    @Generated
    public TigerBuildPropertiesService getBuildProperties() {
        return this.buildProperties;
    }

    @Generated
    public void setTigerProxy(TigerProxy tigerProxy) {
        this.tigerProxy = tigerProxy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerWebUiController)) {
            return false;
        }
        TigerWebUiController other = (TigerWebUiController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !((Object)this$tigerProxy).equals(other$tigerProxy)) {
            return false;
        }
        RbelHtmlRenderer this$renderer = this.getRenderer();
        RbelHtmlRenderer other$renderer = other.getRenderer();
        if (this$renderer == null ? other$renderer != null : !this$renderer.equals(other$renderer)) {
            return false;
        }
        ApplicationConfiguration this$applicationConfiguration = this.getApplicationConfiguration();
        ApplicationConfiguration other$applicationConfiguration = other.getApplicationConfiguration();
        if (this$applicationConfiguration == null ? other$applicationConfiguration != null : !((Object)((Object)this$applicationConfiguration)).equals((Object)other$applicationConfiguration)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        SimpMessagingTemplate this$template = this.getTemplate();
        SimpMessagingTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        TigerBuildPropertiesService this$buildProperties = this.getBuildProperties();
        TigerBuildPropertiesService other$buildProperties = other.getBuildProperties();
        return !(this$buildProperties == null ? other$buildProperties != null : !this$buildProperties.equals(other$buildProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerWebUiController;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : ((Object)$tigerProxy).hashCode());
        RbelHtmlRenderer $renderer = this.getRenderer();
        result = result * 59 + ($renderer == null ? 43 : $renderer.hashCode());
        ApplicationConfiguration $applicationConfiguration = this.getApplicationConfiguration();
        result = result * 59 + ($applicationConfiguration == null ? 43 : ((Object)((Object)$applicationConfiguration)).hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        SimpMessagingTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        TigerBuildPropertiesService $buildProperties = this.getBuildProperties();
        result = result * 59 + ($buildProperties == null ? 43 : $buildProperties.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TigerWebUiController(tigerProxy=" + this.getTigerProxy() + ", renderer=" + this.getRenderer() + ", applicationConfiguration=" + this.getApplicationConfiguration() + ", applicationContext=" + this.getApplicationContext() + ", template=" + this.getTemplate() + ", buildProperties=" + this.getBuildProperties() + ")";
    }

    @ConstructorProperties(value={"renderer", "applicationConfiguration", "template", "buildProperties"})
    @Generated
    public TigerWebUiController(RbelHtmlRenderer renderer, ApplicationConfiguration applicationConfiguration, SimpMessagingTemplate template, TigerBuildPropertiesService buildProperties) {
        this.renderer = renderer;
        this.applicationConfiguration = applicationConfiguration;
        this.template = template;
        this.buildProperties = buildProperties;
    }
}

