/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.controller;

import de.gematik.test.tiger.common.config.RbelModificationDescription;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.data.ModificationDto;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class TigerModificationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerModificationController.class);
    private final TigerProxy tigerProxy;

    @PutMapping(value={"/modification"}, consumes={"application/json"})
    public ModificationDto addModification(@RequestBody ModificationDto addModificationDto) {
        RbelModificationDescription modification = this.tigerProxy.addModificaton(RbelModificationDescription.builder().name(addModificationDto.getName()).condition(addModificationDto.getCondition()).targetElement(addModificationDto.getTargetElement()).replaceWith(addModificationDto.getReplaceWith()).regexFilter(addModificationDto.getRegexFilter()).build());
        return ModificationDto.from(modification);
    }

    @GetMapping(value={"/modification"}, produces={"application/json"})
    public List<ModificationDto> getModifications() {
        return this.tigerProxy.getModifications().stream().map(ModificationDto::from).toList();
    }

    @DeleteMapping(value={"/modification/{name}"})
    public void deleteModification(@PathVariable(value="name") String name) {
        this.tigerProxy.removeModification(name);
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerModificationController)) {
            return false;
        }
        TigerModificationController other = (TigerModificationController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        return !(this$tigerProxy == null ? other$tigerProxy != null : !((Object)this$tigerProxy).equals(other$tigerProxy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerModificationController;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : ((Object)$tigerProxy).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TigerModificationController(tigerProxy=" + this.getTigerProxy() + ")";
    }

    @ConstructorProperties(value={"tigerProxy"})
    @Generated
    public TigerModificationController(TigerProxy tigerProxy) {
        this.tigerProxy = tigerProxy;
    }
}

