/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRoute;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.controller.TigerWebUiController;
import de.gematik.test.tiger.proxy.tracing.TracingPushService;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.simp.SimpMessagingTemplate;

@Configuration
public class TigerProxyConfigurator
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProxyConfigurator.class);
    private TigerProxy tigerProxy;
    private TracingPushService tracingPushService;
    private final SimpMessagingTemplate template;
    private final ServletWebServerApplicationContext webServerAppCtxt;
    private final TigerProxyConfiguration tigerProxyConfiguration;
    private final TigerWebUiController tigerWebUiController;

    @Bean
    public TigerProxy tigerProxy() {
        boolean shouldSubscribeAfterStart = !this.tigerProxyConfiguration.isSkipTrafficEndpointsSubscription();
        this.tigerProxyConfiguration.setSkipTrafficEndpointsSubscription(false);
        this.tigerProxy = new TigerProxy(this.tigerProxyConfiguration);
        this.tracingPushService = new TracingPushService(this.template, this.tigerProxy);
        this.tracingPushService.addWebSocketListener();
        this.tigerWebUiController.setTigerProxy(this.tigerProxy);
        this.tigerProxy.addRbelMessageListener(this.tigerWebUiController::informClientOfNewMessageArrival);
        if (shouldSubscribeAfterStart) {
            this.tigerProxy.subscribeToTrafficEndpoints();
        } else {
            this.tigerProxyConfiguration.setSkipTrafficEndpointsSubscription(true);
        }
        return this.tigerProxy;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void init() {
        if (this.tigerProxy.getTigerProxyConfiguration().getAdminPort() == 0) {
            this.tigerProxy.getTigerProxyConfiguration().setAdminPort(this.webServerAppCtxt.getWebServer().getPort());
        }
        log.info("Adding route for 'http://tiger.proxy'...");
        this.tigerProxy.addRoute(TigerRoute.builder().from("http://tiger.proxy").to("http://localhost:" + this.webServerAppCtxt.getWebServer().getPort()).disableRbelLogging(true).internalRoute(true).build());
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        if (this.tigerProxyConfiguration.getAdminPort() > 0) {
            factory.setPort(this.tigerProxyConfiguration.getAdminPort());
        }
    }

    @ConstructorProperties(value={"template", "webServerAppCtxt", "tigerProxyConfiguration", "tigerWebUiController"})
    @Generated
    public TigerProxyConfigurator(SimpMessagingTemplate template, ServletWebServerApplicationContext webServerAppCtxt, TigerProxyConfiguration tigerProxyConfiguration, TigerWebUiController tigerWebUiController) {
        this.template = template;
        this.webServerAppCtxt = webServerAppCtxt;
        this.tigerProxyConfiguration = tigerProxyConfiguration;
        this.tigerWebUiController = tigerWebUiController;
    }
}

