/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.converter.HttpPairingInBinaryChannelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.util.RbelMessagesSupplier;
import de.gematik.test.tiger.TigerAgent;
import de.gematik.test.tiger.TigerMasterSecretListeners;
import de.gematik.test.tiger.common.config.RbelModificationDescription;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRoute;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerTlsConfiguration;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.netty.MockServer;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAndCertificateFactorySupplier;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.MockServerToRbelConverter;
import de.gematik.test.tiger.proxy.TigerProxyMasterSecretListener;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.configuration.ProxyConfigurationConverter;
import de.gematik.test.tiger.proxy.data.TigerConnectionStatus;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyConfigurationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxySslException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyStartupException;
import de.gematik.test.tiger.proxy.handler.BinaryExchangeHandler;
import de.gematik.test.tiger.proxy.handler.ForwardAllCallback;
import de.gematik.test.tiger.proxy.handler.ForwardProxyCallback;
import de.gematik.test.tiger.proxy.handler.ReverseProxyCallback;
import de.gematik.test.tiger.proxy.tls.DynamicTigerKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.tls.OcspUtils;
import de.gematik.test.tiger.proxy.tls.StaticTigerKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.tls.TlsCertificateGenerator;
import io.netty.handler.ssl.SslProvider;
import jakarta.annotation.PreDestroy;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.buf.UriUtil;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class TigerProxy
extends AbstractTigerProxy
implements AutoCloseable,
RbelMessagesSupplier {
    private static final String CA_CERT_ALIAS = "caCert";
    private final List<DynamicTigerKeyAndCertificateFactory> tlsFactories = new ArrayList<DynamicTigerKeyAndCertificateFactory>();
    private final List<Consumer<Throwable>> exceptionListeners = new ArrayList<Consumer<Throwable>>();
    private final MockServerToRbelConverter mockServerToRbelConverter;
    private final Map<String, TigerRoute> tigerRouteMap = new HashMap<String, TigerRoute>();
    private final List<TigerRemoteProxyClient> remoteProxyClients = new ArrayList<TigerRemoteProxyClient>();
    private final UUID healthEndpointRequestUuid = UUID.randomUUID();
    private MockServer mockServer;
    private TigerPkiIdentity generatedRootCa;

    public TigerProxy(TigerProxyConfiguration configuration) {
        super(configuration);
        this.mockServerToRbelConverter = new MockServerToRbelConverter(this.getRbelLogger().getRbelConverter());
        this.bootMockServer();
        if (configuration.getModifications() != null) {
            int counter = 0;
            for (RbelModificationDescription modification : configuration.getModifications()) {
                if (modification.getName() == null) {
                    modification.setName("TigerModification #" + counter++);
                }
                this.getRbelLogger().getRbelModifier().addModification(modification);
            }
        }
    }

    private static void customizeServerBuilderCustomizer(MockServerConfiguration mockServerConfiguration, TigerTlsConfiguration tlsConfiguration) {
        mockServerConfiguration.sslServerContextBuilderCustomizer(builder -> {
            if (tlsConfiguration.getServerSslSuites() != null) {
                builder.ciphers((Iterable)tlsConfiguration.getServerSslSuites());
            }
            if (tlsConfiguration.getServerTlsProtocols() != null) {
                builder.protocols((Iterable)tlsConfiguration.getServerTlsProtocols());
            }
            if (tlsConfiguration.getOcspSignerIdentity() != null) {
                builder.enableOcsp(true);
                mockServerConfiguration.ocspResponseSupplier(certificate -> OcspUtils.buildOcspResponse(certificate, tlsConfiguration.getOcspSignerIdentity()));
                builder.sslProvider(SslProvider.OPENSSL);
            } else {
                builder.sslProvider(SslProvider.JDK);
                builder.sslContextProvider((Provider)new BouncyCastleJsseProvider());
            }
            return builder;
        });
    }

    private static void customizeClientBuilderCustomizer(MockServerConfiguration mockServerConfiguration, TigerTlsConfiguration tlsConfiguration) {
        mockServerConfiguration.sslClientContextBuilderCustomizer(builder -> {
            if (tlsConfiguration.getClientSslSuites() != null) {
                builder.ciphers((Iterable)tlsConfiguration.getClientSslSuites());
            }
            builder.sslProvider(SslProvider.JDK);
            return builder;
        });
    }

    private static URL buildUrlSafe(TigerRoute tigerRoute) {
        try {
            return new URL(tigerRoute.getFrom());
        }
        catch (MalformedURLException e) {
            throw new TigerProxyStartupException("Error while building route", e);
        }
    }

    public void restartMockserver() {
        if (this.getTigerProxyConfiguration().getProxyPort() == null) {
            this.getTigerProxyConfiguration().setProxyPort(Integer.valueOf(this.mockServer.getLocalPort()));
        }
        this.mockServer.stop();
        Map<String, TigerRoute> originalRoutes = Collections.unmodifiableMap(this.tigerRouteMap);
        this.tigerRouteMap.clear();
        this.bootMockServer();
        originalRoutes.values().stream().filter(r -> !r.isInternalRoute()).forEach(r -> {
            try {
                this.addRoute((TigerRoute)r);
            }
            catch (RuntimeException e) {
                this.log.trace("Ignored exception during re-adding of routes", (Throwable)e);
            }
        });
    }

    private void bootMockServer() {
        this.createNewMockServer();
        if (this.getTigerProxyConfiguration().isActivateForwardAllLogging()) {
            this.mockServer.when(HttpRequest.request().setPath(".*"), Integer.MIN_VALUE, List.of()).forward(new ForwardAllCallback(this));
        }
        this.addRoutesToTigerProxy();
    }

    private void createNewMockServer() {
        MockServerConfiguration mockServerConfiguration = MockServerConfiguration.configuration();
        mockServerConfiguration.mockServerName(this.getName().orElse("MockServer"));
        mockServerConfiguration.customKeyAndCertificateFactorySupplier(this.buildKeyAndCertificateFactory());
        this.customizeSslIfApplicable(mockServerConfiguration);
        mockServerConfiguration.enableTlsTermination(this.getTigerProxyConfiguration().isActivateTlsTermination());
        Optional<ProxyConfiguration> forwardProxyConfig = ProxyConfigurationConverter.convertForwardProxyConfigurationToMockServerConfiguration(this.getTigerProxyConfiguration());
        this.outputForwardProxyConfigLogs(forwardProxyConfig);
        this.mockServer = this.getTigerProxyConfiguration().getDirectReverseProxy() == null ? forwardProxyConfig.map(proxyConfiguration -> new MockServer(mockServerConfiguration, List.of(proxyConfiguration), this.getTigerProxyConfiguration().getPortAsArray())).orElseGet(() -> new MockServer(mockServerConfiguration, this.getTigerProxyConfiguration().getPortAsArray())) : this.spawnDirectInverseTigerProxy(mockServerConfiguration, forwardProxyConfig);
        String proxyName = this.getName().orElse("?");
        this.log.info("Proxy '{}' started on port {}", (Object)proxyName, (Object)this.mockServer.getLocalPort());
    }

    private void addRoutesToTigerProxy() {
        if (this.getTigerProxyConfiguration().getProxyRoutes() != null) {
            for (TigerRoute tigerRoute : this.getTigerProxyConfiguration().getProxyRoutes()) {
                this.addRoute(tigerRoute);
            }
        }
    }

    private MockServer spawnDirectInverseTigerProxy(MockServerConfiguration mockServerConfiguration, Optional<ProxyConfiguration> forwardProxyConfig) {
        mockServerConfiguration.binaryProxyListener(new BinaryExchangeHandler(this));
        if (forwardProxyConfig.isPresent()) {
            throw new TigerProxyStartupException("DirectForwardProxy configured with additional forwardProxy: Not possible! (forwardProxy is always HTTP!)");
        }
        MockServer newMockServer = new MockServer(mockServerConfiguration, this.getTigerProxyConfiguration().getDirectReverseProxy().getPort(), this.getTigerProxyConfiguration().getDirectReverseProxy().getHostname(), this.getTigerProxyConfiguration().getPortAsArray());
        this.addReverseProxyRouteIfNotPresent();
        this.getRbelLogger().getRbelConverter().addFirstPostConversionListener((RbelConverterPlugin)new HttpPairingInBinaryChannelConverter());
        return newMockServer;
    }

    private void addReverseProxyRouteIfNotPresent() {
        if (this.getTigerProxyConfiguration().getProxyRoutes() == null) {
            this.getTigerProxyConfiguration().setProxyRoutes(new ArrayList());
        }
        this.getTigerProxyConfiguration().getProxyRoutes().add(TigerRoute.builder().from("/").to("http://" + this.getTigerProxyConfiguration().getDirectReverseProxy().getHostname() + ":" + this.getTigerProxyConfiguration().getDirectReverseProxy().getPort()).build());
    }

    private void customizeSslIfApplicable(MockServerConfiguration mockServerConfiguration) {
        TigerTlsConfiguration tlsConfiguration = this.getTigerProxyConfiguration().getTls();
        TigerProxy.customizeServerBuilderCustomizer(mockServerConfiguration, tlsConfiguration);
        TigerProxy.customizeClientBuilderCustomizer(mockServerConfiguration, tlsConfiguration);
        this.customizeClientBuilderFunction(mockServerConfiguration, tlsConfiguration);
        if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getMasterSecretsFile() != null) {
            TigerAgent.addListener((TigerMasterSecretListeners)new TigerProxyMasterSecretListener(this.getTigerProxyConfiguration().getTls().getMasterSecretsFile()));
        }
    }

    private void customizeClientBuilderFunction(MockServerConfiguration mockServerConfiguration, TigerTlsConfiguration tlsConfiguration) {
        if (tlsConfiguration.getClientSupportedGroups() != null && !tlsConfiguration.getClientSupportedGroups().isEmpty()) {
            mockServerConfiguration.clientSslContextBuilderFunction(sslContextBuilder -> {
                try {
                    System.setProperty("jdk.tls.namedGroups", String.join((CharSequence)",", tlsConfiguration.getClientSupportedGroups()));
                    sslContextBuilder.sslProvider(SslProvider.JDK);
                    return sslContextBuilder.build();
                }
                catch (SSLException e) {
                    throw new TigerProxySslException("Error while building SSL context in Tiger-Proxy " + this.getName().orElse(""), e);
                }
            });
        }
    }

    private KeyAndCertificateFactorySupplier buildKeyAndCertificateFactory() {
        return (isServerInstance, mockServerConfiguration) -> {
            if (isServerInstance) {
                if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getServerIdentity() != null) {
                    return new StaticTigerKeyAndCertificateFactory((TigerPkiIdentity)this.getTigerProxyConfiguration().getTls().getServerIdentity());
                }
                DynamicTigerKeyAndCertificateFactory dynamicTigerKeyAndCertificateFactory = new DynamicTigerKeyAndCertificateFactory(this.getTigerProxyConfiguration(), this.determineServerRootCa().orElseThrow(() -> new TigerProxyStartupException("Unrecoverable TLS startup state")), mockServerConfiguration);
                this.tlsFactories.add(dynamicTigerKeyAndCertificateFactory);
                return dynamicTigerKeyAndCertificateFactory;
            }
            if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getForwardMutualTlsIdentity() != null) {
                return new StaticTigerKeyAndCertificateFactory((TigerPkiIdentity)this.getTigerProxyConfiguration().getTls().getForwardMutualTlsIdentity());
            }
            return new DynamicTigerKeyAndCertificateFactory(this.getTigerProxyConfiguration(), new TigerPkiIdentity("CertificateAuthorityCertificate.pem;CertificateAuthorityPrivateKey.pem;PKCS1"), mockServerConfiguration);
        };
    }

    private Optional<TigerPkiIdentity> determineServerRootCa() {
        if (this.getTigerProxyConfiguration().getTls().getServerRootCa() != null) {
            return Optional.of(this.getTigerProxyConfiguration().getTls().getServerRootCa());
        }
        if (this.generatedRootCa == null) {
            this.generatedRootCa = TlsCertificateGenerator.generateNewCaCertificate();
        }
        return Optional.of(this.generatedRootCa);
    }

    public void subscribeToTrafficEndpoints() {
        Optional.of(this.getTigerProxyConfiguration()).map(TigerProxyConfiguration::getTrafficEndpoints).ifPresent(this::subscribeToTrafficEndpoints);
    }

    public void subscribeToTrafficEndpoints(List<String> trafficEndpointUrls) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Subscribing to traffic endpoints for Tiger Proxy '{}'. Found {} endpoints", (Object)this.getName().orElse("?"), (Object)trafficEndpointUrls.size());
        }
        ((Stream)Optional.of(trafficEndpointUrls).stream().flatMap(Collection::stream).parallel()).map(url -> new TigerRemoteProxyClient((String)url, TigerProxyConfiguration.builder().downloadInitialTrafficFromEndpoints(this.getTigerProxyConfiguration().isDownloadInitialTrafficFromEndpoints()).trafficEndpointFilterString(this.getTigerProxyConfiguration().getTrafficEndpointFilterString()).name(this.getTigerProxyConfiguration().getName()).failOnOfflineTrafficEndpoints(this.getTigerProxyConfiguration().isFailOnOfflineTrafficEndpoints()).connectionTimeoutInSeconds(this.getTigerProxyConfiguration().getConnectionTimeoutInSeconds()).build(), this)).forEach(this.remoteProxyClients::add);
        this.remoteProxyClients.parallelStream().forEach(TigerRemoteProxyClient::connect);
    }

    @Override
    public String getBaseUrl() {
        return "http://localhost:" + this.mockServer.getLocalPort();
    }

    @Override
    public int getProxyPort() {
        return this.mockServer.getLocalPort();
    }

    public int getAdminPort() {
        return this.getTigerProxyConfiguration().getAdminPort();
    }

    @Override
    public List<TigerRoute> getRoutes() {
        return this.tigerRouteMap.values().stream().toList();
    }

    @Override
    public RbelModificationDescription addModificaton(RbelModificationDescription modification) {
        this.getRbelLogger().getRbelModifier().addModification(modification);
        return modification;
    }

    @Override
    public List<RbelModificationDescription> getModifications() {
        return this.getRbelLogger().getRbelModifier().getModifications();
    }

    @Override
    public void removeModification(String modificationId) {
        this.getRbelLogger().getRbelModifier().deleteModification(modificationId);
    }

    @Override
    public synchronized TigerRoute addRoute(TigerRoute tigerRoute) {
        this.log.info("Adding route {} -> {}", (Object)tigerRoute.getFrom(), (Object)tigerRoute.getTo());
        Expectation[] expectations = this.buildRouteAndReturnExpectation(tigerRoute);
        if (expectations.length > 1) {
            this.log.warn("Unexpected number of expectations created! Got {}, expected 1", (Object)expectations.length);
        }
        if (expectations.length == 0) {
            throw new TigerProxyConfigurationException("Error while adding route from '{}' to '{}': Got 0 new expectations");
        }
        TigerRoute createdTigerRoute = tigerRoute.withId(expectations[0].getId());
        this.tigerRouteMap.put(expectations[0].getId(), createdTigerRoute);
        this.log.debug("Created route from {} to {}", (Object)tigerRoute.getFrom(), (Object)tigerRoute.getTo());
        return createdTigerRoute;
    }

    private Expectation[] buildRouteAndReturnExpectation(TigerRoute tigerRoute) {
        if (UriUtil.hasScheme((CharSequence)tigerRoute.getFrom())) {
            return this.buildForwardProxyRoute(tigerRoute);
        }
        return this.buildReverseProxyRoute(tigerRoute);
    }

    private Expectation[] buildReverseProxyRoute(TigerRoute tigerRoute) {
        return this.mockServer.when(HttpRequest.request().setPath(tigerRoute.getFrom() + ".*"), tigerRoute.getHosts()).id(tigerRoute.getId()).forward(new ReverseProxyCallback(this, tigerRoute));
    }

    private Expectation[] buildForwardProxyRoute(TigerRoute tigerRoute) {
        URL url = TigerProxy.buildUrlSafe(tigerRoute);
        return this.mockServer.when(HttpRequest.request().withHeader("Host", url.getAuthority()).setSecure(url.getProtocol().equals("https")).setPath(TigerProxy.extractPath(tigerRoute.getFrom()) + ".*"), tigerRoute.getHosts()).id(tigerRoute.getId()).forward(new ForwardProxyCallback(this, tigerRoute));
    }

    private static String extractPath(String url) {
        return new URI(url).getPath();
    }

    public void addAlternativeName(String host) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return;
        }
        ArrayList<String> newAlternativeNames = new ArrayList<String>();
        if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getAlternativeNames() != null) {
            newAlternativeNames.addAll(this.getTigerProxyConfiguration().getTls().getAlternativeNames());
        }
        newAlternativeNames.add(host);
        Objects.requireNonNull(this.getTigerProxyConfiguration().getTls()).setAlternativeNames(newAlternativeNames);
        for (DynamicTigerKeyAndCertificateFactory tlsFactory : this.tlsFactories) {
            tlsFactory.addAlternativeName(host);
            tlsFactory.resetEeCertificate();
        }
    }

    @Override
    public void removeRoute(String routeId) {
        if (!this.mockServer.isRunning()) {
            return;
        }
        this.mockServer.removeExpectation(routeId);
        TigerRoute route = this.tigerRouteMap.remove(routeId);
        this.log.info("Deleted route {} (id {}). Current # expectations {}", new Object[]{route, routeId, this.mockServer.retrieveActiveExpectations().size()});
    }

    public SSLContext getConfiguredTigerProxySslContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{this.buildTrustManagerForTigerProxy()}, null);
            SSLContext.setDefault(sslContext);
            return sslContext;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while configuring SSL Context for Tiger Proxy", e);
        }
    }

    public X509TrustManager buildTrustManagerForTigerProxy() {
        try {
            final X509TrustManager defaultTrustManager = this.extractTrustManager(null);
            final X509TrustManager customTrustManager = this.extractTrustManager(this.buildTruststore());
            return new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return defaultTrustManager.getAcceptedIssuers();
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    try {
                        customTrustManager.checkServerTrusted(chain, authType);
                    }
                    catch (CertificateException e) {
                        defaultTrustManager.checkServerTrusted(chain, authType);
                    }
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    defaultTrustManager.checkClientTrusted(chain, authType);
                }
            };
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building TrustManager for Tiger Proxy", e);
        }
    }

    private X509TrustManager extractTrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        return (X509TrustManager)Arrays.stream(trustManagerFactory.getTrustManagers()).filter(X509TrustManager.class::isInstance).findAny().orElseThrow(() -> new TigerProxyTrustManagerBuildingException("Error while configuring TrustManager for Tiger Proxy"));
    }

    public KeyStore buildTruststore() {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            TigerPkiIdentity serverIdentity = Optional.ofNullable(this.getTigerProxyConfiguration().getTls()).map(TigerTlsConfiguration::getServerIdentity).map(TigerPkiIdentity.class::cast).or(this::determineServerRootCa).orElseThrow(() -> new TigerProxyTrustManagerBuildingException("Unrecoverable state: Server-Identity null and Server-CA empty"));
            ks.setCertificateEntry(CA_CERT_ALIAS, serverIdentity.getCertificate());
            int chainCertCtr = 0;
            for (X509Certificate chainCert : serverIdentity.getCertificateChain()) {
                ks.setCertificateEntry("chainCert" + chainCertCtr++, chainCert);
            }
            if (this.getTigerProxyConfiguration().getTls().getOcspSignerIdentity() != null) {
                ks.setCertificateEntry("ocspSignerCert", this.getTigerProxyConfiguration().getTls().getOcspSignerIdentity().getCertificate());
            }
            return ks;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for Tiger Proxy", e);
        }
    }

    public SSLContext buildSslContext() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.buildTruststore());
            TrustManager[] trustManagers = tmf.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLS", (Provider)new BouncyCastleJsseProvider());
            sslContext.init(null, trustManagers, null);
            return sslContext;
        }
        catch (RuntimeException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for Tiger Proxy", e);
        }
    }

    private void outputForwardProxyConfigLogs(Optional<ProxyConfiguration> forwardProxyConfig) {
        if (forwardProxyConfig.isEmpty()) {
            this.log.info("Tigerproxy has NO forward proxy configured!");
        } else {
            ProxyConfiguration configNotEmpty = forwardProxyConfig.get();
            if (configNotEmpty.getUsername() == null) {
                this.log.info("Forward proxy is set to {}://{}:{}", new Object[]{configNotEmpty.getType(), configNotEmpty.getProxyAddress().getHostName(), configNotEmpty.getProxyAddress().getPort()});
            } else if (configNotEmpty.getUsername() != null) {
                this.log.info("Forward proxy is set to {}://{}:{}@{}:{}", new Object[]{configNotEmpty.getType(), configNotEmpty.getProxyAddress().getHostName(), configNotEmpty.getProxyAddress().getPort(), configNotEmpty.getUsername(), configNotEmpty.getPassword()});
            }
        }
    }

    public void propagateException(Throwable exception) {
        this.exceptionListeners.forEach(consumer -> consumer.accept(exception));
    }

    public void addNewExceptionConsumer(Consumer<Throwable> newConsumer) {
        this.exceptionListeners.add(newConsumer);
    }

    @Override
    @PreDestroy
    public void close() {
        String tigerProxyName = this.getName().orElse("");
        this.log.info("Shutting down Tiger-Proxy {}", (Object)tigerProxyName);
        super.close();
        this.remoteProxyClients.forEach(TigerRemoteProxyClient::close);
        this.mockServer.stop();
    }

    public Map<SocketAddress, TigerConnectionStatus> getOpenConnections() {
        return this.getOpenConnections(TigerConnectionStatus.OPEN_TCP);
    }

    public Map<SocketAddress, TigerConnectionStatus> getOpenConnections(TigerConnectionStatus status) {
        return this.mockServer.getOpenConnections().entrySet().stream().filter(entry -> ((TigerConnectionStatus)((Object)((Object)entry.getValue()))).getValue() >= status.getValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void waitForAllCurrentMessagesToBeParsed() {
        if (!this.getRbelLogger().getMessageHistory().isEmpty()) {
            this.getRbelLogger().getRbelConverter().waitForAllCurrentMessagesToBeParsed();
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerProxy)) {
            return false;
        }
        TigerProxy other = (TigerProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<DynamicTigerKeyAndCertificateFactory> this$tlsFactories = this.tlsFactories;
        List<DynamicTigerKeyAndCertificateFactory> other$tlsFactories = other.tlsFactories;
        if (this$tlsFactories == null ? other$tlsFactories != null : !((Object)this$tlsFactories).equals(other$tlsFactories)) {
            return false;
        }
        List<Consumer<Throwable>> this$exceptionListeners = this.exceptionListeners;
        List<Consumer<Throwable>> other$exceptionListeners = other.exceptionListeners;
        if (this$exceptionListeners == null ? other$exceptionListeners != null : !((Object)this$exceptionListeners).equals(other$exceptionListeners)) {
            return false;
        }
        MockServerToRbelConverter this$mockServerToRbelConverter = this.getMockServerToRbelConverter();
        MockServerToRbelConverter other$mockServerToRbelConverter = other.getMockServerToRbelConverter();
        if (this$mockServerToRbelConverter == null ? other$mockServerToRbelConverter != null : !this$mockServerToRbelConverter.equals(other$mockServerToRbelConverter)) {
            return false;
        }
        Map<String, TigerRoute> this$tigerRouteMap = this.tigerRouteMap;
        Map<String, TigerRoute> other$tigerRouteMap = other.tigerRouteMap;
        if (this$tigerRouteMap == null ? other$tigerRouteMap != null : !((Object)this$tigerRouteMap).equals(other$tigerRouteMap)) {
            return false;
        }
        List<TigerRemoteProxyClient> this$remoteProxyClients = this.remoteProxyClients;
        List<TigerRemoteProxyClient> other$remoteProxyClients = other.remoteProxyClients;
        if (this$remoteProxyClients == null ? other$remoteProxyClients != null : !((Object)this$remoteProxyClients).equals(other$remoteProxyClients)) {
            return false;
        }
        UUID this$healthEndpointRequestUuid = this.getHealthEndpointRequestUuid();
        UUID other$healthEndpointRequestUuid = other.getHealthEndpointRequestUuid();
        if (this$healthEndpointRequestUuid == null ? other$healthEndpointRequestUuid != null : !((Object)this$healthEndpointRequestUuid).equals(other$healthEndpointRequestUuid)) {
            return false;
        }
        MockServer this$mockServer = this.mockServer;
        MockServer other$mockServer = other.mockServer;
        if (this$mockServer == null ? other$mockServer != null : !this$mockServer.equals(other$mockServer)) {
            return false;
        }
        TigerPkiIdentity this$generatedRootCa = this.generatedRootCa;
        TigerPkiIdentity other$generatedRootCa = other.generatedRootCa;
        return !(this$generatedRootCa == null ? other$generatedRootCa != null : !this$generatedRootCa.equals(other$generatedRootCa));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerProxy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<DynamicTigerKeyAndCertificateFactory> $tlsFactories = this.tlsFactories;
        result = result * 59 + ($tlsFactories == null ? 43 : ((Object)$tlsFactories).hashCode());
        List<Consumer<Throwable>> $exceptionListeners = this.exceptionListeners;
        result = result * 59 + ($exceptionListeners == null ? 43 : ((Object)$exceptionListeners).hashCode());
        MockServerToRbelConverter $mockServerToRbelConverter = this.getMockServerToRbelConverter();
        result = result * 59 + ($mockServerToRbelConverter == null ? 43 : $mockServerToRbelConverter.hashCode());
        Map<String, TigerRoute> $tigerRouteMap = this.tigerRouteMap;
        result = result * 59 + ($tigerRouteMap == null ? 43 : ((Object)$tigerRouteMap).hashCode());
        List<TigerRemoteProxyClient> $remoteProxyClients = this.remoteProxyClients;
        result = result * 59 + ($remoteProxyClients == null ? 43 : ((Object)$remoteProxyClients).hashCode());
        UUID $healthEndpointRequestUuid = this.getHealthEndpointRequestUuid();
        result = result * 59 + ($healthEndpointRequestUuid == null ? 43 : ((Object)$healthEndpointRequestUuid).hashCode());
        MockServer $mockServer = this.mockServer;
        result = result * 59 + ($mockServer == null ? 43 : $mockServer.hashCode());
        TigerPkiIdentity $generatedRootCa = this.generatedRootCa;
        result = result * 59 + ($generatedRootCa == null ? 43 : $generatedRootCa.hashCode());
        return result;
    }

    @Generated
    public MockServerToRbelConverter getMockServerToRbelConverter() {
        return this.mockServerToRbelConverter;
    }

    @Generated
    public UUID getHealthEndpointRequestUuid() {
        return this.healthEndpointRequestUuid;
    }

    private static class TigerProxyTrustManagerBuildingException
    extends RuntimeException {
        public TigerProxyTrustManagerBuildingException(String s, Exception e) {
            super(s, e);
        }

        public TigerProxyTrustManagerBuildingException(String s) {
            super(s);
        }
    }
}

