/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty.proxy;

import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.exception.ExceptionHandling;
import de.gematik.test.tiger.mockserver.httpclient.BinaryRequestInfo;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpActionHandler;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.mockserver.model.BinaryProxyListener;
import de.gematik.test.tiger.mockserver.netty.unification.PortUnificationHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class BinaryHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryHandler.class);
    private final NettyHttpClient httpClient;
    private final BinaryProxyListener binaryExchangeCallback;

    public BinaryHandler(MockServerConfiguration configuration, NettyHttpClient httpClient) {
        super(true);
        this.httpClient = httpClient;
        this.binaryExchangeCallback = configuration.binaryProxyListener();
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf byteBuf) {
        BinaryMessage binaryRequest = BinaryMessage.bytes(ByteBufUtil.getBytes((ByteBuf)byteBuf));
        log.atDebug().addArgument(() -> ByteBufUtil.hexDump((byte[])binaryRequest.getBytes())).log("received binary request: {}");
        InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress(ctx);
        if (remoteAddress != null) {
            this.sendMessage(new BinaryRequestInfo(ctx.channel(), binaryRequest, remoteAddress));
        } else {
            log.info("unknown message format, only HTTP requests are supported for mocking or HTTP & binary requests for proxying, but request is not being proxied and request is not valid HTTP, found request in binary: {} in utf8 text: {}", (Object)ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), (Object)new String(binaryRequest.getBytes(), StandardCharsets.UTF_8));
            ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])"unknown message format, only HTTP requests are supported for mocking or HTTP & binary requests for proxying, but request is not being proxied and request is not valid HTTP".getBytes(StandardCharsets.UTF_8)));
            ctx.close();
        }
    }

    public void sendMessage(BinaryRequestInfo binaryRequestInfo) {
        CompletableFuture<BinaryMessage> binaryResponseFuture = this.httpClient.sendRequest(binaryRequestInfo, PortUnificationHandler.isSslEnabledUpstream(binaryRequestInfo.getIncomingChannel()));
        this.processNotWaitingForResponse(binaryRequestInfo, binaryResponseFuture);
    }

    private void processNotWaitingForResponse(BinaryRequestInfo binaryRequestInfo, CompletableFuture<BinaryMessage> binaryResponseFuture) {
        if (this.binaryExchangeCallback != null) {
            this.binaryExchangeCallback.onProxy((BinaryMessage)binaryRequestInfo.getDataToSend(), Optional.of(binaryResponseFuture), binaryRequestInfo.getRemoteServerAddress(), binaryRequestInfo.getIncomingChannel().remoteAddress());
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            log.error("exception caught by {} handler -> closing pipeline {}", new Object[]{((Object)((Object)this)).getClass(), ctx.channel(), cause});
        }
        ExceptionHandling.closeOnFlush(ctx.channel());
    }
}

