/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty;

import de.gematik.test.tiger.mockserver.ExpectationBuilder;
import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.lifecycle.LifeCycle;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.mock.HttpState;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpActionHandler;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.netty.ConnectionCounterHandler;
import de.gematik.test.tiger.mockserver.netty.HttpRequestHandler;
import de.gematik.test.tiger.mockserver.netty.unification.PortUnificationHandler;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import de.gematik.test.tiger.proxy.data.TigerConnectionStatus;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServer
extends LifeCycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MockServer.class);
    private InetSocketAddress remoteSocket;
    private HttpActionHandler actionHandler;
    private Map<SocketAddress, TigerConnectionStatus> connectionStatusMap = new ConcurrentHashMap<SocketAddress, TigerConnectionStatus>();

    public MockServer(Integer ... localPorts) {
        this(null, ProxyConfiguration.proxyConfiguration(MockServerConfiguration.configuration()), localPorts);
    }

    public MockServer(MockServerConfiguration configuration, Integer ... localPorts) {
        this(configuration, ProxyConfiguration.proxyConfiguration(configuration), localPorts);
    }

    public MockServer(ProxyConfiguration proxyConfiguration, Integer ... localPorts) {
        this(null, List.of(proxyConfiguration), localPorts);
    }

    public MockServer(MockServerConfiguration configuration, List<ProxyConfiguration> proxyConfigurations, Integer ... localPorts) {
        super(configuration);
        this.createServerBootstrap(configuration, proxyConfigurations, localPorts);
        this.getLocalPort();
    }

    public MockServer(Integer remotePort, @Nullable String remoteHost, Integer ... localPorts) {
        this(null, ProxyConfiguration.proxyConfiguration(MockServerConfiguration.configuration()), remoteHost, remotePort, localPorts);
    }

    public MockServer(MockServerConfiguration configuration, Integer remotePort, @Nullable String remoteHost, Integer ... localPorts) {
        this(configuration, ProxyConfiguration.proxyConfiguration(configuration), remoteHost, remotePort, localPorts);
    }

    public MockServer(MockServerConfiguration configuration, ProxyConfiguration proxyConfiguration, @Nullable String remoteHost, Integer remotePort, Integer ... localPorts) {
        this(configuration, List.of(proxyConfiguration), remoteHost, remotePort, localPorts);
    }

    public MockServer(MockServerConfiguration configuration, List<ProxyConfiguration> proxyConfigurations, @Nullable String remoteHost, Integer remotePort, Integer ... localPorts) {
        super(configuration);
        if (remotePort == null) {
            throw new IllegalArgumentException("You must specify a remote hostname");
        }
        if (StringUtils.isBlank((CharSequence)remoteHost)) {
            remoteHost = "localhost";
        }
        this.remoteSocket = new InetSocketAddress(remoteHost, (int)remotePort);
        log.info("using proxy configuration for forwarded requests:{}", proxyConfigurations);
        this.createServerBootstrap(configuration, proxyConfigurations, localPorts);
        this.getLocalPort();
    }

    private void createServerBootstrap(MockServerConfiguration configuration, List<ProxyConfiguration> proxyConfigurations, Integer ... localPorts) {
        if (configuration == null) {
            configuration = MockServerConfiguration.configuration();
        }
        List<Integer> portBindings = Collections.singletonList(0);
        if (localPorts != null && localPorts.length > 0) {
            portBindings = Arrays.asList(localPorts);
        }
        NettySslContextFactory nettyServerSslContextFactory = new NettySslContextFactory(configuration, true);
        NettySslContextFactory nettyClientSslContextFactory = new NettySslContextFactory(configuration, false);
        this.actionHandler = new HttpActionHandler(configuration, this.getEventLoopGroup(), this.httpState, proxyConfigurations, nettyClientSslContextFactory);
        this.serverServerBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).childHandler((ChannelHandler)new MockServerChannelInitializer(configuration, this, this.httpState, this.actionHandler, nettyServerSslContextFactory)).childAttr(HttpActionHandler.REMOTE_SOCKET, (Object)this.remoteSocket).childAttr(HttpRequestHandler.PROXYING, (Object)(this.remoteSocket != null ? 1 : 0));
        try {
            this.bindServerPorts(portBindings);
        }
        catch (RuntimeException throwable) {
            log.error("exception binding to port(s) {}", portBindings, (Object)throwable);
            this.stop();
            throw throwable;
        }
        this.startedServer(this.getLocalPorts());
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteSocket;
    }

    public ExpectationBuilder when(HttpRequest httpRequest, Integer priority, List<String> hostRegexes) {
        return new ExpectationBuilder(new Expectation(httpRequest, priority, hostRegexes), this);
    }

    public ExpectationBuilder when(HttpRequest requestDefinition, List<String> hostRegexes) {
        return new ExpectationBuilder(new Expectation(requestDefinition, 0, hostRegexes), this);
    }

    public void removeExpectation(String expectationId) {
        this.httpState.clear(expectationId);
    }

    public List<Expectation> retrieveActiveExpectations() {
        return this.httpState.retrieveActiveExpectations();
    }

    public synchronized void addConnectionWithStatus(SocketAddress socketAddress, TigerConnectionStatus status) {
        this.connectionStatusMap.put(socketAddress, status);
    }

    public synchronized Map<SocketAddress, TigerConnectionStatus> getOpenConnections() {
        return this.connectionStatusMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public synchronized void removeRemoteAddress(SocketAddress socketAddress) {
        this.connectionStatusMap.remove(socketAddress);
    }

    @Generated
    public InetSocketAddress getRemoteSocket() {
        return this.remoteSocket;
    }

    @Generated
    public HttpActionHandler getActionHandler() {
        return this.actionHandler;
    }

    @Generated
    public Map<SocketAddress, TigerConnectionStatus> getConnectionStatusMap() {
        return this.connectionStatusMap;
    }

    static class MockServerChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final MockServerConfiguration configuration;
        private final MockServer mockServer;
        private final HttpState httpState;
        private final HttpActionHandler actionHandler;
        private final NettySslContextFactory nettyServerSslContextFactory;

        public void initChannel(SocketChannel ch) {
            ch.pipeline().addFirst(new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)});
            ch.pipeline().addLast(new ChannelHandler[]{new ConnectionCounterHandler(this.mockServer)});
            ch.pipeline().addLast(new ChannelHandler[]{new PortUnificationHandler(this.configuration, this.mockServer, this.httpState, this.actionHandler, this.nettyServerSslContextFactory)});
        }

        @ConstructorProperties(value={"configuration", "mockServer", "httpState", "actionHandler", "nettyServerSslContextFactory"})
        @Generated
        public MockServerChannelInitializer(MockServerConfiguration configuration, MockServer mockServer, HttpState httpState, HttpActionHandler actionHandler, NettySslContextFactory nettyServerSslContextFactory) {
            this.configuration = configuration;
            this.mockServer = mockServer;
            this.httpState = httpState;
            this.actionHandler = actionHandler;
            this.nettyServerSslContextFactory = nettyServerSslContextFactory;
        }
    }
}

