/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import de.gematik.test.tiger.mockserver.model.KeyAndValue;
import de.gematik.test.tiger.mockserver.model.ObjectWithJsonToString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class KeysAndValues<T extends KeyAndValue, K extends KeysAndValues>
extends ObjectWithJsonToString {
    private final Map<String, String> map;

    protected KeysAndValues() {
        this.map = new LinkedHashMap<String, String>();
    }

    protected KeysAndValues(Map<String, String> map) {
        this.map = new LinkedHashMap<String, String>(map);
    }

    public abstract T build(String var1, String var2);

    public K withEntries(List<T> entries) {
        this.map.clear();
        if (entries != null) {
            for (KeyAndValue cookie : entries) {
                this.withEntry(cookie);
            }
        }
        return (K)this;
    }

    public K withEntries(T ... entries) {
        if (entries != null) {
            this.withEntries(Arrays.asList(entries));
        }
        return (K)this;
    }

    public K withEntry(T entry) {
        if (entry != null) {
            this.map.put(((KeyAndValue)entry).getName(), ((KeyAndValue)entry).getValue());
        }
        return (K)this;
    }

    public List<T> getEntries() {
        if (!this.map.isEmpty()) {
            ArrayList<T> cookies = new ArrayList<T>();
            for (String String2 : this.map.keySet()) {
                cookies.add(this.build(String2, this.map.get(String2)));
            }
            return cookies;
        }
        return Collections.emptyList();
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean remove(String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return this.map.remove(name) != null;
        }
        return false;
    }

    public abstract K clone();
}

