/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.mockserver.model.Body;
import de.gematik.test.tiger.mockserver.model.MediaType;
import java.nio.charset.Charset;
import lombok.Generated;

public abstract class BodyWithContentType<T>
extends Body<T> {
    protected final MediaType contentType;

    public BodyWithContentType(Body.Type type, MediaType contentType) {
        super(type);
        this.contentType = contentType;
    }

    @JsonIgnore
    Charset determineCharacterSet(MediaType mediaType, Charset defaultCharset) {
        Charset charset;
        if (mediaType != null && (charset = mediaType.getCharset()) != null) {
            return charset;
        }
        return defaultCharset;
    }

    @Override
    @JsonIgnore
    public Charset getCharset(Charset defaultIfNotSet) {
        return this.determineCharacterSet(this.contentType, defaultIfNotSet);
    }

    @Override
    public String getContentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BodyWithContentType)) {
            return false;
        }
        BodyWithContentType other = (BodyWithContentType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BodyWithContentType;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        return result;
    }
}

