/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.mockserver.model.BodyWithContentType;
import de.gematik.test.tiger.mockserver.model.ObjectWithJsonToString;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;

public abstract class Body<T>
extends ObjectWithJsonToString {
    private final Type type;

    Body(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public abstract T getValue();

    @JsonIgnore
    public byte[] getRawBytes() {
        return this.toString().getBytes(StandardCharsets.UTF_8);
    }

    @JsonIgnore
    public Charset getCharset(Charset defaultIfNotSet) {
        if (this instanceof BodyWithContentType) {
            return this.getCharset(defaultIfNotSet);
        }
        return defaultIfNotSet;
    }

    public String getContentType() {
        if (this instanceof BodyWithContentType) {
            return this.getContentType();
        }
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Body)) {
            return false;
        }
        Body other = (Body)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Body;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public static enum Type {
        BINARY,
        JSON,
        JSON_SCHEMA,
        JSON_PATH,
        PARAMETERS,
        REGEX,
        STRING,
        XML,
        XML_SCHEMA,
        XPATH,
        LOG_EVENT;

    }
}

