/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock.action.http;

import de.gematik.test.tiger.mockserver.filters.HopByHopHeaderFilter;
import de.gematik.test.tiger.mockserver.httpclient.HttpRequestInfo;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpForwardActionResult;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpForwardAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpForwardAction.class);
    private final NettyHttpClient httpClient;
    private HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();

    HttpForwardAction(NettyHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpForwardActionResult sendRequest(HttpRequest request, Channel incomingChannel, @Nullable InetSocketAddress remoteAddress, Function<HttpResponse, HttpResponse> overrideHttpResponse) {
        try {
            return new HttpForwardActionResult(request, this.httpClient.sendRequest(new HttpRequestInfo(incomingChannel, this.hopByHopHeaderFilter.onRequest(request).setProtocol(null), remoteAddress)), overrideHttpResponse, remoteAddress);
        }
        catch (Exception e) {
            log.error("exception forwarding request {}", (Object)request, (Object)e);
            return this.notFoundFuture(request);
        }
    }

    HttpForwardActionResult notFoundFuture(HttpRequest httpRequest) {
        CompletableFuture<HttpResponse> notFoundFuture = new CompletableFuture<HttpResponse>();
        notFoundFuture.complete(HttpResponse.notFoundResponse());
        return new HttpForwardActionResult(httpRequest, notFoundFuture, null);
    }
}

