/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock;

import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.scheduler.Scheduler;
import de.gematik.test.tiger.mockserver.uuid.UUIDService;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpState {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpState.class);
    private static final ThreadLocal<Integer> LOCAL_PORT = new ThreadLocal();
    private final String uniqueLoopPreventionHeaderValue = "MockServer_" + UUIDService.getUUID();
    private final Scheduler scheduler;
    private final MockServerConfiguration configuration;
    private List<Expectation> expectations = new ArrayList<Expectation>();

    public static void setPort(HttpRequest request) {
        if (request != null && request.getSocketAddress() != null) {
            HttpState.setPort(request.getSocketAddress().getPort());
            request.setSocketAddress(null);
        }
    }

    public static void clearPort() {
        LOCAL_PORT.remove();
    }

    public static void setPort(Integer port) {
        LOCAL_PORT.set(port);
    }

    public static void setPort(Integer ... port) {
        if (port != null && port.length > 0) {
            HttpState.setPort(port[0]);
        }
    }

    public static void setPort(List<Integer> port) {
        if (port != null && !port.isEmpty()) {
            HttpState.setPort(port.get(0));
        }
    }

    public static Integer getPort() {
        return LOCAL_PORT.get();
    }

    public HttpState(MockServerConfiguration configuration, Scheduler scheduler) {
        this.configuration = configuration;
        this.scheduler = scheduler;
    }

    public void reset() {
        log.info("resetting all expectations and request logs");
    }

    public List<Expectation> add(Expectation ... expectations) {
        for (Expectation expectation : expectations) {
            this.expectations.add(expectation);
            String hostHeader = expectation.getRequestPattern().getFirstHeader(HttpHeaderNames.HOST.toString());
            if (!StringUtils.isNotBlank((CharSequence)hostHeader)) continue;
            this.scheduler.submit(() -> this.configuration.addSubjectAlternativeName(hostHeader));
        }
        return List.of();
    }

    public Expectation firstMatchingExpectation(HttpRequest request) {
        return this.expectations.stream().filter(expectation -> expectation.matches(request)).min(Comparator.naturalOrder()).orElse(null);
    }

    public boolean handle(HttpRequest request) {
        request.withLogCorrelationId(UUIDService.getUUID());
        HttpState.setPort(request);
        log.trace("received request:{}", (Object)request);
        return false;
    }

    public String getUniqueLoopPreventionHeaderName() {
        return "x-forwarded-by";
    }

    public List<Expectation> retrieveActiveExpectations() {
        return this.expectations;
    }

    public void clear(String expectationId) {
        boolean foundRoute = this.expectations.removeIf(expectation -> expectation.getId().equals(expectationId));
        log.info("removed expectation with id [{}]: {}", (Object)expectationId, (Object)foundRoute);
    }

    @Generated
    public String getUniqueLoopPreventionHeaderValue() {
        return this.uniqueLoopPreventionHeaderValue;
    }

    @Generated
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Generated
    public MockServerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public List<Expectation> getExpectations() {
        return this.expectations;
    }
}

