/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock;

import de.gematik.test.tiger.mockserver.mock.HttpAction;
import de.gematik.test.tiger.mockserver.mock.action.ExpectationCallback;
import de.gematik.test.tiger.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import de.gematik.test.tiger.mockserver.model.HttpOverrideForwardedRequest;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.ObjectWithJsonToString;
import de.gematik.test.tiger.mockserver.model.Protocol;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expectation
extends ObjectWithJsonToString
implements Comparable<Expectation> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Expectation.class);
    private static final AtomicInteger EXPECTATION_COUNTER = new AtomicInteger(0);
    private static final long START_TIME = System.currentTimeMillis();
    private String id = UUID.randomUUID().toString();
    private final int priority;
    private final HttpRequest requestPattern;
    private HttpAction httpAction;
    private final List<String> hostRegexes;
    private ExpectationCallback expectationCallback;

    public Expectation(HttpRequest requestDefinition, int priority, List<String> hostRegexes) {
        EXPECTATION_COUNTER.compareAndSet(Integer.MAX_VALUE, 0);
        this.requestPattern = requestDefinition;
        this.priority = priority;
        this.hostRegexes = hostRegexes;
    }

    public Expectation thenForward(ExpectationForwardAndResponseCallback callback) {
        this.httpAction = HttpAction.of(new HttpOverrideForwardedRequest()).setExpectationForwardAndResponseCallback(callback);
        this.expectationCallback = callback;
        return this;
    }

    public boolean matches(HttpRequest request) {
        return this.protocolMatches(this.requestPattern.getProtocol(), request.getProtocol()) && this.hostMatches(request) && Expectation.pathMatches(this.requestPattern.getPath(), request.getPath()) && (this.expectationCallback == null || this.expectationCallback.matches(request));
    }

    private boolean hostMatches(HttpRequest request) {
        if (!this.requestPattern.getHeaders().containsEntry("Host")) {
            return true;
        }
        if (StringUtils.equals((CharSequence)this.requestPattern.getFirstHeader("Host"), (CharSequence)request.getFirstHeader("Host"))) {
            return true;
        }
        return this.hostRegexes.stream().anyMatch(request.getFirstHeader("Host")::matches);
    }

    private boolean protocolMatches(Protocol protocol, Protocol otherProtocol) {
        if (protocol == null) {
            return true;
        }
        return protocol.equals((Object)otherProtocol);
    }

    public static boolean pathMatches(String matcherValue, String matchedValue) {
        if (matcherValue == null) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)matcherValue)) {
            return true;
        }
        if (matchedValue != null) {
            if (matchedValue.equals(matcherValue) || matchedValue.equalsIgnoreCase(matcherValue)) {
                return true;
            }
            try {
                if (matchedValue.matches(matcherValue)) {
                    return true;
                }
            }
            catch (PatternSyntaxException pse) {
                log.debug("error while matching regex [{}] for string [{}]", new Object[]{matcherValue, matchedValue, pse});
            }
            try {
                if (matcherValue.matches(matchedValue)) {
                    return true;
                }
            }
            catch (PatternSyntaxException pse) {
                log.trace("error while matching regex [{}] for string [{}]", new Object[]{matchedValue, matcherValue, pse});
            }
        }
        return false;
    }

    @Override
    public int compareTo(Expectation o) {
        if (o == null) {
            return 1;
        }
        if (this.priority == o.priority) {
            String otherPath;
            if (this.requestPattern == null || o.requestPattern == null || this.requestPattern.getPath() == null || o.requestPattern.getPath() == null) {
                return 0;
            }
            String thisPath = this.requestPattern.getPath();
            if (Expectation.uriTwoIsBelowUriOne(thisPath, otherPath = o.requestPattern.getPath())) {
                return -1;
            }
            if (Expectation.uriTwoIsBelowUriOne(otherPath, thisPath)) {
                return 1;
            }
            return 0;
        }
        return Integer.compare(o.priority, this.priority);
    }

    private static boolean uriTwoIsBelowUriOne(String value1, String value2) {
        try {
            URI uri1 = new URI(value1);
            URI uri2WithUri1Scheme = new URIBuilder(value2).setScheme(uri1.getScheme()).build();
            return !uri1.relativize(uri2WithUri1Scheme).equals(uri2WithUri1Scheme);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Expectation)) {
            return false;
        }
        Expectation other = (Expectation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        HttpRequest this$requestPattern = this.getRequestPattern();
        HttpRequest other$requestPattern = other.getRequestPattern();
        if (this$requestPattern == null ? other$requestPattern != null : !((Object)this$requestPattern).equals(other$requestPattern)) {
            return false;
        }
        HttpAction this$httpAction = this.getHttpAction();
        HttpAction other$httpAction = other.getHttpAction();
        if (this$httpAction == null ? other$httpAction != null : !((Object)this$httpAction).equals(other$httpAction)) {
            return false;
        }
        List<String> this$hostRegexes = this.getHostRegexes();
        List<String> other$hostRegexes = other.getHostRegexes();
        if (this$hostRegexes == null ? other$hostRegexes != null : !((Object)this$hostRegexes).equals(other$hostRegexes)) {
            return false;
        }
        ExpectationCallback this$expectationCallback = this.getExpectationCallback();
        ExpectationCallback other$expectationCallback = other.getExpectationCallback();
        return !(this$expectationCallback == null ? other$expectationCallback != null : !this$expectationCallback.equals(other$expectationCallback));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Expectation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        HttpRequest $requestPattern = this.getRequestPattern();
        result = result * 59 + ($requestPattern == null ? 43 : ((Object)$requestPattern).hashCode());
        HttpAction $httpAction = this.getHttpAction();
        result = result * 59 + ($httpAction == null ? 43 : ((Object)$httpAction).hashCode());
        List<String> $hostRegexes = this.getHostRegexes();
        result = result * 59 + ($hostRegexes == null ? 43 : ((Object)$hostRegexes).hashCode());
        ExpectationCallback $expectationCallback = this.getExpectationCallback();
        result = result * 59 + ($expectationCallback == null ? 43 : $expectationCallback.hashCode());
        return result;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public HttpRequest getRequestPattern() {
        return this.requestPattern;
    }

    @Generated
    public HttpAction getHttpAction() {
        return this.httpAction;
    }

    @Generated
    public List<String> getHostRegexes() {
        return this.hostRegexes;
    }

    @Generated
    public ExpectationCallback getExpectationCallback() {
        return this.expectationCallback;
    }

    @Generated
    public Expectation setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public Expectation setHttpAction(HttpAction httpAction) {
        this.httpAction = httpAction;
        return this;
    }
}

