/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.httpclient;

import de.gematik.test.tiger.mockserver.configuration.MockServerConfiguration;
import de.gematik.test.tiger.mockserver.httpclient.BinaryRequestInfo;
import de.gematik.test.tiger.mockserver.httpclient.ClientBootstrapFactory;
import de.gematik.test.tiger.mockserver.httpclient.HttpClientInitializer;
import de.gematik.test.tiger.mockserver.httpclient.HttpRequestInfo;
import de.gematik.test.tiger.mockserver.httpclient.SocketConnectionException;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.model.Message;
import de.gematik.test.tiger.mockserver.model.Protocol;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoopGroup;
import io.netty.util.AttributeKey;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyHttpClient.class);
    static final AttributeKey<Boolean> SECURE = AttributeKey.valueOf((String)"SECURE");
    static final AttributeKey<InetSocketAddress> REMOTE_SOCKET = AttributeKey.valueOf((String)"REMOTE_SOCKET");
    public static final AttributeKey<CompletableFuture<Message>> RESPONSE_FUTURE = AttributeKey.valueOf((String)"RESPONSE_FUTURE");
    public static final AttributeKey<Boolean> ERROR_IF_CHANNEL_CLOSED_WITHOUT_RESPONSE = AttributeKey.valueOf((String)"ERROR_IF_CHANNEL_CLOSED_WITHOUT_RESPONSE");
    private final MockServerConfiguration configuration;
    private final EventLoopGroup eventLoopGroup;
    private final Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations;
    private final NettySslContextFactory nettySslContextFactory;
    private final ClientBootstrapFactory clientBootstrapFactory;

    public NettyHttpClient(MockServerConfiguration configuration, EventLoopGroup eventLoopGroup, List<ProxyConfiguration> proxyConfigurations, NettySslContextFactory nettySslContextFactory) {
        this.configuration = configuration;
        this.eventLoopGroup = eventLoopGroup;
        this.proxyConfigurations = proxyConfigurations != null ? proxyConfigurations.stream().collect(Collectors.toMap(ProxyConfiguration::getType, proxyConfiguration -> proxyConfiguration)) : Map.of();
        this.nettySslContextFactory = nettySslContextFactory;
        this.clientBootstrapFactory = new ClientBootstrapFactory(configuration, eventLoopGroup);
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequestInfo requestInfo, Long customTimeout) {
        if (requestInfo.getRemoteServerAddress() == null) {
            requestInfo.setRemoteServerAddress(((HttpRequest)requestInfo.getDataToSend()).socketAddressFromHostHeader());
        }
        if (!this.eventLoopGroup.isShuttingDown()) {
            if (this.proxyConfigurations != null && !Boolean.TRUE.equals(((HttpRequest)requestInfo.getDataToSend()).isSecure()) && this.proxyConfigurations.containsKey((Object)ProxyConfiguration.Type.HTTP) && this.isHostNotOnNoProxyHostList(requestInfo.getRemoteServerAddress())) {
                ProxyConfiguration proxyConfiguration = this.proxyConfigurations.get((Object)ProxyConfiguration.Type.HTTP);
                requestInfo.setRemoteServerAddress(proxyConfiguration.getProxyAddress());
                proxyConfiguration.addProxyAuthenticationHeader((HttpRequest)requestInfo.getDataToSend());
            } else if (requestInfo.getRemoteServerAddress() == null) {
                requestInfo.setRemoteServerAddress(((HttpRequest)requestInfo.getDataToSend()).socketAddressFromHostHeader());
            }
            if (Protocol.HTTP_2.equals((Object)((HttpRequest)requestInfo.getDataToSend()).getProtocol()) && !Boolean.TRUE.equals(((HttpRequest)requestInfo.getDataToSend()).isSecure())) {
                log.warn("HTTP2 requires ALPN but request is not secure (i.e. TLS) so protocol changed to HTTP1");
                ((HttpRequest)requestInfo.getDataToSend()).setProtocol(Protocol.HTTP_1_1);
            }
            CompletableFuture<HttpResponse> httpResponseFuture = new CompletableFuture<HttpResponse>();
            CompletableFuture<Message> responseFuture = new CompletableFuture<Message>();
            Protocol httpProtocol = ((HttpRequest)requestInfo.getDataToSend()).getProtocol() != null ? ((HttpRequest)requestInfo.getDataToSend()).getProtocol() : Protocol.HTTP_1_1;
            HttpClientInitializer clientInitializer = this.createClientInitializer(httpProtocol);
            boolean isSecure = ((HttpRequest)requestInfo.getDataToSend()).isSecure() != null && ((HttpRequest)requestInfo.getDataToSend()).isSecure() != false;
            ChannelFutureListener onCreationListener = future -> {
                if (future.isSuccess()) {
                    clientInitializer.whenComplete((protocol, throwable) -> {
                        if (throwable != null) {
                            httpResponseFuture.completeExceptionally((Throwable)throwable);
                        } else {
                            log.trace("sending request: {}", requestInfo.getDataToSend());
                            future.channel().writeAndFlush(requestInfo.getDataToSend());
                        }
                    });
                } else {
                    httpResponseFuture.completeExceptionally(future.cause());
                }
            };
            ChannelFutureListener onReuseListener = future -> {
                if (future.isSuccess()) {
                    log.trace("sending request: {}", requestInfo.getDataToSend());
                    future.channel().writeAndFlush(requestInfo.getDataToSend());
                } else {
                    httpResponseFuture.completeExceptionally(future.cause());
                }
            };
            this.clientBootstrapFactory.configureChannel().isSecure(isSecure).requestInfo(requestInfo).clientInitializer(clientInitializer).errorIfChannelClosedWithoutResponse(true).responseFuture(responseFuture).timeoutInMilliseconds(customTimeout).onCreationListener(onCreationListener).onReuseListener(onReuseListener).connectToChannel();
            responseFuture.whenComplete((message, throwable) -> {
                if (throwable == null) {
                    if (message != null) {
                        httpResponseFuture.complete((HttpResponse)message);
                    } else {
                        httpResponseFuture.complete(HttpResponse.response());
                    }
                } else {
                    httpResponseFuture.completeExceptionally((Throwable)throwable);
                }
            });
            return httpResponseFuture;
        }
        throw new IllegalStateException("Request sent after client has been stopped - the event loop has been shutdown so it is not possible to send a request");
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequestInfo requestInfo) throws SocketConnectionException {
        return this.sendRequest(requestInfo, this.configuration.socketConnectionTimeoutInMillis());
    }

    public HttpClientInitializer createClientInitializer(Protocol httpProtocol) {
        return new HttpClientInitializer(this.configuration, this.proxyConfigurations, this.nettySslContextFactory, httpProtocol);
    }

    public CompletableFuture<BinaryMessage> sendRequest(BinaryRequestInfo binaryRequestInfo, boolean isSecure) throws SocketConnectionException {
        if (!this.eventLoopGroup.isShuttingDown()) {
            if (this.proxyConfigurations != null && !isSecure && this.proxyConfigurations.containsKey((Object)ProxyConfiguration.Type.HTTP)) {
                binaryRequestInfo.setRemoteServerAddress(this.proxyConfigurations.get((Object)ProxyConfiguration.Type.HTTP).getProxyAddress());
            } else if (binaryRequestInfo.getRemoteServerAddress() == null) {
                throw new IllegalArgumentException("Remote address cannot be null");
            }
            CompletableFuture<BinaryMessage> binaryResponseFuture = new CompletableFuture<BinaryMessage>();
            CompletableFuture<Message> responseFuture = new CompletableFuture<Message>();
            HttpClientInitializer httpClientInitializer = this.createClientInitializer(null);
            ChannelFutureListener onCreateAndReuseListener = future -> {
                if (future.isSuccess()) {
                    log.atDebug().log(() -> "sending bytes hex %s to %s".formatted(ByteBufUtil.hexDump((byte[])binaryRequestInfo.getBytes()), future.channel().attr(REMOTE_SOCKET).get()));
                    future.channel().writeAndFlush((Object)Unpooled.copiedBuffer((byte[])binaryRequestInfo.getBytes()));
                } else {
                    binaryResponseFuture.completeExceptionally(future.cause());
                }
            };
            this.clientBootstrapFactory.configureChannel().isSecure(isSecure).requestInfo(binaryRequestInfo).responseFuture(responseFuture).clientInitializer(httpClientInitializer).errorIfChannelClosedWithoutResponse(false).responseFuture(responseFuture).onReuseListener(onCreateAndReuseListener).onCreationListener(onCreateAndReuseListener).connectToChannel();
            responseFuture.whenComplete((message, throwable) -> {
                if (throwable == null) {
                    binaryResponseFuture.complete((BinaryMessage)message);
                } else {
                    throwable.printStackTrace();
                    binaryResponseFuture.completeExceptionally((Throwable)throwable);
                }
            });
            return binaryResponseFuture;
        }
        throw new IllegalStateException("Request sent after client has been stopped - the event loop has been shutdown so it is not possible to send a request");
    }

    private boolean isHostNotOnNoProxyHostList(InetSocketAddress remoteAddress) {
        if (remoteAddress == null || StringUtils.isBlank((CharSequence)this.configuration.noProxyHosts())) {
            return true;
        }
        return Stream.of(this.configuration.noProxyHosts().split(",")).map(String::trim).map(host -> {
            try {
                return InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }).filter(Objects::nonNull).noneMatch(remoteAddress.getAddress()::equals);
    }

    @Generated
    public ClientBootstrapFactory getClientBootstrapFactory() {
        return this.clientBootstrapFactory;
    }
}

