/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.httpclient;

import de.gematik.test.tiger.mockserver.model.Protocol;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2Settings;
import java.util.concurrent.CompletableFuture;

public class Http2SettingsHandler
extends SimpleChannelInboundHandler<Http2Settings> {
    private final CompletableFuture<Http2Settings> settingsFuture = new CompletableFuture();

    public Http2SettingsHandler(CompletableFuture<Protocol> protocolFuture) {
        this.settingsFuture.whenComplete((http2Settings, throwable) -> {
            if (throwable != null) {
                protocolFuture.completeExceptionally((Throwable)throwable);
            } else if (http2Settings != null) {
                protocolFuture.complete(Protocol.HTTP_2);
            } else {
                protocolFuture.complete(Protocol.HTTP_1_1);
            }
        });
    }

    protected void channelRead0(ChannelHandlerContext ctx, Http2Settings http2Settings) throws Exception {
        this.settingsFuture.complete(http2Settings);
        ctx.pipeline().remove((ChannelHandler)this);
    }
}

