/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.configuration;

import de.gematik.test.tiger.mockserver.model.BinaryProxyListener;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAndCertificateFactorySupplier;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;

public class MockServerConfiguration {
    private String mockServerName = null;
    private Integer nioEventLoopThreadCount = 5;
    private Integer actionHandlerThreadCount = Math.max(5, Runtime.getRuntime().availableProcessors());
    private Integer clientNioEventLoopThreadCount = 5;
    private Integer webSocketClientEventLoopThreadCount = 5;
    private Long maxFutureTimeoutInMillis = TimeUnit.SECONDS.toMillis(90L);
    private Long maxSocketTimeoutInMillis = TimeUnit.SECONDS.toMillis(20L);
    private Long socketConnectionTimeoutInMillis = TimeUnit.SECONDS.toMillis(20L);
    private boolean alwaysCloseSocketConnections = false;
    private Integer maxInitialLineLength = Integer.MAX_VALUE;
    private Integer maxHeaderSize = Integer.MAX_VALUE;
    private Integer maxChunkSize = Integer.MAX_VALUE;
    private BinaryProxyListener binaryProxyListener = null;
    private boolean enableTlsTermination = true;
    private InetSocketAddress forwardHttpProxy = null;
    private InetSocketAddress forwardHttpsProxy = null;
    private InetSocketAddress forwardSocksProxy = null;
    private String forwardProxyAuthenticationUsername = "";
    private String forwardProxyAuthenticationPassword = "";
    private String proxyAuthenticationRealm = "";
    private String proxyAuthenticationUsername = "";
    private String proxyAuthenticationPassword = "";
    private String noProxyHosts = "";
    private boolean rebuildServerTlsContext = false;
    private String tlsProtocols = "TLSv1,TLSv1.1,TLSv1.2";
    private KeyAndCertificateFactorySupplier customKeyAndCertificateFactorySupplier = null;
    private Function<SslContextBuilder, SslContext> clientSslContextBuilderFunction = null;
    private Consumer<NettySslContextFactory> nettySslContextFactoryCustomizer = factory -> {};
    private UnaryOperator<SslContextBuilder> sslServerContextBuilderCustomizer = UnaryOperator.identity();
    private UnaryOperator<SslContextBuilder> sslClientContextBuilderCustomizer = UnaryOperator.identity();
    private Function<X509Certificate, byte[]> ocspResponseSupplier = null;
    private String masterSecretFile = null;
    private String sslCertificateDomainName = "localhost";
    private Set<String> sslSubjectAlternativeNameDomains = new HashSet<String>(Set.of("localhost"));
    private Set<String> sslSubjectAlternativeNameIps = new HashSet<String>(Set.of("127.0.0.1", "0.0.0.0"));

    public static MockServerConfiguration configuration() {
        return new MockServerConfiguration();
    }

    public void addSubjectAlternativeName(String newSubjectAlternativeName) {
        this.sslSubjectAlternativeNameDomains.add(newSubjectAlternativeName);
        this.rebuildServerTlsContext = true;
    }

    @Generated
    public MockServerConfiguration() {
    }

    @Generated
    public String mockServerName() {
        return this.mockServerName;
    }

    @Generated
    public Integer nioEventLoopThreadCount() {
        return this.nioEventLoopThreadCount;
    }

    @Generated
    public Integer actionHandlerThreadCount() {
        return this.actionHandlerThreadCount;
    }

    @Generated
    public Integer clientNioEventLoopThreadCount() {
        return this.clientNioEventLoopThreadCount;
    }

    @Generated
    public Integer webSocketClientEventLoopThreadCount() {
        return this.webSocketClientEventLoopThreadCount;
    }

    @Generated
    public Long maxFutureTimeoutInMillis() {
        return this.maxFutureTimeoutInMillis;
    }

    @Generated
    public Long maxSocketTimeoutInMillis() {
        return this.maxSocketTimeoutInMillis;
    }

    @Generated
    public Long socketConnectionTimeoutInMillis() {
        return this.socketConnectionTimeoutInMillis;
    }

    @Generated
    public boolean alwaysCloseSocketConnections() {
        return this.alwaysCloseSocketConnections;
    }

    @Generated
    public Integer maxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    @Generated
    public Integer maxHeaderSize() {
        return this.maxHeaderSize;
    }

    @Generated
    public Integer maxChunkSize() {
        return this.maxChunkSize;
    }

    @Generated
    public BinaryProxyListener binaryProxyListener() {
        return this.binaryProxyListener;
    }

    @Generated
    public boolean enableTlsTermination() {
        return this.enableTlsTermination;
    }

    @Generated
    public InetSocketAddress forwardHttpProxy() {
        return this.forwardHttpProxy;
    }

    @Generated
    public InetSocketAddress forwardHttpsProxy() {
        return this.forwardHttpsProxy;
    }

    @Generated
    public InetSocketAddress forwardSocksProxy() {
        return this.forwardSocksProxy;
    }

    @Generated
    public String forwardProxyAuthenticationUsername() {
        return this.forwardProxyAuthenticationUsername;
    }

    @Generated
    public String forwardProxyAuthenticationPassword() {
        return this.forwardProxyAuthenticationPassword;
    }

    @Generated
    public String proxyAuthenticationRealm() {
        return this.proxyAuthenticationRealm;
    }

    @Generated
    public String proxyAuthenticationUsername() {
        return this.proxyAuthenticationUsername;
    }

    @Generated
    public String proxyAuthenticationPassword() {
        return this.proxyAuthenticationPassword;
    }

    @Generated
    public String noProxyHosts() {
        return this.noProxyHosts;
    }

    @Generated
    public boolean rebuildServerTlsContext() {
        return this.rebuildServerTlsContext;
    }

    @Generated
    public String tlsProtocols() {
        return this.tlsProtocols;
    }

    @Generated
    public KeyAndCertificateFactorySupplier customKeyAndCertificateFactorySupplier() {
        return this.customKeyAndCertificateFactorySupplier;
    }

    @Generated
    public Function<SslContextBuilder, SslContext> clientSslContextBuilderFunction() {
        return this.clientSslContextBuilderFunction;
    }

    @Generated
    public Consumer<NettySslContextFactory> nettySslContextFactoryCustomizer() {
        return this.nettySslContextFactoryCustomizer;
    }

    @Generated
    public UnaryOperator<SslContextBuilder> sslServerContextBuilderCustomizer() {
        return this.sslServerContextBuilderCustomizer;
    }

    @Generated
    public UnaryOperator<SslContextBuilder> sslClientContextBuilderCustomizer() {
        return this.sslClientContextBuilderCustomizer;
    }

    @Generated
    public Function<X509Certificate, byte[]> ocspResponseSupplier() {
        return this.ocspResponseSupplier;
    }

    @Generated
    public String masterSecretFile() {
        return this.masterSecretFile;
    }

    @Generated
    public String sslCertificateDomainName() {
        return this.sslCertificateDomainName;
    }

    @Generated
    public Set<String> sslSubjectAlternativeNameDomains() {
        return this.sslSubjectAlternativeNameDomains;
    }

    @Generated
    public Set<String> sslSubjectAlternativeNameIps() {
        return this.sslSubjectAlternativeNameIps;
    }

    @Generated
    public MockServerConfiguration mockServerName(String mockServerName) {
        this.mockServerName = mockServerName;
        return this;
    }

    @Generated
    public MockServerConfiguration nioEventLoopThreadCount(Integer nioEventLoopThreadCount) {
        this.nioEventLoopThreadCount = nioEventLoopThreadCount;
        return this;
    }

    @Generated
    public MockServerConfiguration actionHandlerThreadCount(Integer actionHandlerThreadCount) {
        this.actionHandlerThreadCount = actionHandlerThreadCount;
        return this;
    }

    @Generated
    public MockServerConfiguration clientNioEventLoopThreadCount(Integer clientNioEventLoopThreadCount) {
        this.clientNioEventLoopThreadCount = clientNioEventLoopThreadCount;
        return this;
    }

    @Generated
    public MockServerConfiguration webSocketClientEventLoopThreadCount(Integer webSocketClientEventLoopThreadCount) {
        this.webSocketClientEventLoopThreadCount = webSocketClientEventLoopThreadCount;
        return this;
    }

    @Generated
    public MockServerConfiguration maxFutureTimeoutInMillis(Long maxFutureTimeoutInMillis) {
        this.maxFutureTimeoutInMillis = maxFutureTimeoutInMillis;
        return this;
    }

    @Generated
    public MockServerConfiguration maxSocketTimeoutInMillis(Long maxSocketTimeoutInMillis) {
        this.maxSocketTimeoutInMillis = maxSocketTimeoutInMillis;
        return this;
    }

    @Generated
    public MockServerConfiguration socketConnectionTimeoutInMillis(Long socketConnectionTimeoutInMillis) {
        this.socketConnectionTimeoutInMillis = socketConnectionTimeoutInMillis;
        return this;
    }

    @Generated
    public MockServerConfiguration alwaysCloseSocketConnections(boolean alwaysCloseSocketConnections) {
        this.alwaysCloseSocketConnections = alwaysCloseSocketConnections;
        return this;
    }

    @Generated
    public MockServerConfiguration maxInitialLineLength(Integer maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
        return this;
    }

    @Generated
    public MockServerConfiguration maxHeaderSize(Integer maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
        return this;
    }

    @Generated
    public MockServerConfiguration maxChunkSize(Integer maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    @Generated
    public MockServerConfiguration binaryProxyListener(BinaryProxyListener binaryProxyListener) {
        this.binaryProxyListener = binaryProxyListener;
        return this;
    }

    @Generated
    public MockServerConfiguration enableTlsTermination(boolean enableTlsTermination) {
        this.enableTlsTermination = enableTlsTermination;
        return this;
    }

    @Generated
    public MockServerConfiguration forwardHttpProxy(InetSocketAddress forwardHttpProxy) {
        this.forwardHttpProxy = forwardHttpProxy;
        return this;
    }

    @Generated
    public MockServerConfiguration forwardHttpsProxy(InetSocketAddress forwardHttpsProxy) {
        this.forwardHttpsProxy = forwardHttpsProxy;
        return this;
    }

    @Generated
    public MockServerConfiguration forwardSocksProxy(InetSocketAddress forwardSocksProxy) {
        this.forwardSocksProxy = forwardSocksProxy;
        return this;
    }

    @Generated
    public MockServerConfiguration forwardProxyAuthenticationUsername(String forwardProxyAuthenticationUsername) {
        this.forwardProxyAuthenticationUsername = forwardProxyAuthenticationUsername;
        return this;
    }

    @Generated
    public MockServerConfiguration forwardProxyAuthenticationPassword(String forwardProxyAuthenticationPassword) {
        this.forwardProxyAuthenticationPassword = forwardProxyAuthenticationPassword;
        return this;
    }

    @Generated
    public MockServerConfiguration proxyAuthenticationRealm(String proxyAuthenticationRealm) {
        this.proxyAuthenticationRealm = proxyAuthenticationRealm;
        return this;
    }

    @Generated
    public MockServerConfiguration proxyAuthenticationUsername(String proxyAuthenticationUsername) {
        this.proxyAuthenticationUsername = proxyAuthenticationUsername;
        return this;
    }

    @Generated
    public MockServerConfiguration proxyAuthenticationPassword(String proxyAuthenticationPassword) {
        this.proxyAuthenticationPassword = proxyAuthenticationPassword;
        return this;
    }

    @Generated
    public MockServerConfiguration noProxyHosts(String noProxyHosts) {
        this.noProxyHosts = noProxyHosts;
        return this;
    }

    @Generated
    public MockServerConfiguration rebuildServerTlsContext(boolean rebuildServerTlsContext) {
        this.rebuildServerTlsContext = rebuildServerTlsContext;
        return this;
    }

    @Generated
    public MockServerConfiguration tlsProtocols(String tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
        return this;
    }

    @Generated
    public MockServerConfiguration customKeyAndCertificateFactorySupplier(KeyAndCertificateFactorySupplier customKeyAndCertificateFactorySupplier) {
        this.customKeyAndCertificateFactorySupplier = customKeyAndCertificateFactorySupplier;
        return this;
    }

    @Generated
    public MockServerConfiguration clientSslContextBuilderFunction(Function<SslContextBuilder, SslContext> clientSslContextBuilderFunction) {
        this.clientSslContextBuilderFunction = clientSslContextBuilderFunction;
        return this;
    }

    @Generated
    public MockServerConfiguration nettySslContextFactoryCustomizer(Consumer<NettySslContextFactory> nettySslContextFactoryCustomizer) {
        this.nettySslContextFactoryCustomizer = nettySslContextFactoryCustomizer;
        return this;
    }

    @Generated
    public MockServerConfiguration sslServerContextBuilderCustomizer(UnaryOperator<SslContextBuilder> sslServerContextBuilderCustomizer) {
        this.sslServerContextBuilderCustomizer = sslServerContextBuilderCustomizer;
        return this;
    }

    @Generated
    public MockServerConfiguration sslClientContextBuilderCustomizer(UnaryOperator<SslContextBuilder> sslClientContextBuilderCustomizer) {
        this.sslClientContextBuilderCustomizer = sslClientContextBuilderCustomizer;
        return this;
    }

    @Generated
    public MockServerConfiguration ocspResponseSupplier(Function<X509Certificate, byte[]> ocspResponseSupplier) {
        this.ocspResponseSupplier = ocspResponseSupplier;
        return this;
    }

    @Generated
    public MockServerConfiguration masterSecretFile(String masterSecretFile) {
        this.masterSecretFile = masterSecretFile;
        return this;
    }

    @Generated
    public MockServerConfiguration sslCertificateDomainName(String sslCertificateDomainName) {
        this.sslCertificateDomainName = sslCertificateDomainName;
        return this;
    }

    @Generated
    public MockServerConfiguration sslSubjectAlternativeNameDomains(Set<String> sslSubjectAlternativeNameDomains) {
        this.sslSubjectAlternativeNameDomains = sslSubjectAlternativeNameDomains;
        return this;
    }

    @Generated
    public MockServerConfiguration sslSubjectAlternativeNameIps(Set<String> sslSubjectAlternativeNameIps) {
        this.sslSubjectAlternativeNameIps = sslSubjectAlternativeNameIps;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MockServerConfiguration)) {
            return false;
        }
        MockServerConfiguration other = (MockServerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.alwaysCloseSocketConnections() != other.alwaysCloseSocketConnections()) {
            return false;
        }
        if (this.enableTlsTermination() != other.enableTlsTermination()) {
            return false;
        }
        if (this.rebuildServerTlsContext() != other.rebuildServerTlsContext()) {
            return false;
        }
        Integer this$nioEventLoopThreadCount = this.nioEventLoopThreadCount();
        Integer other$nioEventLoopThreadCount = other.nioEventLoopThreadCount();
        if (this$nioEventLoopThreadCount == null ? other$nioEventLoopThreadCount != null : !((Object)this$nioEventLoopThreadCount).equals(other$nioEventLoopThreadCount)) {
            return false;
        }
        Integer this$actionHandlerThreadCount = this.actionHandlerThreadCount();
        Integer other$actionHandlerThreadCount = other.actionHandlerThreadCount();
        if (this$actionHandlerThreadCount == null ? other$actionHandlerThreadCount != null : !((Object)this$actionHandlerThreadCount).equals(other$actionHandlerThreadCount)) {
            return false;
        }
        Integer this$clientNioEventLoopThreadCount = this.clientNioEventLoopThreadCount();
        Integer other$clientNioEventLoopThreadCount = other.clientNioEventLoopThreadCount();
        if (this$clientNioEventLoopThreadCount == null ? other$clientNioEventLoopThreadCount != null : !((Object)this$clientNioEventLoopThreadCount).equals(other$clientNioEventLoopThreadCount)) {
            return false;
        }
        Integer this$webSocketClientEventLoopThreadCount = this.webSocketClientEventLoopThreadCount();
        Integer other$webSocketClientEventLoopThreadCount = other.webSocketClientEventLoopThreadCount();
        if (this$webSocketClientEventLoopThreadCount == null ? other$webSocketClientEventLoopThreadCount != null : !((Object)this$webSocketClientEventLoopThreadCount).equals(other$webSocketClientEventLoopThreadCount)) {
            return false;
        }
        Long this$maxFutureTimeoutInMillis = this.maxFutureTimeoutInMillis();
        Long other$maxFutureTimeoutInMillis = other.maxFutureTimeoutInMillis();
        if (this$maxFutureTimeoutInMillis == null ? other$maxFutureTimeoutInMillis != null : !((Object)this$maxFutureTimeoutInMillis).equals(other$maxFutureTimeoutInMillis)) {
            return false;
        }
        Long this$maxSocketTimeoutInMillis = this.maxSocketTimeoutInMillis();
        Long other$maxSocketTimeoutInMillis = other.maxSocketTimeoutInMillis();
        if (this$maxSocketTimeoutInMillis == null ? other$maxSocketTimeoutInMillis != null : !((Object)this$maxSocketTimeoutInMillis).equals(other$maxSocketTimeoutInMillis)) {
            return false;
        }
        Long this$socketConnectionTimeoutInMillis = this.socketConnectionTimeoutInMillis();
        Long other$socketConnectionTimeoutInMillis = other.socketConnectionTimeoutInMillis();
        if (this$socketConnectionTimeoutInMillis == null ? other$socketConnectionTimeoutInMillis != null : !((Object)this$socketConnectionTimeoutInMillis).equals(other$socketConnectionTimeoutInMillis)) {
            return false;
        }
        Integer this$maxInitialLineLength = this.maxInitialLineLength();
        Integer other$maxInitialLineLength = other.maxInitialLineLength();
        if (this$maxInitialLineLength == null ? other$maxInitialLineLength != null : !((Object)this$maxInitialLineLength).equals(other$maxInitialLineLength)) {
            return false;
        }
        Integer this$maxHeaderSize = this.maxHeaderSize();
        Integer other$maxHeaderSize = other.maxHeaderSize();
        if (this$maxHeaderSize == null ? other$maxHeaderSize != null : !((Object)this$maxHeaderSize).equals(other$maxHeaderSize)) {
            return false;
        }
        Integer this$maxChunkSize = this.maxChunkSize();
        Integer other$maxChunkSize = other.maxChunkSize();
        if (this$maxChunkSize == null ? other$maxChunkSize != null : !((Object)this$maxChunkSize).equals(other$maxChunkSize)) {
            return false;
        }
        String this$mockServerName = this.mockServerName();
        String other$mockServerName = other.mockServerName();
        if (this$mockServerName == null ? other$mockServerName != null : !this$mockServerName.equals(other$mockServerName)) {
            return false;
        }
        BinaryProxyListener this$binaryProxyListener = this.binaryProxyListener();
        BinaryProxyListener other$binaryProxyListener = other.binaryProxyListener();
        if (this$binaryProxyListener == null ? other$binaryProxyListener != null : !this$binaryProxyListener.equals(other$binaryProxyListener)) {
            return false;
        }
        InetSocketAddress this$forwardHttpProxy = this.forwardHttpProxy();
        InetSocketAddress other$forwardHttpProxy = other.forwardHttpProxy();
        if (this$forwardHttpProxy == null ? other$forwardHttpProxy != null : !((Object)this$forwardHttpProxy).equals(other$forwardHttpProxy)) {
            return false;
        }
        InetSocketAddress this$forwardHttpsProxy = this.forwardHttpsProxy();
        InetSocketAddress other$forwardHttpsProxy = other.forwardHttpsProxy();
        if (this$forwardHttpsProxy == null ? other$forwardHttpsProxy != null : !((Object)this$forwardHttpsProxy).equals(other$forwardHttpsProxy)) {
            return false;
        }
        InetSocketAddress this$forwardSocksProxy = this.forwardSocksProxy();
        InetSocketAddress other$forwardSocksProxy = other.forwardSocksProxy();
        if (this$forwardSocksProxy == null ? other$forwardSocksProxy != null : !((Object)this$forwardSocksProxy).equals(other$forwardSocksProxy)) {
            return false;
        }
        String this$forwardProxyAuthenticationUsername = this.forwardProxyAuthenticationUsername();
        String other$forwardProxyAuthenticationUsername = other.forwardProxyAuthenticationUsername();
        if (this$forwardProxyAuthenticationUsername == null ? other$forwardProxyAuthenticationUsername != null : !this$forwardProxyAuthenticationUsername.equals(other$forwardProxyAuthenticationUsername)) {
            return false;
        }
        String this$forwardProxyAuthenticationPassword = this.forwardProxyAuthenticationPassword();
        String other$forwardProxyAuthenticationPassword = other.forwardProxyAuthenticationPassword();
        if (this$forwardProxyAuthenticationPassword == null ? other$forwardProxyAuthenticationPassword != null : !this$forwardProxyAuthenticationPassword.equals(other$forwardProxyAuthenticationPassword)) {
            return false;
        }
        String this$proxyAuthenticationRealm = this.proxyAuthenticationRealm();
        String other$proxyAuthenticationRealm = other.proxyAuthenticationRealm();
        if (this$proxyAuthenticationRealm == null ? other$proxyAuthenticationRealm != null : !this$proxyAuthenticationRealm.equals(other$proxyAuthenticationRealm)) {
            return false;
        }
        String this$proxyAuthenticationUsername = this.proxyAuthenticationUsername();
        String other$proxyAuthenticationUsername = other.proxyAuthenticationUsername();
        if (this$proxyAuthenticationUsername == null ? other$proxyAuthenticationUsername != null : !this$proxyAuthenticationUsername.equals(other$proxyAuthenticationUsername)) {
            return false;
        }
        String this$proxyAuthenticationPassword = this.proxyAuthenticationPassword();
        String other$proxyAuthenticationPassword = other.proxyAuthenticationPassword();
        if (this$proxyAuthenticationPassword == null ? other$proxyAuthenticationPassword != null : !this$proxyAuthenticationPassword.equals(other$proxyAuthenticationPassword)) {
            return false;
        }
        String this$noProxyHosts = this.noProxyHosts();
        String other$noProxyHosts = other.noProxyHosts();
        if (this$noProxyHosts == null ? other$noProxyHosts != null : !this$noProxyHosts.equals(other$noProxyHosts)) {
            return false;
        }
        String this$tlsProtocols = this.tlsProtocols();
        String other$tlsProtocols = other.tlsProtocols();
        if (this$tlsProtocols == null ? other$tlsProtocols != null : !this$tlsProtocols.equals(other$tlsProtocols)) {
            return false;
        }
        KeyAndCertificateFactorySupplier this$customKeyAndCertificateFactorySupplier = this.customKeyAndCertificateFactorySupplier();
        KeyAndCertificateFactorySupplier other$customKeyAndCertificateFactorySupplier = other.customKeyAndCertificateFactorySupplier();
        if (this$customKeyAndCertificateFactorySupplier == null ? other$customKeyAndCertificateFactorySupplier != null : !this$customKeyAndCertificateFactorySupplier.equals(other$customKeyAndCertificateFactorySupplier)) {
            return false;
        }
        Function<SslContextBuilder, SslContext> this$clientSslContextBuilderFunction = this.clientSslContextBuilderFunction();
        Function<SslContextBuilder, SslContext> other$clientSslContextBuilderFunction = other.clientSslContextBuilderFunction();
        if (this$clientSslContextBuilderFunction == null ? other$clientSslContextBuilderFunction != null : !this$clientSslContextBuilderFunction.equals(other$clientSslContextBuilderFunction)) {
            return false;
        }
        Consumer<NettySslContextFactory> this$nettySslContextFactoryCustomizer = this.nettySslContextFactoryCustomizer();
        Consumer<NettySslContextFactory> other$nettySslContextFactoryCustomizer = other.nettySslContextFactoryCustomizer();
        if (this$nettySslContextFactoryCustomizer == null ? other$nettySslContextFactoryCustomizer != null : !this$nettySslContextFactoryCustomizer.equals(other$nettySslContextFactoryCustomizer)) {
            return false;
        }
        UnaryOperator<SslContextBuilder> this$sslServerContextBuilderCustomizer = this.sslServerContextBuilderCustomizer();
        UnaryOperator<SslContextBuilder> other$sslServerContextBuilderCustomizer = other.sslServerContextBuilderCustomizer();
        if (this$sslServerContextBuilderCustomizer == null ? other$sslServerContextBuilderCustomizer != null : !this$sslServerContextBuilderCustomizer.equals(other$sslServerContextBuilderCustomizer)) {
            return false;
        }
        UnaryOperator<SslContextBuilder> this$sslClientContextBuilderCustomizer = this.sslClientContextBuilderCustomizer();
        UnaryOperator<SslContextBuilder> other$sslClientContextBuilderCustomizer = other.sslClientContextBuilderCustomizer();
        if (this$sslClientContextBuilderCustomizer == null ? other$sslClientContextBuilderCustomizer != null : !this$sslClientContextBuilderCustomizer.equals(other$sslClientContextBuilderCustomizer)) {
            return false;
        }
        Function<X509Certificate, byte[]> this$ocspResponseSupplier = this.ocspResponseSupplier();
        Function<X509Certificate, byte[]> other$ocspResponseSupplier = other.ocspResponseSupplier();
        if (this$ocspResponseSupplier == null ? other$ocspResponseSupplier != null : !this$ocspResponseSupplier.equals(other$ocspResponseSupplier)) {
            return false;
        }
        String this$masterSecretFile = this.masterSecretFile();
        String other$masterSecretFile = other.masterSecretFile();
        if (this$masterSecretFile == null ? other$masterSecretFile != null : !this$masterSecretFile.equals(other$masterSecretFile)) {
            return false;
        }
        String this$sslCertificateDomainName = this.sslCertificateDomainName();
        String other$sslCertificateDomainName = other.sslCertificateDomainName();
        if (this$sslCertificateDomainName == null ? other$sslCertificateDomainName != null : !this$sslCertificateDomainName.equals(other$sslCertificateDomainName)) {
            return false;
        }
        Set<String> this$sslSubjectAlternativeNameDomains = this.sslSubjectAlternativeNameDomains();
        Set<String> other$sslSubjectAlternativeNameDomains = other.sslSubjectAlternativeNameDomains();
        if (this$sslSubjectAlternativeNameDomains == null ? other$sslSubjectAlternativeNameDomains != null : !((Object)this$sslSubjectAlternativeNameDomains).equals(other$sslSubjectAlternativeNameDomains)) {
            return false;
        }
        Set<String> this$sslSubjectAlternativeNameIps = this.sslSubjectAlternativeNameIps();
        Set<String> other$sslSubjectAlternativeNameIps = other.sslSubjectAlternativeNameIps();
        return !(this$sslSubjectAlternativeNameIps == null ? other$sslSubjectAlternativeNameIps != null : !((Object)this$sslSubjectAlternativeNameIps).equals(other$sslSubjectAlternativeNameIps));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MockServerConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.alwaysCloseSocketConnections() ? 79 : 97);
        result = result * 59 + (this.enableTlsTermination() ? 79 : 97);
        result = result * 59 + (this.rebuildServerTlsContext() ? 79 : 97);
        Integer $nioEventLoopThreadCount = this.nioEventLoopThreadCount();
        result = result * 59 + ($nioEventLoopThreadCount == null ? 43 : ((Object)$nioEventLoopThreadCount).hashCode());
        Integer $actionHandlerThreadCount = this.actionHandlerThreadCount();
        result = result * 59 + ($actionHandlerThreadCount == null ? 43 : ((Object)$actionHandlerThreadCount).hashCode());
        Integer $clientNioEventLoopThreadCount = this.clientNioEventLoopThreadCount();
        result = result * 59 + ($clientNioEventLoopThreadCount == null ? 43 : ((Object)$clientNioEventLoopThreadCount).hashCode());
        Integer $webSocketClientEventLoopThreadCount = this.webSocketClientEventLoopThreadCount();
        result = result * 59 + ($webSocketClientEventLoopThreadCount == null ? 43 : ((Object)$webSocketClientEventLoopThreadCount).hashCode());
        Long $maxFutureTimeoutInMillis = this.maxFutureTimeoutInMillis();
        result = result * 59 + ($maxFutureTimeoutInMillis == null ? 43 : ((Object)$maxFutureTimeoutInMillis).hashCode());
        Long $maxSocketTimeoutInMillis = this.maxSocketTimeoutInMillis();
        result = result * 59 + ($maxSocketTimeoutInMillis == null ? 43 : ((Object)$maxSocketTimeoutInMillis).hashCode());
        Long $socketConnectionTimeoutInMillis = this.socketConnectionTimeoutInMillis();
        result = result * 59 + ($socketConnectionTimeoutInMillis == null ? 43 : ((Object)$socketConnectionTimeoutInMillis).hashCode());
        Integer $maxInitialLineLength = this.maxInitialLineLength();
        result = result * 59 + ($maxInitialLineLength == null ? 43 : ((Object)$maxInitialLineLength).hashCode());
        Integer $maxHeaderSize = this.maxHeaderSize();
        result = result * 59 + ($maxHeaderSize == null ? 43 : ((Object)$maxHeaderSize).hashCode());
        Integer $maxChunkSize = this.maxChunkSize();
        result = result * 59 + ($maxChunkSize == null ? 43 : ((Object)$maxChunkSize).hashCode());
        String $mockServerName = this.mockServerName();
        result = result * 59 + ($mockServerName == null ? 43 : $mockServerName.hashCode());
        BinaryProxyListener $binaryProxyListener = this.binaryProxyListener();
        result = result * 59 + ($binaryProxyListener == null ? 43 : $binaryProxyListener.hashCode());
        InetSocketAddress $forwardHttpProxy = this.forwardHttpProxy();
        result = result * 59 + ($forwardHttpProxy == null ? 43 : ((Object)$forwardHttpProxy).hashCode());
        InetSocketAddress $forwardHttpsProxy = this.forwardHttpsProxy();
        result = result * 59 + ($forwardHttpsProxy == null ? 43 : ((Object)$forwardHttpsProxy).hashCode());
        InetSocketAddress $forwardSocksProxy = this.forwardSocksProxy();
        result = result * 59 + ($forwardSocksProxy == null ? 43 : ((Object)$forwardSocksProxy).hashCode());
        String $forwardProxyAuthenticationUsername = this.forwardProxyAuthenticationUsername();
        result = result * 59 + ($forwardProxyAuthenticationUsername == null ? 43 : $forwardProxyAuthenticationUsername.hashCode());
        String $forwardProxyAuthenticationPassword = this.forwardProxyAuthenticationPassword();
        result = result * 59 + ($forwardProxyAuthenticationPassword == null ? 43 : $forwardProxyAuthenticationPassword.hashCode());
        String $proxyAuthenticationRealm = this.proxyAuthenticationRealm();
        result = result * 59 + ($proxyAuthenticationRealm == null ? 43 : $proxyAuthenticationRealm.hashCode());
        String $proxyAuthenticationUsername = this.proxyAuthenticationUsername();
        result = result * 59 + ($proxyAuthenticationUsername == null ? 43 : $proxyAuthenticationUsername.hashCode());
        String $proxyAuthenticationPassword = this.proxyAuthenticationPassword();
        result = result * 59 + ($proxyAuthenticationPassword == null ? 43 : $proxyAuthenticationPassword.hashCode());
        String $noProxyHosts = this.noProxyHosts();
        result = result * 59 + ($noProxyHosts == null ? 43 : $noProxyHosts.hashCode());
        String $tlsProtocols = this.tlsProtocols();
        result = result * 59 + ($tlsProtocols == null ? 43 : $tlsProtocols.hashCode());
        KeyAndCertificateFactorySupplier $customKeyAndCertificateFactorySupplier = this.customKeyAndCertificateFactorySupplier();
        result = result * 59 + ($customKeyAndCertificateFactorySupplier == null ? 43 : $customKeyAndCertificateFactorySupplier.hashCode());
        Function<SslContextBuilder, SslContext> $clientSslContextBuilderFunction = this.clientSslContextBuilderFunction();
        result = result * 59 + ($clientSslContextBuilderFunction == null ? 43 : $clientSslContextBuilderFunction.hashCode());
        Consumer<NettySslContextFactory> $nettySslContextFactoryCustomizer = this.nettySslContextFactoryCustomizer();
        result = result * 59 + ($nettySslContextFactoryCustomizer == null ? 43 : $nettySslContextFactoryCustomizer.hashCode());
        UnaryOperator<SslContextBuilder> $sslServerContextBuilderCustomizer = this.sslServerContextBuilderCustomizer();
        result = result * 59 + ($sslServerContextBuilderCustomizer == null ? 43 : $sslServerContextBuilderCustomizer.hashCode());
        UnaryOperator<SslContextBuilder> $sslClientContextBuilderCustomizer = this.sslClientContextBuilderCustomizer();
        result = result * 59 + ($sslClientContextBuilderCustomizer == null ? 43 : $sslClientContextBuilderCustomizer.hashCode());
        Function<X509Certificate, byte[]> $ocspResponseSupplier = this.ocspResponseSupplier();
        result = result * 59 + ($ocspResponseSupplier == null ? 43 : $ocspResponseSupplier.hashCode());
        String $masterSecretFile = this.masterSecretFile();
        result = result * 59 + ($masterSecretFile == null ? 43 : $masterSecretFile.hashCode());
        String $sslCertificateDomainName = this.sslCertificateDomainName();
        result = result * 59 + ($sslCertificateDomainName == null ? 43 : $sslCertificateDomainName.hashCode());
        Set<String> $sslSubjectAlternativeNameDomains = this.sslSubjectAlternativeNameDomains();
        result = result * 59 + ($sslSubjectAlternativeNameDomains == null ? 43 : ((Object)$sslSubjectAlternativeNameDomains).hashCode());
        Set<String> $sslSubjectAlternativeNameIps = this.sslSubjectAlternativeNameIps();
        result = result * 59 + ($sslSubjectAlternativeNameIps == null ? 43 : ((Object)$sslSubjectAlternativeNameIps).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MockServerConfiguration(mockServerName=" + this.mockServerName() + ", nioEventLoopThreadCount=" + this.nioEventLoopThreadCount() + ", actionHandlerThreadCount=" + this.actionHandlerThreadCount() + ", clientNioEventLoopThreadCount=" + this.clientNioEventLoopThreadCount() + ", webSocketClientEventLoopThreadCount=" + this.webSocketClientEventLoopThreadCount() + ", maxFutureTimeoutInMillis=" + this.maxFutureTimeoutInMillis() + ", maxSocketTimeoutInMillis=" + this.maxSocketTimeoutInMillis() + ", socketConnectionTimeoutInMillis=" + this.socketConnectionTimeoutInMillis() + ", alwaysCloseSocketConnections=" + this.alwaysCloseSocketConnections() + ", maxInitialLineLength=" + this.maxInitialLineLength() + ", maxHeaderSize=" + this.maxHeaderSize() + ", maxChunkSize=" + this.maxChunkSize() + ", binaryProxyListener=" + this.binaryProxyListener() + ", enableTlsTermination=" + this.enableTlsTermination() + ", forwardHttpProxy=" + this.forwardHttpProxy() + ", forwardHttpsProxy=" + this.forwardHttpsProxy() + ", forwardSocksProxy=" + this.forwardSocksProxy() + ", forwardProxyAuthenticationUsername=" + this.forwardProxyAuthenticationUsername() + ", forwardProxyAuthenticationPassword=" + this.forwardProxyAuthenticationPassword() + ", proxyAuthenticationRealm=" + this.proxyAuthenticationRealm() + ", proxyAuthenticationUsername=" + this.proxyAuthenticationUsername() + ", proxyAuthenticationPassword=" + this.proxyAuthenticationPassword() + ", noProxyHosts=" + this.noProxyHosts() + ", rebuildServerTlsContext=" + this.rebuildServerTlsContext() + ", tlsProtocols=" + this.tlsProtocols() + ", customKeyAndCertificateFactorySupplier=" + this.customKeyAndCertificateFactorySupplier() + ", clientSslContextBuilderFunction=" + this.clientSslContextBuilderFunction() + ", nettySslContextFactoryCustomizer=" + this.nettySslContextFactoryCustomizer() + ", sslServerContextBuilderCustomizer=" + this.sslServerContextBuilderCustomizer() + ", sslClientContextBuilderCustomizer=" + this.sslClientContextBuilderCustomizer() + ", ocspResponseSupplier=" + this.ocspResponseSupplier() + ", masterSecretFile=" + this.masterSecretFile() + ", sslCertificateDomainName=" + this.sslCertificateDomainName() + ", sslSubjectAlternativeNameDomains=" + this.sslSubjectAlternativeNameDomains() + ", sslSubjectAlternativeNameIps=" + this.sslSubjectAlternativeNameIps() + ")";
    }
}

