/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRoute;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.handler.AbstractRouteProxyCallback;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardProxyCallback
extends AbstractRouteProxyCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ForwardProxyCallback.class);

    public ForwardProxyCallback(TigerProxy tigerProxy, TigerRoute tigerRoute) {
        super(tigerProxy, tigerRoute);
        tigerProxy.addAlternativeName(this.getSourceUri().getHost());
    }

    @Override
    public HttpRequest handleRequest(HttpRequest req) {
        String requestPath;
        String patchedPath;
        this.applyModifications(req);
        req.replaceHeader(Header.header("Host", this.getTargetUrl().getHost() + ":" + this.getPort()));
        if (this.getTigerRoute().getBasicAuth() != null) {
            req.replaceHeader(Header.header("Authorization", this.getTigerRoute().getBasicAuth().toAuthorizationHeaderValue()));
        }
        if ((patchedPath = this.getTargetUrl().getPath()).endsWith("/")) {
            patchedPath = patchedPath.substring(0, patchedPath.length() - 1);
        }
        if ((requestPath = req.getPath()).equals("/") && !this.isAddTrailingSlash()) {
            requestPath = "";
        }
        String path = patchedPath + requestPath;
        return this.cloneRequest(req).setPath(path).setSecure(this.getTigerRoute().getTo().startsWith("https://")).setQueryStringParameters(req.getQueryStringParameters());
    }

    @Override
    protected String extractProtocolAndHostForRequest(HttpRequest request) {
        return this.getSourceUri().getScheme() + "://" + this.getSourceUri().getHost();
    }

    @Override
    protected String printTrafficTarget(HttpRequest req) {
        return this.getTigerRoute().getTo();
    }
}

