/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.facet.TigerNonPairedMessageFacet;
import de.gematik.rbellogger.file.RbelFileWriter;
import de.gematik.test.tiger.proxy.client.PartialTracingMessage;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TracingMessageFrame;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingMessageIsolani
implements TracingMessageFrame {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TracingMessageIsolani.class);
    private PartialTracingMessage message;
    private final TigerRemoteProxyClient remoteProxyClient;

    @Override
    public void checkForCompletePairAndPropagateIfComplete() {
        if (this.message != null && this.message.isComplete()) {
            this.parseAndPropagate();
        }
    }

    private void parseAndPropagate() {
        if (this.remoteProxyClient.messageUuidKnown(this.message.getTracingDto().getRequestUuid())) {
            log.trace("{}Skipping parsing of pair with UUIDs ({} and {}) (received from PUSH): UUID already known", new Object[]{this.remoteProxyClient.proxyName(), this.message.getTracingDto().getRequestUuid(), this.message.getTracingDto().getResponseUuid()});
            return;
        }
        Optional<CompletableFuture<RbelElement>> messageParsed = this.remoteProxyClient.buildNewRbelMessage(this.message.getSender(), this.message.getReceiver(), this.message.buildCompleteContent(), Optional.ofNullable(this.message.getTransmissionTime()), this.message.getTracingDto().getRequestUuid());
        if (messageParsed.isEmpty()) {
            return;
        }
        ((CompletableFuture)messageParsed.get().thenAccept(msg -> {
            try {
                this.doPostConversion((RbelElement)msg);
            }
            catch (RuntimeException e) {
                log.error("{} - Error while processing message with UUID {}", new Object[]{this.remoteProxyClient.proxyName(), this.message.getTracingDto().getRequestUuid(), e});
                throw e;
            }
        })).exceptionally(e -> {
            log.error("{} - Error while processing message with UUID {}", new Object[]{this.remoteProxyClient.proxyName(), this.message.getTracingDto().getRequestUuid(), e});
            return null;
        });
    }

    private void doPostConversion(RbelElement msg) {
        msg.addOrReplaceFacet((RbelFacet)((RbelTcpIpMessageFacet)msg.getFacetOrFail(RbelTcpIpMessageFacet.class)).toBuilder().sequenceNumber(this.message.getTracingDto().getSequenceNumberRequest()).receivedFromRemoteWithUrl(this.remoteProxyClient.getRemoteProxyUrl()).build());
        this.triggerPostConversionListener(msg);
        msg.addFacet((RbelFacet)new TigerNonPairedMessageFacet());
        if (log.isTraceEnabled()) {
            log.trace("{}Received isolani message to {} (UUID {})", new Object[]{this.remoteProxyClient.proxyName(), Optional.of(msg).map(RbelElement::getRawStringContent).map(s -> Stream.of(s.split(" ")).skip(1L).limit(1L).collect(Collectors.joining(","))).orElse("<>"), msg.getUuid()});
        }
        this.remoteProxyClient.getLastMessageUuid().set(msg.getUuid());
        if (this.remoteProxyClient.messageMatchesFilterCriterion(msg)) {
            this.remoteProxyClient.propagateMessage(msg);
        } else {
            this.remoteProxyClient.removeMessage(msg);
        }
    }

    private void triggerPostConversionListener(RbelElement msg) {
        RbelFileWriter.DEFAULT_POST_CONVERSION_LISTENER.forEach(listener -> listener.performMessagePostConversionProcessing(msg, this.remoteProxyClient.getRbelLogger().getRbelConverter(), new JSONObject(this.message.getAdditionalInformation())));
    }

    @ConstructorProperties(value={"remoteProxyClient"})
    @Generated
    public TracingMessageIsolani(TigerRemoteProxyClient remoteProxyClient) {
        this.remoteProxyClient = remoteProxyClient;
    }

    @Generated
    public PartialTracingMessage getMessage() {
        return this.message;
    }

    @Generated
    public TigerRemoteProxyClient getRemoteProxyClient() {
        return this.remoteProxyClient;
    }

    @Generated
    public void setMessage(PartialTracingMessage message) {
        this.message = message;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TracingMessageIsolani)) {
            return false;
        }
        TracingMessageIsolani other = (TracingMessageIsolani)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PartialTracingMessage this$message = this.getMessage();
        PartialTracingMessage other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        TigerRemoteProxyClient this$remoteProxyClient = this.getRemoteProxyClient();
        TigerRemoteProxyClient other$remoteProxyClient = other.getRemoteProxyClient();
        return !(this$remoteProxyClient == null ? other$remoteProxyClient != null : !((Object)this$remoteProxyClient).equals(other$remoteProxyClient));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TracingMessageIsolani;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartialTracingMessage $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        TigerRemoteProxyClient $remoteProxyClient = this.getRemoteProxyClient();
        result = result * 59 + ($remoteProxyClient == null ? 43 : ((Object)$remoteProxyClient).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TracingMessageIsolani(message=" + this.getMessage() + ")";
    }
}

