/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelElementConvertionPair;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.util.IRbelMessageListener;
import de.gematik.test.tiger.common.config.RbelModificationDescription;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRoute;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.client.PartialTracingMessage;
import de.gematik.test.tiger.proxy.client.TigerExceptionDto;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.client.TigerRemoteTrafficDownloader;
import de.gematik.test.tiger.proxy.client.TigerStompSessionHandler;
import de.gematik.test.tiger.proxy.client.TracingMessagePart;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.WebSocketContainer;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import kong.unirest.GenericType;
import kong.unirest.Unirest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.messaging.WebSocketStompClient;
import org.springframework.web.socket.sockjs.client.SockJsClient;
import org.springframework.web.socket.sockjs.client.WebSocketTransport;

public class TigerRemoteProxyClient
extends AbstractTigerProxy
implements AutoCloseable {
    public static final String WS_TRACING = "/topic/traces";
    public static final String WS_DATA = "/topic/data";
    public static final String WS_ERRORS = "/topic/errors";
    private final String remoteProxyUrl;
    private final WebSocketStompClient tigerProxyStompClient;
    private final List<TigerExceptionDto> receivedRemoteExceptions = new ArrayList<TigerExceptionDto>();
    private final Map<String, PartialTracingMessage> partiallyReceivedMessageMap = new HashMap<String, PartialTracingMessage>();
    private final TigerStompSessionHandler tigerStompSessionHandler;
    @Nullable
    private final TigerProxy masterTigerProxy;
    private Duration maximumPartialMessageAge;
    private final AtomicReference<StompSession> stompSession = new AtomicReference();
    private final AtomicReference<String> lastMessageUuid = new AtomicReference();
    private final SockJsClient webSocketClient;
    private final int connectionTimeoutInSeconds;

    public TigerRemoteProxyClient(String remoteProxyUrl) {
        this(remoteProxyUrl, new TigerProxyConfiguration(), null);
    }

    public TigerRemoteProxyClient(String remoteProxyUrl, TigerProxyConfiguration configuration) {
        this(remoteProxyUrl, configuration, null);
    }

    public TigerRemoteProxyClient(String remoteProxyUrl, TigerProxyConfiguration configuration, @Nullable TigerProxy masterTigerProxy) {
        super(configuration, masterTigerProxy == null ? null : masterTigerProxy.getRbelLogger());
        this.remoteProxyUrl = remoteProxyUrl;
        this.masterTigerProxy = masterTigerProxy;
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        container.setDefaultMaxBinaryMessageBufferSize(0x100000 * configuration.getPerMessageBufferSizeInMb());
        container.setDefaultMaxTextMessageBufferSize(0x100000 * configuration.getPerMessageBufferSizeInMb());
        MappingJackson2MessageConverter messageConverter = new MappingJackson2MessageConverter();
        messageConverter.getObjectMapper().registerModule((Module)new JavaTimeModule());
        StandardWebSocketClient wsClient = new StandardWebSocketClient(container);
        this.webSocketClient = new SockJsClient(List.of(new WebSocketTransport((WebSocketClient)wsClient)));
        this.tigerProxyStompClient = new WebSocketStompClient((WebSocketClient)this.webSocketClient);
        this.tigerProxyStompClient.setMessageConverter((MessageConverter)messageConverter);
        this.tigerProxyStompClient.setInboundMessageSizeLimit(0x100000 * configuration.getStompClientBufferSizeInMb());
        this.tigerStompSessionHandler = new TigerStompSessionHandler(this);
        this.maximumPartialMessageAge = Duration.ofSeconds(configuration.getMaximumPartialMessageAgeInSeconds());
        this.connectionTimeoutInSeconds = configuration.getConnectionTimeoutInSeconds();
    }

    public void connect() {
        this.connectToRemoteUrl(this.tigerStompSessionHandler, this.connectionTimeoutInSeconds, this.getTigerProxyConfiguration().isDownloadInitialTrafficFromEndpoints());
    }

    private String getTracingWebSocketUrl(String remoteProxyUrl) {
        return remoteProxyUrl.replaceFirst("http", "ws") + "/tracing";
    }

    private void downloadTrafficFromRemoteProxy() {
        new TigerRemoteTrafficDownloader(this).execute();
    }

    void connectToRemoteUrl(TigerStompSessionHandler tigerStompSessionHandler, int connectionTimeoutInSeconds, boolean downloadTraffic) {
        if (this.isShuttingDown()) {
            return;
        }
        this.waitForRemoteTigerProxyToBeOnline(this.remoteProxyUrl);
        if (this.isShuttingDown()) {
            return;
        }
        this.log.info("remote proxy at {} is online, now connecting...", (Object)this.remoteProxyUrl);
        String tracingWebSocketUrl = this.getTracingWebSocketUrl(this.remoteProxyUrl);
        ListenableFuture connectFuture = this.tigerProxyStompClient.connect(tracingWebSocketUrl, (StompSessionHandler)tigerStompSessionHandler, new Object[0]);
        connectFuture.addCallback(stompSessionInCallback -> {
            this.log.info("Successfully opened stomp session {} to url {}", (Object)stompSessionInCallback.getSessionId(), (Object)tracingWebSocketUrl);
            tigerStompSessionHandler.setOnConnectedCallback(() -> {
                if (downloadTraffic) {
                    this.downloadTrafficFromRemoteProxy();
                }
            });
        }, throwable -> {
            throw new TigerRemoteProxyClientException("Exception while opening tracing-connection to " + tracingWebSocketUrl, throwable);
        });
        try {
            this.stompSession.set((StompSession)connectFuture.get((long)connectionTimeoutInSeconds, TimeUnit.SECONDS));
        }
        catch (RuntimeException | ExecutionException | TimeoutException e) {
            throw new TigerRemoteProxyClientException("Exception while opening tracing-connection to " + tracingWebSocketUrl, e);
        }
        catch (InterruptedException e) {
            this.log.error("InterruptedException while opening tracing-connection to {}", (Object)tracingWebSocketUrl);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public TigerRoute addRoute(TigerRoute tigerRoute) {
        return (TigerRoute)Unirest.put((String)(this.remoteProxyUrl + "/route")).body((Object)tigerRoute).contentType("application/json").asObject(TigerRoute.class).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to add route. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    @Override
    public void removeRoute(String routeId) {
        Assert.hasText((String)routeId, () -> "No route ID given!");
        Unirest.delete((String)(this.remoteProxyUrl + "/route/" + routeId)).asEmpty().ifFailure(httpResponse -> {
            throw new TigerRemoteProxyClientException("Unable to remove route. Got " + httpResponse);
        });
    }

    @Override
    public String getBaseUrl() {
        return this.remoteProxyUrl;
    }

    @Override
    public int getProxyPort() {
        return 0;
    }

    @Override
    public List<TigerRoute> getRoutes() {
        return (List)Unirest.get((String)(this.remoteProxyUrl + "/route")).asObject((GenericType)new GenericType<List<TigerRoute>>(){}).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to get routes. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    @Override
    public RbelModificationDescription addModificaton(RbelModificationDescription modification) {
        return (RbelModificationDescription)Unirest.put((String)(this.remoteProxyUrl + "/modification")).body((Object)modification).contentType("application/json").asObject(RbelModificationDescription.class).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to add modification. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    @Override
    public List<RbelModificationDescription> getModifications() {
        return (List)Unirest.get((String)(this.remoteProxyUrl + "/modification")).asObject((GenericType)new GenericType<List<RbelModificationDescription>>(){}).ifFailure(response -> {
            throw new TigerRemoteProxyClientException("Unable to get modifications. Got " + response.getStatus() + ": " + (String)response.mapError(String.class));
        }).getBody();
    }

    @Override
    public void removeModification(String modificationName) {
        Assert.hasText((String)modificationName, () -> "No modification name given!");
        Unirest.delete((String)(this.remoteProxyUrl + "/modification/" + modificationName)).asEmpty().ifFailure(httpResponse -> {
            throw new TigerRemoteProxyClientException("Unable to remove modification. Got " + httpResponse);
        });
    }

    Optional<CompletableFuture<RbelElement>> buildNewRbelMessage(RbelHostname sender, RbelHostname receiver, byte[] messageBytes, Optional<ZonedDateTime> transmissionTime, String uuid) {
        return this.buildNewMessage(sender, receiver, messageBytes, Optional.empty(), transmissionTime, uuid);
    }

    Optional<CompletableFuture<RbelElement>> buildNewRbelResponse(RbelHostname sender, RbelHostname receiver, byte[] messageBytes, Optional<CompletableFuture<RbelElement>> parsedRequest, Optional<ZonedDateTime> transmissionTime, String uuid) {
        return this.buildNewMessage(sender, receiver, messageBytes, parsedRequest, transmissionTime, uuid);
    }

    private Optional<CompletableFuture<RbelElement>> buildNewMessage(RbelHostname sender, RbelHostname receiver, byte[] messageBytes, Optional<CompletableFuture<RbelElement>> parsedRequest, Optional<ZonedDateTime> transmissionTime, String uuid) {
        if (messageBytes != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received new message with ID '{}'", (Object)uuid);
            }
            return Optional.of(this.getRbelLogger().getRbelConverter().parseMessageAsync(new RbelElementConvertionPair(RbelElement.builder().uuid(uuid).rawContent(messageBytes).build(), (CompletableFuture)parsedRequest.orElse(null)), sender, receiver, transmissionTime));
        }
        this.log.warn("Received message with content 'null'. Skipping parsing...");
        return Optional.empty();
    }

    void propagateMessage(RbelElement rbelMessage) {
        super.triggerListener(rbelMessage);
    }

    void removeMessage(RbelElement rbelMessage) {
        this.getRbelLogger().getRbelConverter().removeMessage(rbelMessage);
    }

    public boolean messageMatchesFilterCriterion(RbelElement rbelMessage) {
        if (StringUtils.isEmpty((CharSequence)this.getTigerProxyConfiguration().getTrafficEndpointFilterString())) {
            return true;
        }
        return TigerJexlExecutor.matchesAsJexlExpression((Object)rbelMessage, (String)this.getTigerProxyConfiguration().getTrafficEndpointFilterString(), Optional.empty());
    }

    @Override
    public void close() {
        super.close();
        this.log.debug("Stopping websocket client with remote URL '{}'", (Object)this.remoteProxyUrl);
        if (this.stompSession.get() != null && this.stompSession.get().isConnected()) {
            this.stompSession.get().disconnect();
        }
        this.tigerProxyStompClient.stop();
        this.webSocketClient.stop();
    }

    void receiveNewMessagePart(TracingMessagePart tracingMessagePart) {
        PartialTracingMessage tracingMessage = this.retrieveOrInitializePartialMessage(tracingMessagePart.getUuid(), PartialTracingMessage.builder().build());
        tracingMessage.getMessageParts().add(tracingMessagePart);
        this.checkForCompletion(tracingMessage, tracingMessagePart.getUuid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartialTracingMessage retrieveOrInitializePartialMessage(String uuid, PartialTracingMessage message) {
        Map<String, PartialTracingMessage> map = this.partiallyReceivedMessageMap;
        synchronized (map) {
            if (this.partiallyReceivedMessageMap.containsKey(uuid)) {
                return this.partiallyReceivedMessageMap.get(uuid);
            }
            this.partiallyReceivedMessageMap.put(uuid, message);
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initOrUpdateMessagePart(String uuid, PartialTracingMessage partialTracingMessage) {
        Map<String, PartialTracingMessage> map = this.partiallyReceivedMessageMap;
        synchronized (map) {
            if (this.partiallyReceivedMessageMap.containsKey(uuid)) {
                PartialTracingMessage oldMessage = this.partiallyReceivedMessageMap.get(uuid);
                partialTracingMessage.getMessageParts().addAll(oldMessage.getMessageParts());
            }
            this.partiallyReceivedMessageMap.put(uuid, partialTracingMessage);
        }
        this.checkForCompletion(partialTracingMessage, uuid);
    }

    private void checkForCompletion(PartialTracingMessage tracingMessage, String messageUuid) {
        if (tracingMessage.isComplete()) {
            tracingMessage.getMessageFrame().checkForCompletePairAndPropagateIfComplete();
            this.partiallyReceivedMessageMap.remove(messageUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerPartialMessageCleanup() {
        ZonedDateTime cutoff = ZonedDateTime.now().minus(this.maximumPartialMessageAge);
        Map<String, PartialTracingMessage> map = this.partiallyReceivedMessageMap;
        synchronized (map) {
            Iterator<PartialTracingMessage> entryIterator = this.partiallyReceivedMessageMap.values().iterator();
            while (entryIterator.hasNext()) {
                PartialTracingMessage next = entryIterator.next();
                this.log.trace("Trying to remove {}, cutoff is {}", (Object)next.getReceivedTime(), (Object)cutoff);
                if (!cutoff.isAfter(next.getReceivedTime())) continue;
                entryIterator.remove();
            }
        }
    }

    public boolean messageUuidKnown(String messageUuid) {
        return this.getRbelLogger().getRbelConverter().isMessageUuidAlreadyKnown(messageUuid);
    }

    public boolean isConnected() {
        return Optional.ofNullable(this.stompSession).map(AtomicReference::get).filter(Objects::nonNull).map(StompSession::isConnected).orElse(false);
    }

    @Override
    public void triggerListener(RbelElement element) {
        if (this.masterTigerProxy != null) {
            this.masterTigerProxy.triggerListener(element);
        } else {
            super.triggerListener(element);
        }
    }

    @Override
    public List<IRbelMessageListener> getRbelMessageListeners() {
        if (this.masterTigerProxy != null) {
            return this.masterTigerProxy.getRbelMessageListeners();
        }
        return super.getRbelMessageListeners();
    }

    @Override
    public void addRbelMessageListener(IRbelMessageListener listener) {
        if (this.masterTigerProxy != null) {
            this.masterTigerProxy.addRbelMessageListener(listener);
        } else {
            super.addRbelMessageListener(listener);
        }
    }

    @Override
    public void removeRbelMessageListener(IRbelMessageListener listener) {
        if (this.masterTigerProxy != null) {
            this.masterTigerProxy.removeRbelMessageListener(listener);
        } else {
            super.removeRbelMessageListener(listener);
        }
    }

    @Generated
    public String getRemoteProxyUrl() {
        return this.remoteProxyUrl;
    }

    @Generated
    public List<TigerExceptionDto> getReceivedRemoteExceptions() {
        return this.receivedRemoteExceptions;
    }

    @Generated
    public Map<String, PartialTracingMessage> getPartiallyReceivedMessageMap() {
        return this.partiallyReceivedMessageMap;
    }

    @Generated
    public TigerStompSessionHandler getTigerStompSessionHandler() {
        return this.tigerStompSessionHandler;
    }

    @Generated
    public Duration getMaximumPartialMessageAge() {
        return this.maximumPartialMessageAge;
    }

    @Generated
    public void setMaximumPartialMessageAge(Duration maximumPartialMessageAge) {
        this.maximumPartialMessageAge = maximumPartialMessageAge;
    }

    @Generated
    public AtomicReference<String> getLastMessageUuid() {
        return this.lastMessageUuid;
    }
}

