/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.scheduler;

import com.google.common.annotations.VisibleForTesting;
import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.httpclient.SocketCommunicationException;
import de.gematik.test.tiger.mockserver.mock.HttpState;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpForwardActionResult;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.mockserver.model.Delay;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Scheduler.class);
    private final Configuration configuration;
    private final ScheduledExecutorService scheduler;
    private final boolean synchronous;

    public Scheduler(Configuration configuration) {
        this(configuration, false);
    }

    @VisibleForTesting
    public Scheduler(Configuration configuration, boolean synchronous) {
        this.configuration = configuration;
        this.synchronous = synchronous;
        this.scheduler = !this.synchronous ? new ScheduledThreadPoolExecutor(configuration.actionHandlerThreadCount(), new SchedulerThreadFactory("Scheduler"), new ThreadPoolExecutor.CallerRunsPolicy()) : null;
    }

    public synchronized void shutdown() {
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void run(Runnable command, Integer port) {
        HttpState.setPort(port);
        try {
            command.run();
        }
        catch (RuntimeException throwable) {
            log.info("Error", (Throwable)throwable);
        }
    }

    public void schedule(Runnable command, boolean synchronous, Delay ... delays) {
        Delay delay = this.addDelays(delays);
        Integer port = HttpState.getPort();
        if (this.synchronous || synchronous) {
            if (delay != null) {
                delay.applyDelay();
            }
            this.run(command, port);
        } else if (delay != null) {
            this.scheduler.schedule(() -> this.run(command, port), delay.getValue(), delay.getTimeUnit());
        } else {
            this.run(command, port);
        }
    }

    private Delay addDelays(Delay ... delays) {
        if (delays == null || delays.length == 0) {
            return null;
        }
        if (delays.length == 1) {
            return delays[0];
        }
        if (delays.length == 2 && delays[0] == delays[1]) {
            return delays[0];
        }
        long timeInMilliseconds = 0L;
        for (Delay delay : delays) {
            if (delay == null) continue;
            timeInMilliseconds += delay.getTimeUnit().toMillis(delay.getValue());
        }
        return new Delay(TimeUnit.MILLISECONDS, timeInMilliseconds);
    }

    public void submit(Runnable command) {
        this.submit(command, false);
    }

    public void submit(Runnable command, boolean synchronous) {
        Integer port = HttpState.getPort();
        if (this.synchronous || synchronous) {
            this.run(command, port);
        } else {
            this.scheduler.submit(() -> this.run(command, port));
        }
    }

    public void submit(HttpForwardActionResult future, Runnable command, boolean synchronous, Predicate<Throwable> logException) {
        Integer port = HttpState.getPort();
        if (future != null) {
            if (this.synchronous || synchronous) {
                try {
                    future.getHttpResponse().get(this.configuration.maxSocketTimeoutInMillis(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    future.getHttpResponse().completeExceptionally(new SocketCommunicationException("Response was not received after " + this.configuration.maxSocketTimeoutInMillis() + " milliseconds, to make the proxy wait longer please use \"mockserver.maxSocketTimeout\" system property or configuration.maxSocketTimeout(long milliseconds)", e.getCause()));
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    future.getHttpResponse().completeExceptionally(ex);
                }
                catch (ExecutionException ex) {
                    future.getHttpResponse().completeExceptionally(ex);
                }
                this.run(command, port);
            } else {
                future.getHttpResponse().whenCompleteAsync((httpResponse, throwable) -> {
                    if (throwable != null && logException.test((Throwable)throwable)) {
                        log.info(throwable.getMessage(), throwable);
                    }
                    this.run(command, port);
                }, (Executor)this.scheduler);
            }
        }
    }

    public void submit(CompletableFuture<BinaryMessage> future, Runnable command, boolean synchronous) {
        Integer port = HttpState.getPort();
        if (future != null) {
            if (this.synchronous || synchronous) {
                try {
                    future.get(this.configuration.maxSocketTimeoutInMillis(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    future.completeExceptionally(new SocketCommunicationException("Response was not received after " + this.configuration.maxSocketTimeoutInMillis() + " milliseconds, to make the proxy wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause()));
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    future.completeExceptionally(ex);
                }
                catch (ExecutionException ex) {
                    future.completeExceptionally(ex);
                }
                this.run(command, port);
            } else {
                future.whenCompleteAsync((httpResponse, throwable) -> command.run(), (Executor)this.scheduler);
            }
        }
    }

    public void submit(HttpForwardActionResult future, BiConsumer<HttpResponse, Throwable> consumer, boolean synchronous) {
        if (future != null) {
            if (this.synchronous || synchronous) {
                HttpResponse httpResponse = null;
                Exception exception = null;
                try {
                    httpResponse = future.getHttpResponse().get(this.configuration.maxSocketTimeoutInMillis(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    exception = new SocketCommunicationException("Response was not received after " + this.configuration.maxSocketTimeoutInMillis() + " milliseconds, to make the proxy wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause());
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    exception = ex;
                }
                catch (ExecutionException ex) {
                    exception = ex;
                }
                try {
                    consumer.accept(httpResponse, exception);
                }
                catch (RuntimeException throwable) {
                    log.info(throwable.getMessage(), (Throwable)throwable);
                }
            } else {
                future.getHttpResponse().whenCompleteAsync((BiConsumer)consumer, (Executor)this.scheduler);
            }
        }
    }

    public static class SchedulerThreadFactory
    implements ThreadFactory {
        private final String name;
        private final boolean daemon;
        private static int threadInitNumber;

        public SchedulerThreadFactory(String name) {
            this.name = name;
            this.daemon = true;
        }

        public SchedulerThreadFactory(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "MockServer-" + this.name + threadInitNumber++);
            thread.setDaemon(this.daemon);
            return thread;
        }
    }
}

