/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.configuration;

import de.gematik.test.tiger.mockserver.model.BinaryProxyListener;
import de.gematik.test.tiger.mockserver.socket.tls.ForwardProxyTLSX509CertificatesTrustManager;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAndCertificateFactorySupplier;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.slf4j.event.Level;

public class Configuration {
    private Level logLevel = Level.INFO;
    private Boolean disableSystemOut = false;
    private Boolean disableLogging = false;
    private Boolean detailedMatchFailures = true;
    private Boolean launchUIForLogLevelDebug = false;
    private Boolean metricsEnabled = false;
    private String mockServerName = null;
    private Integer nioEventLoopThreadCount = 5;
    private Integer actionHandlerThreadCount = Math.max(5, Runtime.getRuntime().availableProcessors());
    private Integer clientNioEventLoopThreadCount = 5;
    private Integer webSocketClientEventLoopThreadCount = 5;
    private Long maxFutureTimeoutInMillis = TimeUnit.SECONDS.toMillis(90L);
    private boolean matchersFailFast = true;
    private Long maxSocketTimeoutInMillis = TimeUnit.SECONDS.toMillis(20L);
    private Long socketConnectionTimeoutInMillis = TimeUnit.SECONDS.toMillis(20L);
    private boolean alwaysCloseSocketConnections = false;
    private String localBoundIP = "";
    private Integer maxInitialLineLength = Integer.MAX_VALUE;
    private Integer maxHeaderSize = Integer.MAX_VALUE;
    private Integer maxChunkSize = Integer.MAX_VALUE;
    private boolean useSemicolonAsQueryParameterSeparator = true;
    private boolean assumeAllRequestsAreHttp = false;
    private BinaryProxyListener binaryProxyListener = null;
    private boolean enableCORSForAPI = false;
    private boolean enableCORSForAllResponses = false;
    private String corsAllowOrigin = "";
    private String corsAllowMethods = "";
    private String corsAllowHeaders = "";
    private boolean corsAllowCredentials = false;
    private Integer corsMaxAgeInSeconds = 0;
    private boolean attemptToProxyIfNoMatchingExpectation = false;
    private InetSocketAddress forwardHttpProxy = null;
    private InetSocketAddress forwardHttpsProxy = null;
    private InetSocketAddress forwardSocksProxy = null;
    private String forwardProxyAuthenticationUsername = "";
    private String forwardProxyAuthenticationPassword = "";
    private String proxyAuthenticationRealm = "";
    private String proxyAuthenticationUsername = "";
    private String proxyAuthenticationPassword = "";
    private String noProxyHosts = "";
    private String livenessHttpGetPath = "";
    private boolean proactivelyInitialiseTLS = false;
    private boolean rebuildTLSContext = false;
    private boolean rebuildServerTlsContext = false;
    private String tlsProtocols = "TLSv1,TLSv1.1,TLSv1.2";
    private KeyAndCertificateFactorySupplier customKeyAndCertificateFactorySupplier = null;
    private Function<SslContextBuilder, SslContext> clientSslContextBuilderFunction = null;
    private Consumer<NettySslContextFactory> nettySslContextFactoryCustomizer = factory -> {};
    private UnaryOperator<SslContextBuilder> sslServerContextBuilderCustomizer = UnaryOperator.identity();
    private UnaryOperator<SslContextBuilder> sslClientContextBuilderCustomizer = UnaryOperator.identity();
    private Function<X509Certificate, byte[]> ocspResponseSupplier = null;
    private boolean preventCertificateDynamicUpdate = false;
    private String sslCertificateDomainName = "localhost";
    private Set<String> sslSubjectAlternativeNameDomains = new HashSet<String>(Set.of("localhost"));
    private Set<String> sslSubjectAlternativeNameIps = new HashSet<String>(Set.of("127.0.0.1", "0.0.0.0"));
    private String certificateAuthorityPrivateKey = "org/mockserver/socket/PKCS8CertificateAuthorityPrivateKey.pem";
    private String certificateAuthorityCertificate = "org/mockserver/socket/CertificateAuthorityCertificate.pem";
    private Boolean tlsMutualAuthenticationRequired = false;
    private String tlsMutualAuthenticationCertificateChain = "";
    private ForwardProxyTLSX509CertificatesTrustManager forwardProxyTLSX509CertificatesTrustManagerType = ForwardProxyTLSX509CertificatesTrustManager.ANY;
    private String forwardProxyTLSCustomTrustX509Certificates = "";
    private String forwardProxyPrivateKey = "";
    private String forwardProxyCertificateChain = "";

    public static Configuration configuration() {
        return new Configuration();
    }

    public void addSubjectAlternativeName(String newSubjectAlternativeName) {
        this.sslSubjectAlternativeNameDomains.add(newSubjectAlternativeName);
        this.rebuildServerTlsContext = true;
    }

    @Generated
    public Configuration() {
    }

    @Generated
    public Level logLevel() {
        return this.logLevel;
    }

    @Generated
    public Boolean disableSystemOut() {
        return this.disableSystemOut;
    }

    @Generated
    public Boolean disableLogging() {
        return this.disableLogging;
    }

    @Generated
    public Boolean detailedMatchFailures() {
        return this.detailedMatchFailures;
    }

    @Generated
    public Boolean launchUIForLogLevelDebug() {
        return this.launchUIForLogLevelDebug;
    }

    @Generated
    public Boolean metricsEnabled() {
        return this.metricsEnabled;
    }

    @Generated
    public String mockServerName() {
        return this.mockServerName;
    }

    @Generated
    public Integer nioEventLoopThreadCount() {
        return this.nioEventLoopThreadCount;
    }

    @Generated
    public Integer actionHandlerThreadCount() {
        return this.actionHandlerThreadCount;
    }

    @Generated
    public Integer clientNioEventLoopThreadCount() {
        return this.clientNioEventLoopThreadCount;
    }

    @Generated
    public Integer webSocketClientEventLoopThreadCount() {
        return this.webSocketClientEventLoopThreadCount;
    }

    @Generated
    public Long maxFutureTimeoutInMillis() {
        return this.maxFutureTimeoutInMillis;
    }

    @Generated
    public boolean matchersFailFast() {
        return this.matchersFailFast;
    }

    @Generated
    public Long maxSocketTimeoutInMillis() {
        return this.maxSocketTimeoutInMillis;
    }

    @Generated
    public Long socketConnectionTimeoutInMillis() {
        return this.socketConnectionTimeoutInMillis;
    }

    @Generated
    public boolean alwaysCloseSocketConnections() {
        return this.alwaysCloseSocketConnections;
    }

    @Generated
    public String localBoundIP() {
        return this.localBoundIP;
    }

    @Generated
    public Integer maxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    @Generated
    public Integer maxHeaderSize() {
        return this.maxHeaderSize;
    }

    @Generated
    public Integer maxChunkSize() {
        return this.maxChunkSize;
    }

    @Generated
    public boolean useSemicolonAsQueryParameterSeparator() {
        return this.useSemicolonAsQueryParameterSeparator;
    }

    @Generated
    public boolean assumeAllRequestsAreHttp() {
        return this.assumeAllRequestsAreHttp;
    }

    @Generated
    public BinaryProxyListener binaryProxyListener() {
        return this.binaryProxyListener;
    }

    @Generated
    public boolean enableCORSForAPI() {
        return this.enableCORSForAPI;
    }

    @Generated
    public boolean enableCORSForAllResponses() {
        return this.enableCORSForAllResponses;
    }

    @Generated
    public String corsAllowOrigin() {
        return this.corsAllowOrigin;
    }

    @Generated
    public String corsAllowMethods() {
        return this.corsAllowMethods;
    }

    @Generated
    public String corsAllowHeaders() {
        return this.corsAllowHeaders;
    }

    @Generated
    public boolean corsAllowCredentials() {
        return this.corsAllowCredentials;
    }

    @Generated
    public Integer corsMaxAgeInSeconds() {
        return this.corsMaxAgeInSeconds;
    }

    @Generated
    public boolean attemptToProxyIfNoMatchingExpectation() {
        return this.attemptToProxyIfNoMatchingExpectation;
    }

    @Generated
    public InetSocketAddress forwardHttpProxy() {
        return this.forwardHttpProxy;
    }

    @Generated
    public InetSocketAddress forwardHttpsProxy() {
        return this.forwardHttpsProxy;
    }

    @Generated
    public InetSocketAddress forwardSocksProxy() {
        return this.forwardSocksProxy;
    }

    @Generated
    public String forwardProxyAuthenticationUsername() {
        return this.forwardProxyAuthenticationUsername;
    }

    @Generated
    public String forwardProxyAuthenticationPassword() {
        return this.forwardProxyAuthenticationPassword;
    }

    @Generated
    public String proxyAuthenticationRealm() {
        return this.proxyAuthenticationRealm;
    }

    @Generated
    public String proxyAuthenticationUsername() {
        return this.proxyAuthenticationUsername;
    }

    @Generated
    public String proxyAuthenticationPassword() {
        return this.proxyAuthenticationPassword;
    }

    @Generated
    public String noProxyHosts() {
        return this.noProxyHosts;
    }

    @Generated
    public String livenessHttpGetPath() {
        return this.livenessHttpGetPath;
    }

    @Generated
    public boolean proactivelyInitialiseTLS() {
        return this.proactivelyInitialiseTLS;
    }

    @Generated
    public boolean rebuildTLSContext() {
        return this.rebuildTLSContext;
    }

    @Generated
    public boolean rebuildServerTlsContext() {
        return this.rebuildServerTlsContext;
    }

    @Generated
    public String tlsProtocols() {
        return this.tlsProtocols;
    }

    @Generated
    public KeyAndCertificateFactorySupplier customKeyAndCertificateFactorySupplier() {
        return this.customKeyAndCertificateFactorySupplier;
    }

    @Generated
    public Function<SslContextBuilder, SslContext> clientSslContextBuilderFunction() {
        return this.clientSslContextBuilderFunction;
    }

    @Generated
    public Consumer<NettySslContextFactory> nettySslContextFactoryCustomizer() {
        return this.nettySslContextFactoryCustomizer;
    }

    @Generated
    public UnaryOperator<SslContextBuilder> sslServerContextBuilderCustomizer() {
        return this.sslServerContextBuilderCustomizer;
    }

    @Generated
    public UnaryOperator<SslContextBuilder> sslClientContextBuilderCustomizer() {
        return this.sslClientContextBuilderCustomizer;
    }

    @Generated
    public Function<X509Certificate, byte[]> ocspResponseSupplier() {
        return this.ocspResponseSupplier;
    }

    @Generated
    public boolean preventCertificateDynamicUpdate() {
        return this.preventCertificateDynamicUpdate;
    }

    @Generated
    public String sslCertificateDomainName() {
        return this.sslCertificateDomainName;
    }

    @Generated
    public Set<String> sslSubjectAlternativeNameDomains() {
        return this.sslSubjectAlternativeNameDomains;
    }

    @Generated
    public Set<String> sslSubjectAlternativeNameIps() {
        return this.sslSubjectAlternativeNameIps;
    }

    @Generated
    public String certificateAuthorityPrivateKey() {
        return this.certificateAuthorityPrivateKey;
    }

    @Generated
    public String certificateAuthorityCertificate() {
        return this.certificateAuthorityCertificate;
    }

    @Generated
    public Boolean tlsMutualAuthenticationRequired() {
        return this.tlsMutualAuthenticationRequired;
    }

    @Generated
    public String tlsMutualAuthenticationCertificateChain() {
        return this.tlsMutualAuthenticationCertificateChain;
    }

    @Generated
    public ForwardProxyTLSX509CertificatesTrustManager forwardProxyTLSX509CertificatesTrustManagerType() {
        return this.forwardProxyTLSX509CertificatesTrustManagerType;
    }

    @Generated
    public String forwardProxyTLSCustomTrustX509Certificates() {
        return this.forwardProxyTLSCustomTrustX509Certificates;
    }

    @Generated
    public String forwardProxyPrivateKey() {
        return this.forwardProxyPrivateKey;
    }

    @Generated
    public String forwardProxyCertificateChain() {
        return this.forwardProxyCertificateChain;
    }

    @Generated
    public Configuration logLevel(Level logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @Generated
    public Configuration disableSystemOut(Boolean disableSystemOut) {
        this.disableSystemOut = disableSystemOut;
        return this;
    }

    @Generated
    public Configuration disableLogging(Boolean disableLogging) {
        this.disableLogging = disableLogging;
        return this;
    }

    @Generated
    public Configuration detailedMatchFailures(Boolean detailedMatchFailures) {
        this.detailedMatchFailures = detailedMatchFailures;
        return this;
    }

    @Generated
    public Configuration launchUIForLogLevelDebug(Boolean launchUIForLogLevelDebug) {
        this.launchUIForLogLevelDebug = launchUIForLogLevelDebug;
        return this;
    }

    @Generated
    public Configuration metricsEnabled(Boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
        return this;
    }

    @Generated
    public Configuration mockServerName(String mockServerName) {
        this.mockServerName = mockServerName;
        return this;
    }

    @Generated
    public Configuration nioEventLoopThreadCount(Integer nioEventLoopThreadCount) {
        this.nioEventLoopThreadCount = nioEventLoopThreadCount;
        return this;
    }

    @Generated
    public Configuration actionHandlerThreadCount(Integer actionHandlerThreadCount) {
        this.actionHandlerThreadCount = actionHandlerThreadCount;
        return this;
    }

    @Generated
    public Configuration clientNioEventLoopThreadCount(Integer clientNioEventLoopThreadCount) {
        this.clientNioEventLoopThreadCount = clientNioEventLoopThreadCount;
        return this;
    }

    @Generated
    public Configuration webSocketClientEventLoopThreadCount(Integer webSocketClientEventLoopThreadCount) {
        this.webSocketClientEventLoopThreadCount = webSocketClientEventLoopThreadCount;
        return this;
    }

    @Generated
    public Configuration maxFutureTimeoutInMillis(Long maxFutureTimeoutInMillis) {
        this.maxFutureTimeoutInMillis = maxFutureTimeoutInMillis;
        return this;
    }

    @Generated
    public Configuration matchersFailFast(boolean matchersFailFast) {
        this.matchersFailFast = matchersFailFast;
        return this;
    }

    @Generated
    public Configuration maxSocketTimeoutInMillis(Long maxSocketTimeoutInMillis) {
        this.maxSocketTimeoutInMillis = maxSocketTimeoutInMillis;
        return this;
    }

    @Generated
    public Configuration socketConnectionTimeoutInMillis(Long socketConnectionTimeoutInMillis) {
        this.socketConnectionTimeoutInMillis = socketConnectionTimeoutInMillis;
        return this;
    }

    @Generated
    public Configuration alwaysCloseSocketConnections(boolean alwaysCloseSocketConnections) {
        this.alwaysCloseSocketConnections = alwaysCloseSocketConnections;
        return this;
    }

    @Generated
    public Configuration localBoundIP(String localBoundIP) {
        this.localBoundIP = localBoundIP;
        return this;
    }

    @Generated
    public Configuration maxInitialLineLength(Integer maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
        return this;
    }

    @Generated
    public Configuration maxHeaderSize(Integer maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
        return this;
    }

    @Generated
    public Configuration maxChunkSize(Integer maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    @Generated
    public Configuration useSemicolonAsQueryParameterSeparator(boolean useSemicolonAsQueryParameterSeparator) {
        this.useSemicolonAsQueryParameterSeparator = useSemicolonAsQueryParameterSeparator;
        return this;
    }

    @Generated
    public Configuration assumeAllRequestsAreHttp(boolean assumeAllRequestsAreHttp) {
        this.assumeAllRequestsAreHttp = assumeAllRequestsAreHttp;
        return this;
    }

    @Generated
    public Configuration binaryProxyListener(BinaryProxyListener binaryProxyListener) {
        this.binaryProxyListener = binaryProxyListener;
        return this;
    }

    @Generated
    public Configuration enableCORSForAPI(boolean enableCORSForAPI) {
        this.enableCORSForAPI = enableCORSForAPI;
        return this;
    }

    @Generated
    public Configuration enableCORSForAllResponses(boolean enableCORSForAllResponses) {
        this.enableCORSForAllResponses = enableCORSForAllResponses;
        return this;
    }

    @Generated
    public Configuration corsAllowOrigin(String corsAllowOrigin) {
        this.corsAllowOrigin = corsAllowOrigin;
        return this;
    }

    @Generated
    public Configuration corsAllowMethods(String corsAllowMethods) {
        this.corsAllowMethods = corsAllowMethods;
        return this;
    }

    @Generated
    public Configuration corsAllowHeaders(String corsAllowHeaders) {
        this.corsAllowHeaders = corsAllowHeaders;
        return this;
    }

    @Generated
    public Configuration corsAllowCredentials(boolean corsAllowCredentials) {
        this.corsAllowCredentials = corsAllowCredentials;
        return this;
    }

    @Generated
    public Configuration corsMaxAgeInSeconds(Integer corsMaxAgeInSeconds) {
        this.corsMaxAgeInSeconds = corsMaxAgeInSeconds;
        return this;
    }

    @Generated
    public Configuration attemptToProxyIfNoMatchingExpectation(boolean attemptToProxyIfNoMatchingExpectation) {
        this.attemptToProxyIfNoMatchingExpectation = attemptToProxyIfNoMatchingExpectation;
        return this;
    }

    @Generated
    public Configuration forwardHttpProxy(InetSocketAddress forwardHttpProxy) {
        this.forwardHttpProxy = forwardHttpProxy;
        return this;
    }

    @Generated
    public Configuration forwardHttpsProxy(InetSocketAddress forwardHttpsProxy) {
        this.forwardHttpsProxy = forwardHttpsProxy;
        return this;
    }

    @Generated
    public Configuration forwardSocksProxy(InetSocketAddress forwardSocksProxy) {
        this.forwardSocksProxy = forwardSocksProxy;
        return this;
    }

    @Generated
    public Configuration forwardProxyAuthenticationUsername(String forwardProxyAuthenticationUsername) {
        this.forwardProxyAuthenticationUsername = forwardProxyAuthenticationUsername;
        return this;
    }

    @Generated
    public Configuration forwardProxyAuthenticationPassword(String forwardProxyAuthenticationPassword) {
        this.forwardProxyAuthenticationPassword = forwardProxyAuthenticationPassword;
        return this;
    }

    @Generated
    public Configuration proxyAuthenticationRealm(String proxyAuthenticationRealm) {
        this.proxyAuthenticationRealm = proxyAuthenticationRealm;
        return this;
    }

    @Generated
    public Configuration proxyAuthenticationUsername(String proxyAuthenticationUsername) {
        this.proxyAuthenticationUsername = proxyAuthenticationUsername;
        return this;
    }

    @Generated
    public Configuration proxyAuthenticationPassword(String proxyAuthenticationPassword) {
        this.proxyAuthenticationPassword = proxyAuthenticationPassword;
        return this;
    }

    @Generated
    public Configuration noProxyHosts(String noProxyHosts) {
        this.noProxyHosts = noProxyHosts;
        return this;
    }

    @Generated
    public Configuration livenessHttpGetPath(String livenessHttpGetPath) {
        this.livenessHttpGetPath = livenessHttpGetPath;
        return this;
    }

    @Generated
    public Configuration proactivelyInitialiseTLS(boolean proactivelyInitialiseTLS) {
        this.proactivelyInitialiseTLS = proactivelyInitialiseTLS;
        return this;
    }

    @Generated
    public Configuration rebuildTLSContext(boolean rebuildTLSContext) {
        this.rebuildTLSContext = rebuildTLSContext;
        return this;
    }

    @Generated
    public Configuration rebuildServerTlsContext(boolean rebuildServerTlsContext) {
        this.rebuildServerTlsContext = rebuildServerTlsContext;
        return this;
    }

    @Generated
    public Configuration tlsProtocols(String tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
        return this;
    }

    @Generated
    public Configuration customKeyAndCertificateFactorySupplier(KeyAndCertificateFactorySupplier customKeyAndCertificateFactorySupplier) {
        this.customKeyAndCertificateFactorySupplier = customKeyAndCertificateFactorySupplier;
        return this;
    }

    @Generated
    public Configuration clientSslContextBuilderFunction(Function<SslContextBuilder, SslContext> clientSslContextBuilderFunction) {
        this.clientSslContextBuilderFunction = clientSslContextBuilderFunction;
        return this;
    }

    @Generated
    public Configuration nettySslContextFactoryCustomizer(Consumer<NettySslContextFactory> nettySslContextFactoryCustomizer) {
        this.nettySslContextFactoryCustomizer = nettySslContextFactoryCustomizer;
        return this;
    }

    @Generated
    public Configuration sslServerContextBuilderCustomizer(UnaryOperator<SslContextBuilder> sslServerContextBuilderCustomizer) {
        this.sslServerContextBuilderCustomizer = sslServerContextBuilderCustomizer;
        return this;
    }

    @Generated
    public Configuration sslClientContextBuilderCustomizer(UnaryOperator<SslContextBuilder> sslClientContextBuilderCustomizer) {
        this.sslClientContextBuilderCustomizer = sslClientContextBuilderCustomizer;
        return this;
    }

    @Generated
    public Configuration ocspResponseSupplier(Function<X509Certificate, byte[]> ocspResponseSupplier) {
        this.ocspResponseSupplier = ocspResponseSupplier;
        return this;
    }

    @Generated
    public Configuration preventCertificateDynamicUpdate(boolean preventCertificateDynamicUpdate) {
        this.preventCertificateDynamicUpdate = preventCertificateDynamicUpdate;
        return this;
    }

    @Generated
    public Configuration sslCertificateDomainName(String sslCertificateDomainName) {
        this.sslCertificateDomainName = sslCertificateDomainName;
        return this;
    }

    @Generated
    public Configuration sslSubjectAlternativeNameDomains(Set<String> sslSubjectAlternativeNameDomains) {
        this.sslSubjectAlternativeNameDomains = sslSubjectAlternativeNameDomains;
        return this;
    }

    @Generated
    public Configuration sslSubjectAlternativeNameIps(Set<String> sslSubjectAlternativeNameIps) {
        this.sslSubjectAlternativeNameIps = sslSubjectAlternativeNameIps;
        return this;
    }

    @Generated
    public Configuration certificateAuthorityPrivateKey(String certificateAuthorityPrivateKey) {
        this.certificateAuthorityPrivateKey = certificateAuthorityPrivateKey;
        return this;
    }

    @Generated
    public Configuration certificateAuthorityCertificate(String certificateAuthorityCertificate) {
        this.certificateAuthorityCertificate = certificateAuthorityCertificate;
        return this;
    }

    @Generated
    public Configuration tlsMutualAuthenticationRequired(Boolean tlsMutualAuthenticationRequired) {
        this.tlsMutualAuthenticationRequired = tlsMutualAuthenticationRequired;
        return this;
    }

    @Generated
    public Configuration tlsMutualAuthenticationCertificateChain(String tlsMutualAuthenticationCertificateChain) {
        this.tlsMutualAuthenticationCertificateChain = tlsMutualAuthenticationCertificateChain;
        return this;
    }

    @Generated
    public Configuration forwardProxyTLSX509CertificatesTrustManagerType(ForwardProxyTLSX509CertificatesTrustManager forwardProxyTLSX509CertificatesTrustManagerType) {
        this.forwardProxyTLSX509CertificatesTrustManagerType = forwardProxyTLSX509CertificatesTrustManagerType;
        return this;
    }

    @Generated
    public Configuration forwardProxyTLSCustomTrustX509Certificates(String forwardProxyTLSCustomTrustX509Certificates) {
        this.forwardProxyTLSCustomTrustX509Certificates = forwardProxyTLSCustomTrustX509Certificates;
        return this;
    }

    @Generated
    public Configuration forwardProxyPrivateKey(String forwardProxyPrivateKey) {
        this.forwardProxyPrivateKey = forwardProxyPrivateKey;
        return this;
    }

    @Generated
    public Configuration forwardProxyCertificateChain(String forwardProxyCertificateChain) {
        this.forwardProxyCertificateChain = forwardProxyCertificateChain;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.matchersFailFast() != other.matchersFailFast()) {
            return false;
        }
        if (this.alwaysCloseSocketConnections() != other.alwaysCloseSocketConnections()) {
            return false;
        }
        if (this.useSemicolonAsQueryParameterSeparator() != other.useSemicolonAsQueryParameterSeparator()) {
            return false;
        }
        if (this.assumeAllRequestsAreHttp() != other.assumeAllRequestsAreHttp()) {
            return false;
        }
        if (this.enableCORSForAPI() != other.enableCORSForAPI()) {
            return false;
        }
        if (this.enableCORSForAllResponses() != other.enableCORSForAllResponses()) {
            return false;
        }
        if (this.corsAllowCredentials() != other.corsAllowCredentials()) {
            return false;
        }
        if (this.attemptToProxyIfNoMatchingExpectation() != other.attemptToProxyIfNoMatchingExpectation()) {
            return false;
        }
        if (this.proactivelyInitialiseTLS() != other.proactivelyInitialiseTLS()) {
            return false;
        }
        if (this.rebuildTLSContext() != other.rebuildTLSContext()) {
            return false;
        }
        if (this.rebuildServerTlsContext() != other.rebuildServerTlsContext()) {
            return false;
        }
        if (this.preventCertificateDynamicUpdate() != other.preventCertificateDynamicUpdate()) {
            return false;
        }
        Boolean this$disableSystemOut = this.disableSystemOut();
        Boolean other$disableSystemOut = other.disableSystemOut();
        if (this$disableSystemOut == null ? other$disableSystemOut != null : !((Object)this$disableSystemOut).equals(other$disableSystemOut)) {
            return false;
        }
        Boolean this$disableLogging = this.disableLogging();
        Boolean other$disableLogging = other.disableLogging();
        if (this$disableLogging == null ? other$disableLogging != null : !((Object)this$disableLogging).equals(other$disableLogging)) {
            return false;
        }
        Boolean this$detailedMatchFailures = this.detailedMatchFailures();
        Boolean other$detailedMatchFailures = other.detailedMatchFailures();
        if (this$detailedMatchFailures == null ? other$detailedMatchFailures != null : !((Object)this$detailedMatchFailures).equals(other$detailedMatchFailures)) {
            return false;
        }
        Boolean this$launchUIForLogLevelDebug = this.launchUIForLogLevelDebug();
        Boolean other$launchUIForLogLevelDebug = other.launchUIForLogLevelDebug();
        if (this$launchUIForLogLevelDebug == null ? other$launchUIForLogLevelDebug != null : !((Object)this$launchUIForLogLevelDebug).equals(other$launchUIForLogLevelDebug)) {
            return false;
        }
        Boolean this$metricsEnabled = this.metricsEnabled();
        Boolean other$metricsEnabled = other.metricsEnabled();
        if (this$metricsEnabled == null ? other$metricsEnabled != null : !((Object)this$metricsEnabled).equals(other$metricsEnabled)) {
            return false;
        }
        Integer this$nioEventLoopThreadCount = this.nioEventLoopThreadCount();
        Integer other$nioEventLoopThreadCount = other.nioEventLoopThreadCount();
        if (this$nioEventLoopThreadCount == null ? other$nioEventLoopThreadCount != null : !((Object)this$nioEventLoopThreadCount).equals(other$nioEventLoopThreadCount)) {
            return false;
        }
        Integer this$actionHandlerThreadCount = this.actionHandlerThreadCount();
        Integer other$actionHandlerThreadCount = other.actionHandlerThreadCount();
        if (this$actionHandlerThreadCount == null ? other$actionHandlerThreadCount != null : !((Object)this$actionHandlerThreadCount).equals(other$actionHandlerThreadCount)) {
            return false;
        }
        Integer this$clientNioEventLoopThreadCount = this.clientNioEventLoopThreadCount();
        Integer other$clientNioEventLoopThreadCount = other.clientNioEventLoopThreadCount();
        if (this$clientNioEventLoopThreadCount == null ? other$clientNioEventLoopThreadCount != null : !((Object)this$clientNioEventLoopThreadCount).equals(other$clientNioEventLoopThreadCount)) {
            return false;
        }
        Integer this$webSocketClientEventLoopThreadCount = this.webSocketClientEventLoopThreadCount();
        Integer other$webSocketClientEventLoopThreadCount = other.webSocketClientEventLoopThreadCount();
        if (this$webSocketClientEventLoopThreadCount == null ? other$webSocketClientEventLoopThreadCount != null : !((Object)this$webSocketClientEventLoopThreadCount).equals(other$webSocketClientEventLoopThreadCount)) {
            return false;
        }
        Long this$maxFutureTimeoutInMillis = this.maxFutureTimeoutInMillis();
        Long other$maxFutureTimeoutInMillis = other.maxFutureTimeoutInMillis();
        if (this$maxFutureTimeoutInMillis == null ? other$maxFutureTimeoutInMillis != null : !((Object)this$maxFutureTimeoutInMillis).equals(other$maxFutureTimeoutInMillis)) {
            return false;
        }
        Long this$maxSocketTimeoutInMillis = this.maxSocketTimeoutInMillis();
        Long other$maxSocketTimeoutInMillis = other.maxSocketTimeoutInMillis();
        if (this$maxSocketTimeoutInMillis == null ? other$maxSocketTimeoutInMillis != null : !((Object)this$maxSocketTimeoutInMillis).equals(other$maxSocketTimeoutInMillis)) {
            return false;
        }
        Long this$socketConnectionTimeoutInMillis = this.socketConnectionTimeoutInMillis();
        Long other$socketConnectionTimeoutInMillis = other.socketConnectionTimeoutInMillis();
        if (this$socketConnectionTimeoutInMillis == null ? other$socketConnectionTimeoutInMillis != null : !((Object)this$socketConnectionTimeoutInMillis).equals(other$socketConnectionTimeoutInMillis)) {
            return false;
        }
        Integer this$maxInitialLineLength = this.maxInitialLineLength();
        Integer other$maxInitialLineLength = other.maxInitialLineLength();
        if (this$maxInitialLineLength == null ? other$maxInitialLineLength != null : !((Object)this$maxInitialLineLength).equals(other$maxInitialLineLength)) {
            return false;
        }
        Integer this$maxHeaderSize = this.maxHeaderSize();
        Integer other$maxHeaderSize = other.maxHeaderSize();
        if (this$maxHeaderSize == null ? other$maxHeaderSize != null : !((Object)this$maxHeaderSize).equals(other$maxHeaderSize)) {
            return false;
        }
        Integer this$maxChunkSize = this.maxChunkSize();
        Integer other$maxChunkSize = other.maxChunkSize();
        if (this$maxChunkSize == null ? other$maxChunkSize != null : !((Object)this$maxChunkSize).equals(other$maxChunkSize)) {
            return false;
        }
        Integer this$corsMaxAgeInSeconds = this.corsMaxAgeInSeconds();
        Integer other$corsMaxAgeInSeconds = other.corsMaxAgeInSeconds();
        if (this$corsMaxAgeInSeconds == null ? other$corsMaxAgeInSeconds != null : !((Object)this$corsMaxAgeInSeconds).equals(other$corsMaxAgeInSeconds)) {
            return false;
        }
        Boolean this$tlsMutualAuthenticationRequired = this.tlsMutualAuthenticationRequired();
        Boolean other$tlsMutualAuthenticationRequired = other.tlsMutualAuthenticationRequired();
        if (this$tlsMutualAuthenticationRequired == null ? other$tlsMutualAuthenticationRequired != null : !((Object)this$tlsMutualAuthenticationRequired).equals(other$tlsMutualAuthenticationRequired)) {
            return false;
        }
        Level this$logLevel = this.logLevel();
        Level other$logLevel = other.logLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        String this$mockServerName = this.mockServerName();
        String other$mockServerName = other.mockServerName();
        if (this$mockServerName == null ? other$mockServerName != null : !this$mockServerName.equals(other$mockServerName)) {
            return false;
        }
        String this$localBoundIP = this.localBoundIP();
        String other$localBoundIP = other.localBoundIP();
        if (this$localBoundIP == null ? other$localBoundIP != null : !this$localBoundIP.equals(other$localBoundIP)) {
            return false;
        }
        BinaryProxyListener this$binaryProxyListener = this.binaryProxyListener();
        BinaryProxyListener other$binaryProxyListener = other.binaryProxyListener();
        if (this$binaryProxyListener == null ? other$binaryProxyListener != null : !this$binaryProxyListener.equals(other$binaryProxyListener)) {
            return false;
        }
        String this$corsAllowOrigin = this.corsAllowOrigin();
        String other$corsAllowOrigin = other.corsAllowOrigin();
        if (this$corsAllowOrigin == null ? other$corsAllowOrigin != null : !this$corsAllowOrigin.equals(other$corsAllowOrigin)) {
            return false;
        }
        String this$corsAllowMethods = this.corsAllowMethods();
        String other$corsAllowMethods = other.corsAllowMethods();
        if (this$corsAllowMethods == null ? other$corsAllowMethods != null : !this$corsAllowMethods.equals(other$corsAllowMethods)) {
            return false;
        }
        String this$corsAllowHeaders = this.corsAllowHeaders();
        String other$corsAllowHeaders = other.corsAllowHeaders();
        if (this$corsAllowHeaders == null ? other$corsAllowHeaders != null : !this$corsAllowHeaders.equals(other$corsAllowHeaders)) {
            return false;
        }
        InetSocketAddress this$forwardHttpProxy = this.forwardHttpProxy();
        InetSocketAddress other$forwardHttpProxy = other.forwardHttpProxy();
        if (this$forwardHttpProxy == null ? other$forwardHttpProxy != null : !((Object)this$forwardHttpProxy).equals(other$forwardHttpProxy)) {
            return false;
        }
        InetSocketAddress this$forwardHttpsProxy = this.forwardHttpsProxy();
        InetSocketAddress other$forwardHttpsProxy = other.forwardHttpsProxy();
        if (this$forwardHttpsProxy == null ? other$forwardHttpsProxy != null : !((Object)this$forwardHttpsProxy).equals(other$forwardHttpsProxy)) {
            return false;
        }
        InetSocketAddress this$forwardSocksProxy = this.forwardSocksProxy();
        InetSocketAddress other$forwardSocksProxy = other.forwardSocksProxy();
        if (this$forwardSocksProxy == null ? other$forwardSocksProxy != null : !((Object)this$forwardSocksProxy).equals(other$forwardSocksProxy)) {
            return false;
        }
        String this$forwardProxyAuthenticationUsername = this.forwardProxyAuthenticationUsername();
        String other$forwardProxyAuthenticationUsername = other.forwardProxyAuthenticationUsername();
        if (this$forwardProxyAuthenticationUsername == null ? other$forwardProxyAuthenticationUsername != null : !this$forwardProxyAuthenticationUsername.equals(other$forwardProxyAuthenticationUsername)) {
            return false;
        }
        String this$forwardProxyAuthenticationPassword = this.forwardProxyAuthenticationPassword();
        String other$forwardProxyAuthenticationPassword = other.forwardProxyAuthenticationPassword();
        if (this$forwardProxyAuthenticationPassword == null ? other$forwardProxyAuthenticationPassword != null : !this$forwardProxyAuthenticationPassword.equals(other$forwardProxyAuthenticationPassword)) {
            return false;
        }
        String this$proxyAuthenticationRealm = this.proxyAuthenticationRealm();
        String other$proxyAuthenticationRealm = other.proxyAuthenticationRealm();
        if (this$proxyAuthenticationRealm == null ? other$proxyAuthenticationRealm != null : !this$proxyAuthenticationRealm.equals(other$proxyAuthenticationRealm)) {
            return false;
        }
        String this$proxyAuthenticationUsername = this.proxyAuthenticationUsername();
        String other$proxyAuthenticationUsername = other.proxyAuthenticationUsername();
        if (this$proxyAuthenticationUsername == null ? other$proxyAuthenticationUsername != null : !this$proxyAuthenticationUsername.equals(other$proxyAuthenticationUsername)) {
            return false;
        }
        String this$proxyAuthenticationPassword = this.proxyAuthenticationPassword();
        String other$proxyAuthenticationPassword = other.proxyAuthenticationPassword();
        if (this$proxyAuthenticationPassword == null ? other$proxyAuthenticationPassword != null : !this$proxyAuthenticationPassword.equals(other$proxyAuthenticationPassword)) {
            return false;
        }
        String this$noProxyHosts = this.noProxyHosts();
        String other$noProxyHosts = other.noProxyHosts();
        if (this$noProxyHosts == null ? other$noProxyHosts != null : !this$noProxyHosts.equals(other$noProxyHosts)) {
            return false;
        }
        String this$livenessHttpGetPath = this.livenessHttpGetPath();
        String other$livenessHttpGetPath = other.livenessHttpGetPath();
        if (this$livenessHttpGetPath == null ? other$livenessHttpGetPath != null : !this$livenessHttpGetPath.equals(other$livenessHttpGetPath)) {
            return false;
        }
        String this$tlsProtocols = this.tlsProtocols();
        String other$tlsProtocols = other.tlsProtocols();
        if (this$tlsProtocols == null ? other$tlsProtocols != null : !this$tlsProtocols.equals(other$tlsProtocols)) {
            return false;
        }
        KeyAndCertificateFactorySupplier this$customKeyAndCertificateFactorySupplier = this.customKeyAndCertificateFactorySupplier();
        KeyAndCertificateFactorySupplier other$customKeyAndCertificateFactorySupplier = other.customKeyAndCertificateFactorySupplier();
        if (this$customKeyAndCertificateFactorySupplier == null ? other$customKeyAndCertificateFactorySupplier != null : !this$customKeyAndCertificateFactorySupplier.equals(other$customKeyAndCertificateFactorySupplier)) {
            return false;
        }
        Function<SslContextBuilder, SslContext> this$clientSslContextBuilderFunction = this.clientSslContextBuilderFunction();
        Function<SslContextBuilder, SslContext> other$clientSslContextBuilderFunction = other.clientSslContextBuilderFunction();
        if (this$clientSslContextBuilderFunction == null ? other$clientSslContextBuilderFunction != null : !this$clientSslContextBuilderFunction.equals(other$clientSslContextBuilderFunction)) {
            return false;
        }
        Consumer<NettySslContextFactory> this$nettySslContextFactoryCustomizer = this.nettySslContextFactoryCustomizer();
        Consumer<NettySslContextFactory> other$nettySslContextFactoryCustomizer = other.nettySslContextFactoryCustomizer();
        if (this$nettySslContextFactoryCustomizer == null ? other$nettySslContextFactoryCustomizer != null : !this$nettySslContextFactoryCustomizer.equals(other$nettySslContextFactoryCustomizer)) {
            return false;
        }
        UnaryOperator<SslContextBuilder> this$sslServerContextBuilderCustomizer = this.sslServerContextBuilderCustomizer();
        UnaryOperator<SslContextBuilder> other$sslServerContextBuilderCustomizer = other.sslServerContextBuilderCustomizer();
        if (this$sslServerContextBuilderCustomizer == null ? other$sslServerContextBuilderCustomizer != null : !this$sslServerContextBuilderCustomizer.equals(other$sslServerContextBuilderCustomizer)) {
            return false;
        }
        UnaryOperator<SslContextBuilder> this$sslClientContextBuilderCustomizer = this.sslClientContextBuilderCustomizer();
        UnaryOperator<SslContextBuilder> other$sslClientContextBuilderCustomizer = other.sslClientContextBuilderCustomizer();
        if (this$sslClientContextBuilderCustomizer == null ? other$sslClientContextBuilderCustomizer != null : !this$sslClientContextBuilderCustomizer.equals(other$sslClientContextBuilderCustomizer)) {
            return false;
        }
        Function<X509Certificate, byte[]> this$ocspResponseSupplier = this.ocspResponseSupplier();
        Function<X509Certificate, byte[]> other$ocspResponseSupplier = other.ocspResponseSupplier();
        if (this$ocspResponseSupplier == null ? other$ocspResponseSupplier != null : !this$ocspResponseSupplier.equals(other$ocspResponseSupplier)) {
            return false;
        }
        String this$sslCertificateDomainName = this.sslCertificateDomainName();
        String other$sslCertificateDomainName = other.sslCertificateDomainName();
        if (this$sslCertificateDomainName == null ? other$sslCertificateDomainName != null : !this$sslCertificateDomainName.equals(other$sslCertificateDomainName)) {
            return false;
        }
        Set<String> this$sslSubjectAlternativeNameDomains = this.sslSubjectAlternativeNameDomains();
        Set<String> other$sslSubjectAlternativeNameDomains = other.sslSubjectAlternativeNameDomains();
        if (this$sslSubjectAlternativeNameDomains == null ? other$sslSubjectAlternativeNameDomains != null : !((Object)this$sslSubjectAlternativeNameDomains).equals(other$sslSubjectAlternativeNameDomains)) {
            return false;
        }
        Set<String> this$sslSubjectAlternativeNameIps = this.sslSubjectAlternativeNameIps();
        Set<String> other$sslSubjectAlternativeNameIps = other.sslSubjectAlternativeNameIps();
        if (this$sslSubjectAlternativeNameIps == null ? other$sslSubjectAlternativeNameIps != null : !((Object)this$sslSubjectAlternativeNameIps).equals(other$sslSubjectAlternativeNameIps)) {
            return false;
        }
        String this$certificateAuthorityPrivateKey = this.certificateAuthorityPrivateKey();
        String other$certificateAuthorityPrivateKey = other.certificateAuthorityPrivateKey();
        if (this$certificateAuthorityPrivateKey == null ? other$certificateAuthorityPrivateKey != null : !this$certificateAuthorityPrivateKey.equals(other$certificateAuthorityPrivateKey)) {
            return false;
        }
        String this$certificateAuthorityCertificate = this.certificateAuthorityCertificate();
        String other$certificateAuthorityCertificate = other.certificateAuthorityCertificate();
        if (this$certificateAuthorityCertificate == null ? other$certificateAuthorityCertificate != null : !this$certificateAuthorityCertificate.equals(other$certificateAuthorityCertificate)) {
            return false;
        }
        String this$tlsMutualAuthenticationCertificateChain = this.tlsMutualAuthenticationCertificateChain();
        String other$tlsMutualAuthenticationCertificateChain = other.tlsMutualAuthenticationCertificateChain();
        if (this$tlsMutualAuthenticationCertificateChain == null ? other$tlsMutualAuthenticationCertificateChain != null : !this$tlsMutualAuthenticationCertificateChain.equals(other$tlsMutualAuthenticationCertificateChain)) {
            return false;
        }
        ForwardProxyTLSX509CertificatesTrustManager this$forwardProxyTLSX509CertificatesTrustManagerType = this.forwardProxyTLSX509CertificatesTrustManagerType();
        ForwardProxyTLSX509CertificatesTrustManager other$forwardProxyTLSX509CertificatesTrustManagerType = other.forwardProxyTLSX509CertificatesTrustManagerType();
        if (this$forwardProxyTLSX509CertificatesTrustManagerType == null ? other$forwardProxyTLSX509CertificatesTrustManagerType != null : !((Object)((Object)this$forwardProxyTLSX509CertificatesTrustManagerType)).equals((Object)other$forwardProxyTLSX509CertificatesTrustManagerType)) {
            return false;
        }
        String this$forwardProxyTLSCustomTrustX509Certificates = this.forwardProxyTLSCustomTrustX509Certificates();
        String other$forwardProxyTLSCustomTrustX509Certificates = other.forwardProxyTLSCustomTrustX509Certificates();
        if (this$forwardProxyTLSCustomTrustX509Certificates == null ? other$forwardProxyTLSCustomTrustX509Certificates != null : !this$forwardProxyTLSCustomTrustX509Certificates.equals(other$forwardProxyTLSCustomTrustX509Certificates)) {
            return false;
        }
        String this$forwardProxyPrivateKey = this.forwardProxyPrivateKey();
        String other$forwardProxyPrivateKey = other.forwardProxyPrivateKey();
        if (this$forwardProxyPrivateKey == null ? other$forwardProxyPrivateKey != null : !this$forwardProxyPrivateKey.equals(other$forwardProxyPrivateKey)) {
            return false;
        }
        String this$forwardProxyCertificateChain = this.forwardProxyCertificateChain();
        String other$forwardProxyCertificateChain = other.forwardProxyCertificateChain();
        return !(this$forwardProxyCertificateChain == null ? other$forwardProxyCertificateChain != null : !this$forwardProxyCertificateChain.equals(other$forwardProxyCertificateChain));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.matchersFailFast() ? 79 : 97);
        result = result * 59 + (this.alwaysCloseSocketConnections() ? 79 : 97);
        result = result * 59 + (this.useSemicolonAsQueryParameterSeparator() ? 79 : 97);
        result = result * 59 + (this.assumeAllRequestsAreHttp() ? 79 : 97);
        result = result * 59 + (this.enableCORSForAPI() ? 79 : 97);
        result = result * 59 + (this.enableCORSForAllResponses() ? 79 : 97);
        result = result * 59 + (this.corsAllowCredentials() ? 79 : 97);
        result = result * 59 + (this.attemptToProxyIfNoMatchingExpectation() ? 79 : 97);
        result = result * 59 + (this.proactivelyInitialiseTLS() ? 79 : 97);
        result = result * 59 + (this.rebuildTLSContext() ? 79 : 97);
        result = result * 59 + (this.rebuildServerTlsContext() ? 79 : 97);
        result = result * 59 + (this.preventCertificateDynamicUpdate() ? 79 : 97);
        Boolean $disableSystemOut = this.disableSystemOut();
        result = result * 59 + ($disableSystemOut == null ? 43 : ((Object)$disableSystemOut).hashCode());
        Boolean $disableLogging = this.disableLogging();
        result = result * 59 + ($disableLogging == null ? 43 : ((Object)$disableLogging).hashCode());
        Boolean $detailedMatchFailures = this.detailedMatchFailures();
        result = result * 59 + ($detailedMatchFailures == null ? 43 : ((Object)$detailedMatchFailures).hashCode());
        Boolean $launchUIForLogLevelDebug = this.launchUIForLogLevelDebug();
        result = result * 59 + ($launchUIForLogLevelDebug == null ? 43 : ((Object)$launchUIForLogLevelDebug).hashCode());
        Boolean $metricsEnabled = this.metricsEnabled();
        result = result * 59 + ($metricsEnabled == null ? 43 : ((Object)$metricsEnabled).hashCode());
        Integer $nioEventLoopThreadCount = this.nioEventLoopThreadCount();
        result = result * 59 + ($nioEventLoopThreadCount == null ? 43 : ((Object)$nioEventLoopThreadCount).hashCode());
        Integer $actionHandlerThreadCount = this.actionHandlerThreadCount();
        result = result * 59 + ($actionHandlerThreadCount == null ? 43 : ((Object)$actionHandlerThreadCount).hashCode());
        Integer $clientNioEventLoopThreadCount = this.clientNioEventLoopThreadCount();
        result = result * 59 + ($clientNioEventLoopThreadCount == null ? 43 : ((Object)$clientNioEventLoopThreadCount).hashCode());
        Integer $webSocketClientEventLoopThreadCount = this.webSocketClientEventLoopThreadCount();
        result = result * 59 + ($webSocketClientEventLoopThreadCount == null ? 43 : ((Object)$webSocketClientEventLoopThreadCount).hashCode());
        Long $maxFutureTimeoutInMillis = this.maxFutureTimeoutInMillis();
        result = result * 59 + ($maxFutureTimeoutInMillis == null ? 43 : ((Object)$maxFutureTimeoutInMillis).hashCode());
        Long $maxSocketTimeoutInMillis = this.maxSocketTimeoutInMillis();
        result = result * 59 + ($maxSocketTimeoutInMillis == null ? 43 : ((Object)$maxSocketTimeoutInMillis).hashCode());
        Long $socketConnectionTimeoutInMillis = this.socketConnectionTimeoutInMillis();
        result = result * 59 + ($socketConnectionTimeoutInMillis == null ? 43 : ((Object)$socketConnectionTimeoutInMillis).hashCode());
        Integer $maxInitialLineLength = this.maxInitialLineLength();
        result = result * 59 + ($maxInitialLineLength == null ? 43 : ((Object)$maxInitialLineLength).hashCode());
        Integer $maxHeaderSize = this.maxHeaderSize();
        result = result * 59 + ($maxHeaderSize == null ? 43 : ((Object)$maxHeaderSize).hashCode());
        Integer $maxChunkSize = this.maxChunkSize();
        result = result * 59 + ($maxChunkSize == null ? 43 : ((Object)$maxChunkSize).hashCode());
        Integer $corsMaxAgeInSeconds = this.corsMaxAgeInSeconds();
        result = result * 59 + ($corsMaxAgeInSeconds == null ? 43 : ((Object)$corsMaxAgeInSeconds).hashCode());
        Boolean $tlsMutualAuthenticationRequired = this.tlsMutualAuthenticationRequired();
        result = result * 59 + ($tlsMutualAuthenticationRequired == null ? 43 : ((Object)$tlsMutualAuthenticationRequired).hashCode());
        Level $logLevel = this.logLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        String $mockServerName = this.mockServerName();
        result = result * 59 + ($mockServerName == null ? 43 : $mockServerName.hashCode());
        String $localBoundIP = this.localBoundIP();
        result = result * 59 + ($localBoundIP == null ? 43 : $localBoundIP.hashCode());
        BinaryProxyListener $binaryProxyListener = this.binaryProxyListener();
        result = result * 59 + ($binaryProxyListener == null ? 43 : $binaryProxyListener.hashCode());
        String $corsAllowOrigin = this.corsAllowOrigin();
        result = result * 59 + ($corsAllowOrigin == null ? 43 : $corsAllowOrigin.hashCode());
        String $corsAllowMethods = this.corsAllowMethods();
        result = result * 59 + ($corsAllowMethods == null ? 43 : $corsAllowMethods.hashCode());
        String $corsAllowHeaders = this.corsAllowHeaders();
        result = result * 59 + ($corsAllowHeaders == null ? 43 : $corsAllowHeaders.hashCode());
        InetSocketAddress $forwardHttpProxy = this.forwardHttpProxy();
        result = result * 59 + ($forwardHttpProxy == null ? 43 : ((Object)$forwardHttpProxy).hashCode());
        InetSocketAddress $forwardHttpsProxy = this.forwardHttpsProxy();
        result = result * 59 + ($forwardHttpsProxy == null ? 43 : ((Object)$forwardHttpsProxy).hashCode());
        InetSocketAddress $forwardSocksProxy = this.forwardSocksProxy();
        result = result * 59 + ($forwardSocksProxy == null ? 43 : ((Object)$forwardSocksProxy).hashCode());
        String $forwardProxyAuthenticationUsername = this.forwardProxyAuthenticationUsername();
        result = result * 59 + ($forwardProxyAuthenticationUsername == null ? 43 : $forwardProxyAuthenticationUsername.hashCode());
        String $forwardProxyAuthenticationPassword = this.forwardProxyAuthenticationPassword();
        result = result * 59 + ($forwardProxyAuthenticationPassword == null ? 43 : $forwardProxyAuthenticationPassword.hashCode());
        String $proxyAuthenticationRealm = this.proxyAuthenticationRealm();
        result = result * 59 + ($proxyAuthenticationRealm == null ? 43 : $proxyAuthenticationRealm.hashCode());
        String $proxyAuthenticationUsername = this.proxyAuthenticationUsername();
        result = result * 59 + ($proxyAuthenticationUsername == null ? 43 : $proxyAuthenticationUsername.hashCode());
        String $proxyAuthenticationPassword = this.proxyAuthenticationPassword();
        result = result * 59 + ($proxyAuthenticationPassword == null ? 43 : $proxyAuthenticationPassword.hashCode());
        String $noProxyHosts = this.noProxyHosts();
        result = result * 59 + ($noProxyHosts == null ? 43 : $noProxyHosts.hashCode());
        String $livenessHttpGetPath = this.livenessHttpGetPath();
        result = result * 59 + ($livenessHttpGetPath == null ? 43 : $livenessHttpGetPath.hashCode());
        String $tlsProtocols = this.tlsProtocols();
        result = result * 59 + ($tlsProtocols == null ? 43 : $tlsProtocols.hashCode());
        KeyAndCertificateFactorySupplier $customKeyAndCertificateFactorySupplier = this.customKeyAndCertificateFactorySupplier();
        result = result * 59 + ($customKeyAndCertificateFactorySupplier == null ? 43 : $customKeyAndCertificateFactorySupplier.hashCode());
        Function<SslContextBuilder, SslContext> $clientSslContextBuilderFunction = this.clientSslContextBuilderFunction();
        result = result * 59 + ($clientSslContextBuilderFunction == null ? 43 : $clientSslContextBuilderFunction.hashCode());
        Consumer<NettySslContextFactory> $nettySslContextFactoryCustomizer = this.nettySslContextFactoryCustomizer();
        result = result * 59 + ($nettySslContextFactoryCustomizer == null ? 43 : $nettySslContextFactoryCustomizer.hashCode());
        UnaryOperator<SslContextBuilder> $sslServerContextBuilderCustomizer = this.sslServerContextBuilderCustomizer();
        result = result * 59 + ($sslServerContextBuilderCustomizer == null ? 43 : $sslServerContextBuilderCustomizer.hashCode());
        UnaryOperator<SslContextBuilder> $sslClientContextBuilderCustomizer = this.sslClientContextBuilderCustomizer();
        result = result * 59 + ($sslClientContextBuilderCustomizer == null ? 43 : $sslClientContextBuilderCustomizer.hashCode());
        Function<X509Certificate, byte[]> $ocspResponseSupplier = this.ocspResponseSupplier();
        result = result * 59 + ($ocspResponseSupplier == null ? 43 : $ocspResponseSupplier.hashCode());
        String $sslCertificateDomainName = this.sslCertificateDomainName();
        result = result * 59 + ($sslCertificateDomainName == null ? 43 : $sslCertificateDomainName.hashCode());
        Set<String> $sslSubjectAlternativeNameDomains = this.sslSubjectAlternativeNameDomains();
        result = result * 59 + ($sslSubjectAlternativeNameDomains == null ? 43 : ((Object)$sslSubjectAlternativeNameDomains).hashCode());
        Set<String> $sslSubjectAlternativeNameIps = this.sslSubjectAlternativeNameIps();
        result = result * 59 + ($sslSubjectAlternativeNameIps == null ? 43 : ((Object)$sslSubjectAlternativeNameIps).hashCode());
        String $certificateAuthorityPrivateKey = this.certificateAuthorityPrivateKey();
        result = result * 59 + ($certificateAuthorityPrivateKey == null ? 43 : $certificateAuthorityPrivateKey.hashCode());
        String $certificateAuthorityCertificate = this.certificateAuthorityCertificate();
        result = result * 59 + ($certificateAuthorityCertificate == null ? 43 : $certificateAuthorityCertificate.hashCode());
        String $tlsMutualAuthenticationCertificateChain = this.tlsMutualAuthenticationCertificateChain();
        result = result * 59 + ($tlsMutualAuthenticationCertificateChain == null ? 43 : $tlsMutualAuthenticationCertificateChain.hashCode());
        ForwardProxyTLSX509CertificatesTrustManager $forwardProxyTLSX509CertificatesTrustManagerType = this.forwardProxyTLSX509CertificatesTrustManagerType();
        result = result * 59 + ($forwardProxyTLSX509CertificatesTrustManagerType == null ? 43 : ((Object)((Object)$forwardProxyTLSX509CertificatesTrustManagerType)).hashCode());
        String $forwardProxyTLSCustomTrustX509Certificates = this.forwardProxyTLSCustomTrustX509Certificates();
        result = result * 59 + ($forwardProxyTLSCustomTrustX509Certificates == null ? 43 : $forwardProxyTLSCustomTrustX509Certificates.hashCode());
        String $forwardProxyPrivateKey = this.forwardProxyPrivateKey();
        result = result * 59 + ($forwardProxyPrivateKey == null ? 43 : $forwardProxyPrivateKey.hashCode());
        String $forwardProxyCertificateChain = this.forwardProxyCertificateChain();
        result = result * 59 + ($forwardProxyCertificateChain == null ? 43 : $forwardProxyCertificateChain.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Configuration(logLevel=" + this.logLevel() + ", disableSystemOut=" + this.disableSystemOut() + ", disableLogging=" + this.disableLogging() + ", detailedMatchFailures=" + this.detailedMatchFailures() + ", launchUIForLogLevelDebug=" + this.launchUIForLogLevelDebug() + ", metricsEnabled=" + this.metricsEnabled() + ", mockServerName=" + this.mockServerName() + ", nioEventLoopThreadCount=" + this.nioEventLoopThreadCount() + ", actionHandlerThreadCount=" + this.actionHandlerThreadCount() + ", clientNioEventLoopThreadCount=" + this.clientNioEventLoopThreadCount() + ", webSocketClientEventLoopThreadCount=" + this.webSocketClientEventLoopThreadCount() + ", maxFutureTimeoutInMillis=" + this.maxFutureTimeoutInMillis() + ", matchersFailFast=" + this.matchersFailFast() + ", maxSocketTimeoutInMillis=" + this.maxSocketTimeoutInMillis() + ", socketConnectionTimeoutInMillis=" + this.socketConnectionTimeoutInMillis() + ", alwaysCloseSocketConnections=" + this.alwaysCloseSocketConnections() + ", localBoundIP=" + this.localBoundIP() + ", maxInitialLineLength=" + this.maxInitialLineLength() + ", maxHeaderSize=" + this.maxHeaderSize() + ", maxChunkSize=" + this.maxChunkSize() + ", useSemicolonAsQueryParameterSeparator=" + this.useSemicolonAsQueryParameterSeparator() + ", assumeAllRequestsAreHttp=" + this.assumeAllRequestsAreHttp() + ", binaryProxyListener=" + this.binaryProxyListener() + ", enableCORSForAPI=" + this.enableCORSForAPI() + ", enableCORSForAllResponses=" + this.enableCORSForAllResponses() + ", corsAllowOrigin=" + this.corsAllowOrigin() + ", corsAllowMethods=" + this.corsAllowMethods() + ", corsAllowHeaders=" + this.corsAllowHeaders() + ", corsAllowCredentials=" + this.corsAllowCredentials() + ", corsMaxAgeInSeconds=" + this.corsMaxAgeInSeconds() + ", attemptToProxyIfNoMatchingExpectation=" + this.attemptToProxyIfNoMatchingExpectation() + ", forwardHttpProxy=" + this.forwardHttpProxy() + ", forwardHttpsProxy=" + this.forwardHttpsProxy() + ", forwardSocksProxy=" + this.forwardSocksProxy() + ", forwardProxyAuthenticationUsername=" + this.forwardProxyAuthenticationUsername() + ", forwardProxyAuthenticationPassword=" + this.forwardProxyAuthenticationPassword() + ", proxyAuthenticationRealm=" + this.proxyAuthenticationRealm() + ", proxyAuthenticationUsername=" + this.proxyAuthenticationUsername() + ", proxyAuthenticationPassword=" + this.proxyAuthenticationPassword() + ", noProxyHosts=" + this.noProxyHosts() + ", livenessHttpGetPath=" + this.livenessHttpGetPath() + ", proactivelyInitialiseTLS=" + this.proactivelyInitialiseTLS() + ", rebuildTLSContext=" + this.rebuildTLSContext() + ", rebuildServerTlsContext=" + this.rebuildServerTlsContext() + ", tlsProtocols=" + this.tlsProtocols() + ", customKeyAndCertificateFactorySupplier=" + this.customKeyAndCertificateFactorySupplier() + ", clientSslContextBuilderFunction=" + this.clientSslContextBuilderFunction() + ", nettySslContextFactoryCustomizer=" + this.nettySslContextFactoryCustomizer() + ", sslServerContextBuilderCustomizer=" + this.sslServerContextBuilderCustomizer() + ", sslClientContextBuilderCustomizer=" + this.sslClientContextBuilderCustomizer() + ", ocspResponseSupplier=" + this.ocspResponseSupplier() + ", preventCertificateDynamicUpdate=" + this.preventCertificateDynamicUpdate() + ", sslCertificateDomainName=" + this.sslCertificateDomainName() + ", sslSubjectAlternativeNameDomains=" + this.sslSubjectAlternativeNameDomains() + ", sslSubjectAlternativeNameIps=" + this.sslSubjectAlternativeNameIps() + ", certificateAuthorityPrivateKey=" + this.certificateAuthorityPrivateKey() + ", certificateAuthorityCertificate=" + this.certificateAuthorityCertificate() + ", tlsMutualAuthenticationRequired=" + this.tlsMutualAuthenticationRequired() + ", tlsMutualAuthenticationCertificateChain=" + this.tlsMutualAuthenticationCertificateChain() + ", forwardProxyTLSX509CertificatesTrustManagerType=" + this.forwardProxyTLSX509CertificatesTrustManagerType() + ", forwardProxyTLSCustomTrustX509Certificates=" + this.forwardProxyTLSCustomTrustX509Certificates() + ", forwardProxyPrivateKey=" + this.forwardProxyPrivateKey() + ", forwardProxyCertificateChain=" + this.forwardProxyCertificateChain() + ")";
    }
}

