/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.codec;

import de.gematik.test.tiger.mockserver.codec.PreserveHeadersNettyRemoves;
import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.mappers.FullHttpRequestToMockServerHttpRequest;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.socket.tls.SniHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpRequest;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.SSLSession;

public class NettyHttpToMockServerHttpRequestDecoder
extends MessageToMessageDecoder<FullHttpRequest> {
    private final FullHttpRequestToMockServerHttpRequest fullHttpRequestToMockServerRequest;

    public NettyHttpToMockServerHttpRequestDecoder(Configuration configuration, boolean isSecure, Certificate[] clientCertificates, Integer port) {
        this.fullHttpRequestToMockServerRequest = new FullHttpRequestToMockServerHttpRequest(configuration, isSecure, clientCertificates, port);
    }

    protected void decode(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest, List<Object> out) {
        List<Header> preservedHeaders = null;
        SocketAddress localAddress = null;
        SocketAddress remoteAddress = null;
        SSLSession sslSession = null;
        if (ctx != null && ctx.channel() != null) {
            preservedHeaders = PreserveHeadersNettyRemoves.preservedHeaders(ctx.channel());
            localAddress = ctx.channel().localAddress();
            remoteAddress = ctx.channel().remoteAddress();
            sslSession = (SSLSession)ctx.channel().attr(SniHandler.SSL_SESSION).get();
        }
        out.add(this.fullHttpRequestToMockServerRequest.mapFullHttpRequestToMockServerRequest(fullHttpRequest, preservedHeaders, localAddress, remoteAddress, SniHandler.getALPNProtocol(ctx), sslSession));
    }
}

