/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.codec;

import de.gematik.test.tiger.mockserver.model.BinaryBody;
import de.gematik.test.tiger.mockserver.model.Body;
import de.gematik.test.tiger.mockserver.model.BodyWithContentType;
import de.gematik.test.tiger.mockserver.model.MediaType;
import de.gematik.test.tiger.mockserver.model.StringBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;

public class BodyDecoderEncoder {
    public ByteBuf bodyToByteBuf(Body body) {
        byte[] rawBytes;
        if (body != null && (rawBytes = body.getRawBytes()) != null) {
            return Unpooled.copiedBuffer((byte[])rawBytes);
        }
        return Unpooled.buffer((int)0, (int)0);
    }

    public ByteBuf[] bodyToByteBuf(Body body, String contentTypeHeader, int chunkSize) {
        byte[][] chunks = BodyDecoderEncoder.split(this.bodyToBytes(body, contentTypeHeader), chunkSize);
        ByteBuf[] byteBufs = new ByteBuf[chunks.length];
        for (int i = 0; i < chunks.length; ++i) {
            byteBufs[i] = chunks[i] != null ? Unpooled.copiedBuffer((byte[])chunks[i]) : Unpooled.buffer((int)0, (int)0);
        }
        return byteBufs;
    }

    public static byte[][] split(byte[] array, int chunkSize) {
        if (chunkSize < array.length) {
            int numOfChunks = (array.length + chunkSize - 1) / chunkSize;
            byte[][] output = new byte[numOfChunks][];
            for (int i = 0; i < numOfChunks; ++i) {
                int start = i * chunkSize;
                int length = Math.min(array.length - start, chunkSize);
                byte[] temp = new byte[length];
                System.arraycopy(array, start, temp, 0, length);
                output[i] = temp;
            }
            return output;
        }
        return new byte[][]{array};
    }

    byte[] bodyToBytes(Body body, String contentTypeHeader) {
        if (body != null) {
            if (body instanceof BinaryBody) {
                return body.getRawBytes();
            }
            if (body.getValue() instanceof String) {
                Charset contentTypeCharset = MediaType.parse(contentTypeHeader).getCharsetOrDefault();
                Charset bodyCharset = body.getCharset(contentTypeCharset);
                return ((String)body.getValue()).getBytes(bodyCharset != null ? bodyCharset : MediaType.DEFAULT_TEXT_HTTP_CHARACTER_SET);
            }
            return body.getRawBytes();
        }
        return null;
    }

    public BodyWithContentType byteBufToBody(ByteBuf content, String contentTypeHeader) {
        if (content != null && content.readableBytes() > 0) {
            byte[] bodyBytes = new byte[content.readableBytes()];
            content.readBytes(bodyBytes);
            return this.bytesToBody(bodyBytes, contentTypeHeader);
        }
        return null;
    }

    public BodyWithContentType bytesToBody(byte[] bodyBytes, String contentTypeHeader) {
        if (bodyBytes.length > 0) {
            MediaType mediaType = MediaType.parse(contentTypeHeader);
            if (mediaType.isString()) {
                return new StringBody(new String(bodyBytes, mediaType.getCharsetOrDefault()), bodyBytes, false, StringUtils.isNotBlank((CharSequence)contentTypeHeader) ? mediaType : null);
            }
            return new BinaryBody(bodyBytes, mediaType);
        }
        return null;
    }
}

