/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tracing;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.file.MessageTimeWriter;
import de.gematik.rbellogger.file.RbelFileWriter;
import de.gematik.rbellogger.file.TcpIpMessageFacetWriter;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.client.TigerExceptionDto;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessagePart;
import de.gematik.test.tiger.proxy.data.TigerNonPairedMessageFacet;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
public class TracingPushController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TracingPushController.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final int MAX_MESSAGE_SIZE = 524288;
    public final SimpMessagingTemplate template;
    public final TigerProxy tigerProxy;

    @PostConstruct
    public void addWebSocketListener() {
        this.tigerProxy.addRbelMessageListener(arg_0 -> this.propagateRbelMessageSafe(arg_0));
        this.tigerProxy.addNewExceptionConsumer(arg_0 -> this.propagateExceptionSafe(arg_0));
    }

    private void propagateExceptionSafe(Throwable exc) {
        try {
            this.propagateException(exc);
        }
        catch (RuntimeException e) {
            log.error("Error while propagating Exception", (Throwable)e);
            throw e;
        }
    }

    private void propagateRbelMessageSafe(RbelElement msg) {
        try {
            this.propagateRbelMessage(msg);
        }
        catch (RuntimeException e) {
            log.error("Error while propagating new Rbel-Message", (Throwable)e);
            throw e;
        }
    }

    private void propagateRbelMessage(RbelElement msg) {
        if (!msg.hasFacet(RbelTcpIpMessageFacet.class)) {
            log.trace("Skipping propagation, not a TCP/IP message {}", (Object)msg.getUuid());
            return;
        }
        if (msg.hasFacet(TigerNonPairedMessageFacet.class)) {
            this.sendNonPairedMessage(msg);
        } else if (msg.hasFacet(RbelHttpResponseFacet.class) || msg.getFacet(TracingMessagePairFacet.class).map(facet -> facet.isResponse(msg)).orElse(false).booleanValue()) {
            this.sendPairedMessage(msg);
        } else {
            log.trace("Skipping propagation, not a response (facets: {}, uuid: {})", (Object)msg.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ")), (Object)msg.getUuid());
        }
    }

    private void sendNonPairedMessage(RbelElement msg) {
        try {
            RbelTcpIpMessageFacet rbelTcpIpMessageFacet = (RbelTcpIpMessageFacet)msg.getFacetOrFail(RbelTcpIpMessageFacet.class);
            RbelHostname sender = RbelHostname.fromString((String)rbelTcpIpMessageFacet.getSender().getRawStringContent()).orElse(null);
            RbelHostname receiver = RbelHostname.fromString((String)rbelTcpIpMessageFacet.getReceiver().getRawStringContent()).orElse(null);
            log.trace("{}Propagating new non-paired message (ID: {})", (Object)this.tigerProxy.proxyName(), (Object)msg.getUuid());
            this.template.convertAndSend((Object)"/topic/traces", (Object)TigerTracingDto.builder().receiver(receiver).sender(sender).requestUuid(msg.getUuid()).requestTransmissionTime((ZonedDateTime)msg.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null)).additionalInformationRequest(this.gatherAdditionalInformation(msg)).build());
            this.mapRbelMessageAndSent(msg);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage());
            throw e;
        }
    }

    private void sendPairedMessage(RbelElement response) {
        RbelElement request = response.getFacet(TracingMessagePairFacet.class).map(TracingMessagePairFacet::getRequest).or(() -> response.getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::getRequest)).orElseThrow(() -> new TigerRemoteProxyClientException("Failure to correctly push message with id '" + response.getUuid() + "': Unable to find matching request"));
        RbelTcpIpMessageFacet rbelTcpIpMessageFacet = (RbelTcpIpMessageFacet)request.getFacetOrFail(RbelTcpIpMessageFacet.class);
        RbelHostname sender = RbelHostname.fromString((String)rbelTcpIpMessageFacet.getSender().getRawStringContent()).orElse(null);
        RbelHostname receiver = RbelHostname.fromString((String)rbelTcpIpMessageFacet.getReceiver().getRawStringContent()).orElse(null);
        log.trace("{}Propagating new request/response pair (IDs: {} and {})", new Object[]{this.tigerProxy.proxyName(), request.getUuid(), response.getUuid()});
        this.template.convertAndSend((Object)"/topic/traces", (Object)TigerTracingDto.builder().receiver(receiver).sender(sender).responseUuid(response.getUuid()).requestUuid(request.getUuid()).responseTransmissionTime((ZonedDateTime)response.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null)).requestTransmissionTime((ZonedDateTime)request.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null)).additionalInformationRequest(this.gatherAdditionalInformation(request)).additionalInformationResponse(this.gatherAdditionalInformation(response)).build());
        this.mapRbelMessageAndSent(request);
        this.mapRbelMessageAndSent(response);
    }

    private Map<String, String> gatherAdditionalInformation(RbelElement msg) {
        JSONObject infoObject = new JSONObject();
        RbelFileWriter.DEFAULT_PRE_SAVE_LISTENER.stream().filter(listener -> !(listener instanceof TcpIpMessageFacetWriter) && !(listener instanceof MessageTimeWriter)).forEach(listener -> listener.preSaveCallback(msg, infoObject));
        return infoObject.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
    }

    private void propagateException(Throwable exception) {
        this.template.convertAndSend((Object)"/topic/errors", (Object)TigerExceptionDto.builder().className(exception.getClass().getName()).message(exception.getMessage()).stacktrace(ExceptionUtils.getStackTrace((Throwable)exception)).build());
    }

    private void mapRbelMessageAndSent(RbelElement rbelMessage) {
        if (rbelMessage == null) {
            return;
        }
        int numberOfParts = rbelMessage.getRawContent().length / 524288 + 1;
        for (int i = 0; i < numberOfParts; ++i) {
            byte[] partContent = Arrays.copyOfRange(rbelMessage.getRawContent(), i * 524288, Math.min((i + 1) * 524288, rbelMessage.getRawContent().length));
            log.trace("{} sending part {} of {} for UUID {}...", new Object[]{this.tigerProxy.proxyName(), i + 1, numberOfParts, rbelMessage.getUuid()});
            this.template.convertAndSend((Object)"/topic/data", (Object)TracingMessagePart.builder().data(partContent).index(i).uuid(rbelMessage.getUuid()).numberOfMessages(numberOfParts).build());
        }
    }

    @ConstructorProperties(value={"template", "tigerProxy"})
    @Generated
    public TracingPushController(SimpMessagingTemplate template, TigerProxy tigerProxy) {
        this.template = template;
        this.tigerProxy = tigerProxy;
    }
}

