/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tls;

import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyStartupException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Random;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class TlsCertificateGenerator {
    public static TigerPkiIdentity generateNewCaCertificate() {
        try {
            return TlsCertificateGenerator.generateNewCaCertificateUnsafe();
        }
        catch (IOException | GeneralSecurityException | OperatorCreationException e) {
            throw new TigerProxyStartupException("Error while generating CA certificate", (Exception)e);
        }
    }

    private static TigerPkiIdentity generateNewCaCertificateUnsafe() throws GeneralSecurityException, IOException, OperatorCreationException {
        KeyPair keyPair = TlsCertificateGenerator.generateRsaKeyPair((int)2048);
        X500Name subject = new X500Name("CN=Tiger-Proxy, O=Gematik, L=Berlin, ST=Berlin, C=DE");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt(Integer.MAX_VALUE));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(subject, serial, Date.from(ZonedDateTime.now().minusYears(1L).toInstant()), Date.from(ZonedDateTime.now().plusYears(10L).toInstant()), subject, keyPair.getPublic());
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)TlsCertificateGenerator.createNewSubjectKeyIdentifier((Key)keyPair.getPublic()));
        builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(100));
        builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134));
        X509Certificate certificate = TlsCertificateGenerator.signTheCertificate((X509v3CertificateBuilder)builder, (PrivateKey)keyPair.getPrivate());
        return new TigerPkiIdentity(certificate, keyPair.getPrivate());
    }

    private static X509Certificate signTheCertificate(X509v3CertificateBuilder certificateBuilder, PrivateKey privateKey) throws OperatorCreationException, CertificateException {
        ContentSigner signer = privateKey instanceof RSAPrivateKey ? new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(privateKey) : new JcaContentSignerBuilder("SHA256withECDSA").setProvider("BC").build(privateKey);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(signer));
    }

    private static KeyPair generateRsaKeyPair(int keySize) throws GeneralSecurityException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
        generator.initialize(keySize, new SecureRandom());
        return generator.generateKeyPair();
    }

    private static SubjectKeyIdentifier createNewSubjectKeyIdentifier(Key key) throws IOException {
        try (ASN1InputStream is = new ASN1InputStream((InputStream)new ByteArrayInputStream(key.getEncoded()));){
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)seq);
            SubjectKeyIdentifier subjectKeyIdentifier = new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
            return subjectKeyIdentifier;
        }
    }

    @Generated
    private TlsCertificateGenerator() {
    }
}

