/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tls;

import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.socket.tls.bouncycastle.AbstractKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.tls.DynamicTigerKeyAndCertificateFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.IPAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTigerKeyAndCertificateFactory
extends AbstractKeyAndCertificateFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicTigerKeyAndCertificateFactory.class);
    private static final Duration MAXIMUM_VALIDITY = Duration.ofDays(397L);
    private final TigerPkiIdentity caIdentity;
    private final List<X509Certificate> certificateChain;
    private final String serverName;
    private final List<String> serverAlternativeNames;
    private TigerPkiIdentity eeIdentity;
    private List<String> hostsCoveredByGeneratedIdentity = List.of();
    private final Configuration mockServerConfiguration;

    public DynamicTigerKeyAndCertificateFactory(TigerProxyConfiguration tigerProxyConfiguration, TigerPkiIdentity caIdentity, Configuration mockServerConfiguration) {
        this.certificateChain = new ArrayList();
        this.caIdentity = caIdentity;
        this.eeIdentity = null;
        this.serverName = tigerProxyConfiguration.getTls().getDomainName();
        this.serverAlternativeNames = new ArrayList();
        if (tigerProxyConfiguration.getTls().getAlternativeNames() != null) {
            this.serverAlternativeNames.addAll(tigerProxyConfiguration.getTls().getAlternativeNames());
        }
        this.mockServerConfiguration = mockServerConfiguration;
    }

    public X509Certificate certificateAuthorityX509Certificate() {
        this.buildAndSavePrivateKeyAndX509Certificate();
        return this.caIdentity.getCertificate();
    }

    public PrivateKey privateKey() {
        this.buildAndSavePrivateKeyAndX509Certificate();
        return this.eeIdentity.getPrivateKey();
    }

    public X509Certificate x509Certificate() {
        this.buildAndSavePrivateKeyAndX509Certificate();
        return this.eeIdentity.getCertificate();
    }

    public void buildAndSavePrivateKeyAndX509Certificate() {
        this.assureCurrentCertificateCoversAllNecessaryHosts();
        if (this.eeIdentity == null) {
            try {
                KeyPair keyPair = this.generateRsaKeyPair(2048);
                X509Certificate x509Certificate = this.createCertificateSignedByCa(keyPair.getPublic(), this.caIdentity.getCertificate(), this.caIdentity.getPrivateKey());
                this.eeIdentity = new TigerPkiIdentity(x509Certificate, keyPair.getPrivate());
                this.certificateChain.clear();
                this.certificateChain.add(x509Certificate);
                this.certificateChain.add(this.caIdentity.getCertificate());
            }
            catch (IOException | RuntimeException | GeneralSecurityException | OperatorCreationException e) {
                log.warn("exception while generating private key and X509 certificate", e);
            }
        }
    }

    private void assureCurrentCertificateCoversAllNecessaryHosts() {
        for (String hostThatShouldBePresent : this.mockServerConfiguration.sslSubjectAlternativeNameDomains()) {
            if (this.hostsCoveredByGeneratedIdentity.contains(hostThatShouldBePresent)) continue;
            this.eeIdentity = null;
            return;
        }
    }

    public List<X509Certificate> certificateChain() {
        this.buildAndSavePrivateKeyAndX509Certificate();
        return this.certificateChain;
    }

    private X509Certificate createCertificateSignedByCa(PublicKey publicKey, X509Certificate certificateAuthorityCert, PrivateKey certificateAuthorityPrivateKey) throws GeneralSecurityException, IOException, OperatorCreationException {
        X500Name issuer = new X509CertificateHolder(certificateAuthorityCert.getEncoded()).getSubject();
        X500Name subject = new X500Name("CN=" + this.serverName + ", O=Gematik, L=Berlin, ST=Berlin, C=DE");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt(Integer.MAX_VALUE));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, Date.from(ZonedDateTime.now().minusDays(10L).toInstant()), Date.from(ZonedDateTime.now().plus(MAXIMUM_VALIDITY).minusDays(10L).toInstant()), subject, publicKey);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.createNewSubjectKeyIdentifier((Key)publicKey));
        builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        this.hostsCoveredByGeneratedIdentity = new ArrayList();
        this.hostsCoveredByGeneratedIdentity.addAll(this.serverAlternativeNames);
        this.hostsCoveredByGeneratedIdentity.addAll(this.mockServerConfiguration.sslSubjectAlternativeNameDomains());
        this.hostsCoveredByGeneratedIdentity.add(this.serverName);
        DERSequence subjectAlternativeNamesExtension = new DERSequence((ASN1Encodable[])this.hostsCoveredByGeneratedIdentity.stream().distinct().filter(Objects::nonNull).map(arg_0 -> this.mapAlternativeNameToAsn1Encodable(arg_0)).toArray(ASN1Encodable[]::new));
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNamesExtension);
        return this.signTheCertificate((X509v3CertificateBuilder)builder, certificateAuthorityPrivateKey);
    }

    private ASN1Encodable mapAlternativeNameToAsn1Encodable(String alternativeName) {
        if (IPAddress.isValidIPv6WithNetmask((String)alternativeName) || IPAddress.isValidIPv6((String)alternativeName) || IPAddress.isValidIPv4WithNetmask((String)alternativeName) || IPAddress.isValidIPv4((String)alternativeName)) {
            return new GeneralName(7, alternativeName);
        }
        return new GeneralName(2, alternativeName);
    }

    private X509Certificate signTheCertificate(X509v3CertificateBuilder certificateBuilder, PrivateKey privateKey) throws OperatorCreationException, CertificateException {
        ContentSigner signer = privateKey instanceof RSAPrivateKey ? new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(privateKey) : new JcaContentSignerBuilder("SHA256withECDSA").setProvider("BC").build(privateKey);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(signer));
    }

    private KeyPair generateRsaKeyPair(int keySize) throws GeneralSecurityException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
        generator.initialize(keySize, new SecureRandom());
        return generator.generateKeyPair();
    }

    private SubjectKeyIdentifier createNewSubjectKeyIdentifier(Key key) throws IOException {
        try (ASN1InputStream is = new ASN1InputStream((InputStream)new ByteArrayInputStream(key.getEncoded()));){
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)seq);
            SubjectKeyIdentifier subjectKeyIdentifier = new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
            return subjectKeyIdentifier;
        }
    }

    public boolean certificateNotYetCreated() {
        return this.eeIdentity == null;
    }

    public void resetEeCertificate() {
        this.eeIdentity = null;
    }

    public void addAlternativeName(String host) {
        this.serverAlternativeNames.add(host);
    }

    @Generated
    public static DynamicTigerKeyAndCertificateFactoryBuilder builder() {
        return new DynamicTigerKeyAndCertificateFactoryBuilder();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

