/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRoute;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.handler.AbstractRouteProxyCallback;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseProxyCallback
extends AbstractRouteProxyCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReverseProxyCallback.class);

    public ReverseProxyCallback(TigerProxy tigerProxy, TigerRoute route) {
        super(tigerProxy, route);
    }

    public HttpRequest handleRequest(HttpRequest httpRequest) {
        this.applyModifications(httpRequest);
        HttpRequest request = this.cloneRequest(httpRequest).setSocketAddress(Boolean.valueOf(this.getTargetUrl().getProtocol().equals("https")), this.getTargetUrl().getHost(), Integer.valueOf(this.getPort())).setSecure(Boolean.valueOf(this.getTigerRoute().getTo().startsWith("https"))).setPath(this.patchPath(httpRequest.getPath()));
        if (this.getTigerProxy().getTigerProxyConfiguration().isRewriteHostHeader()) {
            request.removeHeader("Host").withHeader("Host", new String[]{this.getTargetUrl().getHost() + ":" + this.getPort()});
        }
        if (this.getTigerRoute().getBasicAuth() != null) {
            request.withHeader("Authorization", new String[]{this.getTigerRoute().getBasicAuth().toAuthorizationHeaderValue()});
        }
        return request;
    }

    private String patchPath(String requestPath) {
        String patchedUrl = requestPath.replaceFirst(this.getTargetUrl().toString(), "");
        if (patchedUrl.equals("/")) {
            patchedUrl = "";
        }
        if (!this.getTigerRoute().getFrom().equals("/")) {
            patchedUrl = patchedUrl.substring(this.getTigerRoute().getFrom().length());
        }
        if (patchedUrl.startsWith("/") || patchedUrl.isEmpty()) {
            if (this.isAddTrailingSlash() && !patchedUrl.endsWith("/") && (requestPath.equals("/") || requestPath.isEmpty())) {
                return this.getTargetUrl().getPath() + patchedUrl + "/";
            }
            return this.getTargetUrl().getPath() + patchedUrl;
        }
        return this.getTargetUrl().getPath() + "/" + patchedUrl;
    }

    protected String rewriteConcreteLocation(String originalLocation) {
        try {
            URI newUri = new URI(this.getTargetUrl().getPath()).relativize(new URI(originalLocation));
            if (newUri.isAbsolute()) {
                return newUri.toString();
            }
            return "/" + newUri;
        }
        catch (URISyntaxException e) {
            return originalLocation;
        }
    }

    protected String extractProtocolAndHostForRequest(HttpRequest request) {
        return this.getTigerRoute().getTo();
    }

    protected String printTrafficTarget(HttpRequest req) {
        return this.getTigerRoute().getTo();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReverseProxyCallback)) {
            return false;
        }
        ReverseProxyCallback other = (ReverseProxyCallback)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReverseProxyCallback;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

