/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelBinaryFacet;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.mockserver.model.BinaryProxyListener;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.data.TigerNonPairedMessageFacet;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import de.gematik.test.tiger.proxy.handler.BundledServerNamesAdder;
import de.gematik.test.tiger.proxy.handler.TigerExceptionUtils;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BinaryExchangeHandler
implements BinaryProxyListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryExchangeHandler.class);
    private final BundledServerNamesAdder bundledServerNamesAdder = new BundledServerNamesAdder();
    private final TigerProxy tigerProxy;
    private final Map<Pair<SocketAddress, SocketAddress>, byte[]> bufferedParts = new HashMap();

    public void onProxy(BinaryMessage binaryRequest, CompletableFuture<BinaryMessage> binaryResponseFuture, SocketAddress serverAddress, SocketAddress clientAddress) {
        try {
            log.trace("Finalizing binary exchange...");
            Optional convertedRequest = this.convertBinaryMessageOrPushToBuffer(binaryRequest, clientAddress, serverAddress);
            boolean shouldWaitForResponse = this.shouldWaitForResponse(convertedRequest);
            log.trace("Converted request, waiting on response: {}", (Object)shouldWaitForResponse);
            if (!shouldWaitForResponse) {
                convertedRequest.ifPresent(msg -> {
                    msg.addFacet((RbelFacet)new TigerNonPairedMessageFacet());
                    this.getTigerProxy().triggerListener(msg);
                });
            }
            ((CompletableFuture)((CompletableFuture)binaryResponseFuture.thenApply(binaryResponse -> this.convertBinaryMessageOrPushToBuffer(binaryResponse, serverAddress, clientAddress))).thenAccept(convertedResponse -> {
                if (shouldWaitForResponse) {
                    if (convertedResponse.isPresent() && convertedRequest.isPresent()) {
                        TracingMessagePairFacet pairFacet = new TracingMessagePairFacet((RbelElement)convertedResponse.get(), (RbelElement)convertedRequest.get());
                        ((RbelElement)convertedRequest.get()).addFacet((RbelFacet)pairFacet);
                        ((RbelElement)convertedResponse.get()).addFacet((RbelFacet)pairFacet);
                        this.getTigerProxy().triggerListener((RbelElement)convertedRequest.get());
                        this.getTigerProxy().triggerListener((RbelElement)convertedResponse.get());
                    } else {
                        convertedRequest.or(() -> convertedResponse).ifPresent(msg -> {
                            msg.addFacet((RbelFacet)new TigerNonPairedMessageFacet());
                            this.getTigerProxy().triggerListener(msg);
                        });
                    }
                } else {
                    convertedResponse.ifPresent(msg -> {
                        msg.addFacet((RbelFacet)new TigerNonPairedMessageFacet());
                        this.getTigerProxy().triggerListener(msg);
                    });
                }
            })).exceptionally(t -> {
                if (BinaryExchangeHandler.isConnectionResetException((Throwable)t)) {
                    log.trace("Connection reset:", t);
                } else {
                    log.warn("Exception during Direct-Proxy handling:", t);
                    this.propagateExceptionMessageSafe(t);
                }
                return null;
            });
            log.trace("Returning from BinaryExchangeHandler!");
        }
        catch (RuntimeException e) {
            log.warn("Uncaught exception during handling of request", (Throwable)e);
            this.propagateExceptionMessageSafe((Throwable)e);
            throw e;
        }
    }

    private static boolean isConnectionResetException(Throwable t) {
        return TigerExceptionUtils.getCauseWithType((Throwable)t, SocketException.class).filter(e -> "Connection reset".equals(e.getMessage())).isPresent();
    }

    private boolean shouldWaitForResponse(Optional<RbelElement> convertedRequest) {
        return convertedRequest.map(RbelElement::getFacets).stream().flatMap(Collection::stream).anyMatch(RbelFacet::shouldExpectReplyMessage);
    }

    private Optional<RbelElement> convertBinaryMessageOrPushToBuffer(BinaryMessage message, SocketAddress senderAddress, SocketAddress receiverAddress) {
        if (message == null) {
            return Optional.empty();
        }
        Optional rbelMessageOptional = this.tryToConvertMessageAndBufferUnusedBytes(message, senderAddress, receiverAddress);
        if (rbelMessageOptional.isEmpty()) {
            return Optional.empty();
        }
        ((RbelElement)rbelMessageOptional.get()).addFacet((RbelFacet)RbelMessageTimingFacet.builder().transmissionTime(message.getTimestamp().atZone(ZoneId.systemDefault())).build());
        ((RbelElement)rbelMessageOptional.get()).addFacet((RbelFacet)new RbelBinaryFacet());
        log.debug("Finalized binary exchange {}", (Object)rbelMessageOptional.flatMap(msg -> msg.getFacet(RbelTcpIpMessageFacet.class)).map(RbelTcpIpMessageFacet::getSenderHostname).map(Objects::toString).orElse(""));
        return rbelMessageOptional;
    }

    private Optional<RbelElement> tryToConvertMessageAndBufferUnusedBytes(BinaryMessage message, SocketAddress senderAddress, SocketAddress receiverAddress) {
        Optional<RbelElement> requestOptional = this.tryToConvertMessage(message.getBytes(), senderAddress, receiverAddress).or(() -> this.addBufferToMessage(message, senderAddress, receiverAddress).flatMap(addedBufferBytes -> this.tryToConvertMessage(addedBufferBytes, senderAddress, receiverAddress)));
        if (requestOptional.isEmpty()) {
            Pair key = Pair.of((Object)senderAddress, (Object)receiverAddress);
            byte[] previouslyBufferedBytes = (byte[])this.bufferedParts.get(key);
            if (previouslyBufferedBytes == null) {
                this.bufferedParts.put(key, message.getBytes());
            } else {
                this.bufferedParts.put(key, Arrays.concatenate((byte[])previouslyBufferedBytes, (byte[])message.getBytes()));
            }
        }
        return requestOptional;
    }

    private Optional<byte[]> addBufferToMessage(BinaryMessage message, SocketAddress senderAddress, SocketAddress receiverAddress) {
        byte[] bufferedBytes = (byte[])this.bufferedParts.get(Pair.of((Object)senderAddress, (Object)receiverAddress));
        if (bufferedBytes == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(Arrays.concatenate((byte[])bufferedBytes, (byte[])message.getBytes()));
    }

    private Optional<RbelElement> tryToConvertMessage(byte[] messageContent, SocketAddress senderAddress, SocketAddress receiverAddress) {
        RbelElement result = this.getTigerProxy().getRbelLogger().getRbelConverter().parseMessage(messageContent, this.toRbelHostname(senderAddress), this.toRbelHostname(receiverAddress), Optional.empty());
        if (result.getFacets().size() <= 1) {
            this.getTigerProxy().getRbelLogger().getRbelConverter().removeMessage(result);
            return Optional.empty();
        }
        this.bundledServerNamesAdder.addBundledServerNameToHostnameFacet(result);
        return Optional.of(result);
    }

    private void propagateExceptionMessageSafe(Throwable exception) {
        try {
            this.tigerProxy.propagateException(exception);
        }
        catch (Exception handlingException) {
            log.warn("While propagating an exception another error occured (ignoring):", (Throwable)handlingException);
        }
    }

    private RbelHostname toRbelHostname(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return RbelHostname.builder().hostname(inetSocketAddress.getHostName()).port(inetSocketAddress.getPort()).build();
        }
        log.warn("Incompatible socketAddress encountered: " + socketAddress.getClass().getSimpleName());
        return null;
    }

    @Generated
    public BundledServerNamesAdder getBundledServerNamesAdder() {
        return this.bundledServerNamesAdder;
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public Map<Pair<SocketAddress, SocketAddress>, byte[]> getBufferedParts() {
        return this.bufferedParts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryExchangeHandler)) {
            return false;
        }
        BinaryExchangeHandler other = (BinaryExchangeHandler)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        BundledServerNamesAdder this$bundledServerNamesAdder = this.getBundledServerNamesAdder();
        BundledServerNamesAdder other$bundledServerNamesAdder = other.getBundledServerNamesAdder();
        if (this$bundledServerNamesAdder == null ? other$bundledServerNamesAdder != null : !this$bundledServerNamesAdder.equals(other$bundledServerNamesAdder)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !this$tigerProxy.equals(other$tigerProxy)) {
            return false;
        }
        Map this$bufferedParts = this.getBufferedParts();
        Map other$bufferedParts = other.getBufferedParts();
        return !(this$bufferedParts == null ? other$bufferedParts != null : !((Object)this$bufferedParts).equals(other$bufferedParts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BinaryExchangeHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BundledServerNamesAdder $bundledServerNamesAdder = this.getBundledServerNamesAdder();
        result = result * 59 + ($bundledServerNamesAdder == null ? 43 : $bundledServerNamesAdder.hashCode());
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : $tigerProxy.hashCode());
        Map $bufferedParts = this.getBufferedParts();
        result = result * 59 + ($bufferedParts == null ? 43 : ((Object)$bufferedParts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BinaryExchangeHandler(bundledServerNamesAdder=" + this.getBundledServerNamesAdder() + ", tigerProxy=" + this.getTigerProxy() + ", bufferedParts=" + this.getBufferedParts() + ")";
    }

    @ConstructorProperties(value={"tigerProxy"})
    @Generated
    public BinaryExchangeHandler(TigerProxy tigerProxy) {
        this.tigerProxy = tigerProxy;
    }
}

