/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRoute;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.handler.AbstractTigerRouteCallback;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRouteProxyCallback
extends AbstractTigerRouteCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRouteProxyCallback.class);
    private final URL targetUrl;
    private final boolean addTrailingSlash;
    private final URI sourceUri;
    private final int port;

    AbstractRouteProxyCallback(TigerProxy tigerProxy, TigerRoute tigerRoute) {
        super(tigerProxy, tigerRoute);
        if (tigerRoute.getTo().endsWith("/")) {
            this.targetUrl = new URL(tigerRoute.getTo().substring(0, tigerRoute.getTo().length() - 1));
            this.addTrailingSlash = true;
        } else {
            this.targetUrl = new URL(tigerRoute.getTo());
            this.addTrailingSlash = false;
        }
        this.sourceUri = new URI(tigerRoute.getFrom());
        this.port = this.targetUrl.getPort() < 0 ? (this.targetUrl.getProtocol().equals("https") ? 443 : 80) : this.targetUrl.getPort();
        tigerProxy.addAlternativeName(this.sourceUri.getHost());
    }

    protected String rewriteConcreteLocation(String originalLocation) {
        try {
            URI newUri = new URI(this.targetUrl.getPath()).relativize(new URI(originalLocation));
            if (newUri.isAbsolute()) {
                return newUri.toString();
            }
            return "/" + newUri;
        }
        catch (URISyntaxException e) {
            return originalLocation;
        }
    }

    @Generated
    public URL getTargetUrl() {
        return this.targetUrl;
    }

    @Generated
    public boolean isAddTrailingSlash() {
        return this.addTrailingSlash;
    }

    @Generated
    public URI getSourceUri() {
        return this.sourceUri;
    }

    @Generated
    public int getPort() {
        return this.port;
    }
}

