/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.data;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelHostnameFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelRequestFacet;
import de.gematik.rbellogger.data.facet.RbelResponseFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.test.tiger.proxy.data.MessageMetaDataDto;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MessageMetaDataDto {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageMetaDataDto.class);
    private String uuid;
    private String path;
    private String method;
    private Integer responseCode;
    private String recipient;
    private String sender;
    private String bundledServerNameSender;
    private String bundledServerNameReceiver;
    private long sequenceNumber;
    private String menuInfoString;
    private ZonedDateTime timestamp;
    private boolean isRequest;
    private String pairedUuid;

    public static MessageMetaDataDto createFrom(RbelElement el) {
        MessageMetaDataDtoBuilder builder = MessageMetaDataDto.builder();
        builder = builder.uuid(el.getUuid()).sequenceNumber(MessageMetaDataDto.getElementSequenceNumber((RbelElement)el)).sender(el.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSender).filter(element -> element.getRawStringContent() != null).flatMap(element -> Optional.of(element.getRawStringContent())).orElse("")).recipient(el.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getReceiver).filter(element -> element.getRawStringContent() != null).flatMap(element -> Optional.of(element.getRawStringContent())).orElse("")).bundledServerNameSender(el.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSender).flatMap(MessageMetaDataDto::tryToExtractServerName).orElse("")).bundledServerNameReceiver(el.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getReceiver).flatMap(MessageMetaDataDto::tryToExtractServerName).orElse("")).pairedUuid((String)el.getFacet(TracingMessagePairFacet.class).flatMap(f -> f.getOtherMessage(el)).map(RbelElement::getUuid).orElse(null));
        if (el.hasFacet(RbelHttpRequestFacet.class)) {
            RbelHttpRequestFacet req = (RbelHttpRequestFacet)el.getFacetOrFail(RbelHttpRequestFacet.class);
            builder = builder.path(req.getPath().getRawStringContent()).method(req.getMethod().getRawStringContent()).responseCode(null);
        } else if (el.hasFacet(RbelHttpResponseFacet.class)) {
            builder.responseCode(Integer.valueOf(Integer.parseInt(((RbelHttpResponseFacet)el.getFacetOrFail(RbelHttpResponseFacet.class)).getResponseCode().getRawStringContent())));
        }
        builder.isRequest(el.hasFacet(RbelRequestFacet.class));
        builder.timestamp((ZonedDateTime)el.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null));
        builder.menuInfoString((String)el.getFacet(RbelRequestFacet.class).map(RbelRequestFacet::getMenuInfoString).or(() -> el.getFacet(RbelResponseFacet.class).map(RbelResponseFacet::getMenuInfoString)).orElse(null));
        return builder.build();
    }

    private static Optional<String> tryToExtractServerName(RbelElement element) {
        Optional hostnameFacet = element.getFacet(RbelHostnameFacet.class);
        if (hostnameFacet.isEmpty()) {
            return Optional.empty();
        }
        return hostnameFacet.flatMap(RbelHostnameFacet::getBundledServerName).filter(e -> e.getRawStringContent() != null).flatMap(e -> Optional.of(e.getRawStringContent())).or(() -> hostnameFacet.map(RbelHostnameFacet::getDomain).map(RbelElement::getRawStringContent).filter(StringUtils::isNotEmpty).filter(s -> !s.startsWith("localhost") && !s.startsWith("127.0.0.1")));
    }

    public static long getElementSequenceNumber(RbelElement rbelElement) {
        return rbelElement.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSequenceNumber).orElse(0L);
    }

    @Generated
    public static MessageMetaDataDtoBuilder builder() {
        return new MessageMetaDataDtoBuilder();
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public Integer getResponseCode() {
        return this.responseCode;
    }

    @Generated
    public String getRecipient() {
        return this.recipient;
    }

    @Generated
    public String getSender() {
        return this.sender;
    }

    @Generated
    public String getBundledServerNameSender() {
        return this.bundledServerNameSender;
    }

    @Generated
    public String getBundledServerNameReceiver() {
        return this.bundledServerNameReceiver;
    }

    @Generated
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Generated
    public String getMenuInfoString() {
        return this.menuInfoString;
    }

    @Generated
    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public boolean isRequest() {
        return this.isRequest;
    }

    @Generated
    public String getPairedUuid() {
        return this.pairedUuid;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    @Generated
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    @Generated
    public void setSender(String sender) {
        this.sender = sender;
    }

    @Generated
    public void setBundledServerNameSender(String bundledServerNameSender) {
        this.bundledServerNameSender = bundledServerNameSender;
    }

    @Generated
    public void setBundledServerNameReceiver(String bundledServerNameReceiver) {
        this.bundledServerNameReceiver = bundledServerNameReceiver;
    }

    @Generated
    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    @Generated
    public void setMenuInfoString(String menuInfoString) {
        this.menuInfoString = menuInfoString;
    }

    @Generated
    public void setTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setRequest(boolean isRequest) {
        this.isRequest = isRequest;
    }

    @Generated
    public void setPairedUuid(String pairedUuid) {
        this.pairedUuid = pairedUuid;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageMetaDataDto)) {
            return false;
        }
        MessageMetaDataDto other = (MessageMetaDataDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getSequenceNumber() != other.getSequenceNumber()) {
            return false;
        }
        if (this.isRequest() != other.isRequest()) {
            return false;
        }
        Integer this$responseCode = this.getResponseCode();
        Integer other$responseCode = other.getResponseCode();
        if (this$responseCode == null ? other$responseCode != null : !((Object)this$responseCode).equals(other$responseCode)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$recipient = this.getRecipient();
        String other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        String this$bundledServerNameSender = this.getBundledServerNameSender();
        String other$bundledServerNameSender = other.getBundledServerNameSender();
        if (this$bundledServerNameSender == null ? other$bundledServerNameSender != null : !this$bundledServerNameSender.equals(other$bundledServerNameSender)) {
            return false;
        }
        String this$bundledServerNameReceiver = this.getBundledServerNameReceiver();
        String other$bundledServerNameReceiver = other.getBundledServerNameReceiver();
        if (this$bundledServerNameReceiver == null ? other$bundledServerNameReceiver != null : !this$bundledServerNameReceiver.equals(other$bundledServerNameReceiver)) {
            return false;
        }
        String this$menuInfoString = this.getMenuInfoString();
        String other$menuInfoString = other.getMenuInfoString();
        if (this$menuInfoString == null ? other$menuInfoString != null : !this$menuInfoString.equals(other$menuInfoString)) {
            return false;
        }
        ZonedDateTime this$timestamp = this.getTimestamp();
        ZonedDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$pairedUuid = this.getPairedUuid();
        String other$pairedUuid = other.getPairedUuid();
        return !(this$pairedUuid == null ? other$pairedUuid != null : !this$pairedUuid.equals(other$pairedUuid));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageMetaDataDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
        result = result * 59 + (this.isRequest() ? 79 : 97);
        Integer $responseCode = this.getResponseCode();
        result = result * 59 + ($responseCode == null ? 43 : ((Object)$responseCode).hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        String $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        String $bundledServerNameSender = this.getBundledServerNameSender();
        result = result * 59 + ($bundledServerNameSender == null ? 43 : $bundledServerNameSender.hashCode());
        String $bundledServerNameReceiver = this.getBundledServerNameReceiver();
        result = result * 59 + ($bundledServerNameReceiver == null ? 43 : $bundledServerNameReceiver.hashCode());
        String $menuInfoString = this.getMenuInfoString();
        result = result * 59 + ($menuInfoString == null ? 43 : $menuInfoString.hashCode());
        ZonedDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $pairedUuid = this.getPairedUuid();
        result = result * 59 + ($pairedUuid == null ? 43 : $pairedUuid.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MessageMetaDataDto(uuid=" + this.getUuid() + ", path=" + this.getPath() + ", method=" + this.getMethod() + ", responseCode=" + this.getResponseCode() + ", recipient=" + this.getRecipient() + ", sender=" + this.getSender() + ", bundledServerNameSender=" + this.getBundledServerNameSender() + ", bundledServerNameReceiver=" + this.getBundledServerNameReceiver() + ", sequenceNumber=" + this.getSequenceNumber() + ", menuInfoString=" + this.getMenuInfoString() + ", timestamp=" + this.getTimestamp() + ", isRequest=" + this.isRequest() + ", pairedUuid=" + this.getPairedUuid() + ")";
    }

    @ConstructorProperties(value={"uuid", "path", "method", "responseCode", "recipient", "sender", "bundledServerNameSender", "bundledServerNameReceiver", "sequenceNumber", "menuInfoString", "timestamp", "isRequest", "pairedUuid"})
    @Generated
    public MessageMetaDataDto(String uuid, String path, String method, Integer responseCode, String recipient, String sender, String bundledServerNameSender, String bundledServerNameReceiver, long sequenceNumber, String menuInfoString, ZonedDateTime timestamp, boolean isRequest, String pairedUuid) {
        this.uuid = uuid;
        this.path = path;
        this.method = method;
        this.responseCode = responseCode;
        this.recipient = recipient;
        this.sender = sender;
        this.bundledServerNameSender = bundledServerNameSender;
        this.bundledServerNameReceiver = bundledServerNameReceiver;
        this.sequenceNumber = sequenceNumber;
        this.menuInfoString = menuInfoString;
        this.timestamp = timestamp;
        this.isRequest = isRequest;
        this.pairedUuid = pairedUuid;
    }

    @Generated
    public MessageMetaDataDto() {
    }
}

