/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.configuration;

import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.data.config.tigerproxy.ForwardProxyInfo;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyType;
import de.gematik.test.tiger.common.exceptions.TigerProxyToForwardProxyException;
import de.gematik.test.tiger.common.exceptions.TigerUnknownProtocolException;
import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.proxy.configuration.ProxyConfigurationConverter;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProxyConfigurationConverter {
    private ProxyConfigurationConverter() {
    }

    public static Optional<ProxyConfiguration> convertForwardProxyConfigurationToMockServerConfiguration(TigerProxyConfiguration tpConfig) {
        return Optional.ofNullable(tpConfig.getForwardToProxy()).flatMap(ProxyConfigurationConverter::createMockServerProxyConfiguration);
    }

    public static Configuration convertToMockServerConfiguration(TigerProxyConfiguration tpConfig) {
        Configuration config = Configuration.configuration();
        ProxyConfigurationConverter.convertForwardProxyConfigurationToMockServerConfiguration((TigerProxyConfiguration)tpConfig).ifPresent(proxyCfg -> {
            switch (1.$SwitchMap$de$gematik$test$tiger$mockserver$proxyconfiguration$ProxyConfiguration$Type[proxyCfg.getType().ordinal()]) {
                case 1: {
                    config.forwardHttpProxy(proxyCfg.getProxyAddress());
                    break;
                }
                case 2: {
                    config.forwardHttpsProxy(proxyCfg.getProxyAddress());
                    break;
                }
                case 3: {
                    throw new TigerConfigurationException("Socks Proxies are not currently supported!");
                }
            }
        });
        return config;
    }

    public static ProxyConfiguration.Type toMockServerType(TigerProxyType type) throws TigerUnknownProtocolException {
        if (type == TigerProxyType.HTTP) {
            return ProxyConfiguration.Type.HTTP;
        }
        if (type == TigerProxyType.HTTPS) {
            return ProxyConfiguration.Type.HTTPS;
        }
        throw new TigerUnknownProtocolException("Protocol of type " + type.toString() + " not specified for proxies");
    }

    public static Optional<ProxyConfiguration> createMockServerProxyConfiguration(ForwardProxyInfo forwardProxyInfo) {
        if (StringUtils.isEmpty((CharSequence)forwardProxyInfo.getHostname())) {
            return Optional.empty();
        }
        if (StringUtils.equals((CharSequence)forwardProxyInfo.getHostname(), (CharSequence)"$SYSTEM")) {
            return ProxyConfigurationConverter.convertSystemProxyConfig((ForwardProxyInfo)forwardProxyInfo);
        }
        return Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)Optional.ofNullable(forwardProxyInfo.getType()).map(ProxyConfigurationConverter::toMockServerType).orElse(ProxyConfiguration.Type.HTTPS), (String)(forwardProxyInfo.getHostname() + ":" + forwardProxyInfo.calculateProxyPort()), (String)forwardProxyInfo.getUsername(), (String)forwardProxyInfo.getPassword()));
    }

    public static Optional<ProxyConfiguration> useProxyWithSystemProperties(String proxyProtocol, ForwardProxyInfo forwardProxyInfo) {
        ProxyConfiguration.Type proxyType = ProxyConfigurationConverter.toMockServerType((TigerProxyType)forwardProxyInfo.getProxyProtocol(proxyProtocol));
        String proxyHost = System.getProperty(proxyProtocol + ".proxyHost");
        String proxyPort = System.getProperty(proxyProtocol + ".proxyPort");
        String proxyUser = System.getProperty(proxyProtocol + ".proxyUser");
        String proxyPassword = System.getProperty(proxyProtocol + ".proxyPassword");
        if (StringUtils.isEmpty((CharSequence)proxyHost)) {
            return Optional.empty();
        }
        if (proxyUser != null || proxyPassword != null) {
            if (proxyUser == null) {
                throw new TigerProxyToForwardProxyException("Could not convert proxy configuration: proxyUser == null, proxyPassword != null");
            }
            if (proxyPassword == null) {
                throw new TigerProxyToForwardProxyException("Could not convert proxy configuration: proxyUser != null, proxyPassword == null");
            }
            return Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)proxyType, (String)(proxyHost + ":" + ForwardProxyInfo.mapProxyPort((String)proxyPort, (TigerProxyType)forwardProxyInfo.getProxyProtocol(proxyProtocol))), (String)proxyUser, (String)proxyPassword));
        }
        return Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)proxyType, (String)(proxyHost + ":" + ForwardProxyInfo.mapProxyPort((String)proxyPort, (TigerProxyType)forwardProxyInfo.getProxyProtocol(proxyProtocol)))));
    }

    public static Optional<ProxyConfiguration> useProxyAsEnvVar(ForwardProxyInfo forwardProxyInfo, String envProxyType) {
        String httpProxyHostFromEnv = System.getenv(envProxyType);
        if (StringUtils.isEmpty((CharSequence)httpProxyHostFromEnv)) {
            return Optional.empty();
        }
        URI proxyAsUri = URI.create(httpProxyHostFromEnv);
        if (proxyAsUri.getHost() == null || proxyAsUri.getScheme() == null) {
            throw new TigerProxyToForwardProxyException("No proxy host or no proxy protocol specified.");
        }
        ProxyConfiguration.Type proxyType = ProxyConfigurationConverter.toMockServerType((TigerProxyType)forwardProxyInfo.getProxyProtocol(proxyAsUri.getScheme()));
        String proxyUsernamePassword = proxyAsUri.getUserInfo();
        String proxyPort = ForwardProxyInfo.mapProxyPort((String)String.valueOf(proxyAsUri.getPort()), (TigerProxyType)forwardProxyInfo.getProxyProtocol(proxyAsUri.getScheme()));
        if (proxyUsernamePassword == null) {
            return Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)proxyType, (String)(proxyAsUri.getHost() + ":" + proxyPort)));
        }
        if (!proxyUsernamePassword.contains(":")) {
            throw new TigerProxyToForwardProxyException("Could not convert proxy configuration: either username or password are not present in the env variable");
        }
        return Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)proxyType, (String)(proxyAsUri.getHost() + ":" + proxyPort), (String)proxyUsernamePassword.split(":")[0], (String)proxyUsernamePassword.split(":")[1]));
    }

    public static Optional<ProxyConfiguration> convertSystemProxyConfig(ForwardProxyInfo forwardProxyInfo) {
        return ProxyConfigurationConverter.useProxyWithSystemProperties((String)"http", (ForwardProxyInfo)forwardProxyInfo).or(() -> ProxyConfigurationConverter.useProxyWithSystemProperties((String)"https", (ForwardProxyInfo)forwardProxyInfo)).or(() -> ProxyConfigurationConverter.useProxyAsEnvVar((ForwardProxyInfo)forwardProxyInfo, (String)"http_proxy")).or(() -> ProxyConfigurationConverter.useProxyAsEnvVar((ForwardProxyInfo)forwardProxyInfo, (String)"https_proxy"));
    }
}

