/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.file.RbelFileWriter;
import de.gematik.test.tiger.proxy.client.PartialTracingMessage;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TracingMessageFrame;
import de.gematik.test.tiger.proxy.data.TigerNonPairedMessageFacet;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingMessageIsolani
implements TracingMessageFrame {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TracingMessageIsolani.class);
    private PartialTracingMessage message;
    private final TigerRemoteProxyClient remoteProxyClient;

    public void checkForCompletePairAndPropagateIfComplete() {
        if (this.message != null && this.message.isComplete()) {
            this.remoteProxyClient.submitNewMessageTask(() -> this.parseAndPropagate());
        }
    }

    private void parseAndPropagate() {
        if (this.remoteProxyClient.messageUuidKnown(this.message.getTracingDto().getRequestUuid())) {
            log.trace("{}Skipping parsing of pair with UUIDs ({} and {}) (received from PUSH): UUID already known", new Object[]{this.remoteProxyClient.proxyName(), this.message.getTracingDto().getRequestUuid(), this.message.getTracingDto().getResponseUuid()});
            return;
        }
        Optional messageParsed = this.remoteProxyClient.buildNewRbelMessage(this.message.getSender(), this.message.getReceiver(), this.message.buildCompleteContent(), Optional.ofNullable(this.message.getTransmissionTime()), this.message.getTracingDto().getRequestUuid());
        if (messageParsed.isEmpty()) {
            return;
        }
        RbelFileWriter.DEFAULT_POST_CONVERSION_LISTENER.forEach(listener -> listener.performMessagePostConversionProcessing((RbelElement)messageParsed.get(), this.remoteProxyClient.getRbelLogger().getRbelConverter(), new JSONObject(this.message.getAdditionalInformation())));
        ((RbelElement)messageParsed.get()).addFacet((RbelFacet)new TigerNonPairedMessageFacet());
        if (log.isTraceEnabled()) {
            log.trace("{}Received isolani message to {} (UUID {})", new Object[]{this.remoteProxyClient.proxyName(), messageParsed.map(RbelElement::getRawStringContent).map(s -> Stream.of(s.split(" ")).skip(1L).limit(1L).collect(Collectors.joining(","))).orElse("<>"), ((RbelElement)messageParsed.get()).getUuid()});
        }
        this.remoteProxyClient.getLastMessageUuid().set(((RbelElement)messageParsed.get()).getUuid());
        if (this.remoteProxyClient.messageMatchesFilterCriterion((RbelElement)messageParsed.get())) {
            this.remoteProxyClient.propagateMessage((RbelElement)messageParsed.get());
        } else {
            this.remoteProxyClient.removeMessage((RbelElement)messageParsed.get());
        }
    }

    @ConstructorProperties(value={"remoteProxyClient"})
    @Generated
    public TracingMessageIsolani(TigerRemoteProxyClient remoteProxyClient) {
        this.remoteProxyClient = remoteProxyClient;
    }

    @Generated
    public PartialTracingMessage getMessage() {
        return this.message;
    }

    @Generated
    public TigerRemoteProxyClient getRemoteProxyClient() {
        return this.remoteProxyClient;
    }

    @Generated
    public void setMessage(PartialTracingMessage message) {
        this.message = message;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TracingMessageIsolani)) {
            return false;
        }
        TracingMessageIsolani other = (TracingMessageIsolani)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PartialTracingMessage this$message = this.getMessage();
        PartialTracingMessage other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        TigerRemoteProxyClient this$remoteProxyClient = this.getRemoteProxyClient();
        TigerRemoteProxyClient other$remoteProxyClient = other.getRemoteProxyClient();
        return !(this$remoteProxyClient == null ? other$remoteProxyClient != null : !this$remoteProxyClient.equals(other$remoteProxyClient));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TracingMessageIsolani;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartialTracingMessage $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        TigerRemoteProxyClient $remoteProxyClient = this.getRemoteProxyClient();
        result = result * 59 + ($remoteProxyClient == null ? 43 : $remoteProxyClient.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TracingMessageIsolani(message=" + this.getMessage() + ")";
    }
}

