/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.client.TigerRemoteTrafficDownloader;
import de.gematik.test.tiger.proxy.data.TigerDownloadedMessageFacet;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TigerRemoteTrafficDownloader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerRemoteTrafficDownloader.class);
    private final TigerRemoteProxyClient tigerRemoteProxyClient;

    public void execute() {
        this.tigerRemoteProxyClient.switchToQueueMode();
        this.downloadAllTrafficFromRemote();
        log.info("{}Successfully downloaded missed traffic from '{}'.", (Object)this.tigerRemoteProxyClient.proxyName(), (Object)this.getRemoteProxyUrl());
        log.info("{}Successfully downloaded & parsed missed traffic from '{}'. Now {} message(s) in local history", new Object[]{this.tigerRemoteProxyClient.proxyName(), this.getRemoteProxyUrl(), this.getRbelLogger().getMessageHistory().size()});
        this.tigerRemoteProxyClient.switchToExecutorMode();
    }

    private void parseTrafficChunk(String rawTraffic) {
        List convertedMessages = this.tigerRemoteProxyClient.getRbelFileWriter().convertFromRbelFile(rawTraffic);
        long expectedNumberOfMessages = rawTraffic.lines().count();
        this.doMessageBatchPostProcessing(convertedMessages, expectedNumberOfMessages);
    }

    private void doMessageBatchPostProcessing(List<RbelElement> convertedMessages, long count) {
        convertedMessages.forEach(msg -> msg.addFacet((RbelFacet)new TigerDownloadedMessageFacet()));
        for (int i = 0; i < convertedMessages.size(); i += 2) {
            TracingMessagePairFacet pairFacet = TracingMessagePairFacet.builder().response(convertedMessages.get(i + 1)).request(convertedMessages.get(i)).build();
            convertedMessages.get(i + 1).addFacet((RbelFacet)pairFacet);
        }
        if (log.isTraceEnabled()) {
            log.trace("{}Just parsed another traffic batch of {} lines, got {} messages, expected {} (rest was filtered). Now standing at {} messages overall", new Object[]{this.tigerRemoteProxyClient.proxyName(), count, convertedMessages.size(), (count + 2L) / 3L, this.getRbelLogger().getMessageHistory().size()});
        }
        if (!convertedMessages.isEmpty()) {
            this.tigerRemoteProxyClient.getLastMessageUuid().set(convertedMessages.get(convertedMessages.size() - 1).getUuid());
        }
        convertedMessages.forEach(arg_0 -> ((TigerRemoteProxyClient)this.tigerRemoteProxyClient).triggerListener(arg_0));
        if (log.isTraceEnabled()) {
            log.trace("{}Parsed traffic, ending with {}", (Object)this.tigerRemoteProxyClient.proxyName(), (Object)convertedMessages.stream().map(RbelElement::getRawStringContent).flatMap(content -> Stream.of(content.split(" ")).skip(1L).limit(1L)).filter(httpHeaderString -> httpHeaderString.startsWith("/")).collect(Collectors.joining(", ")));
        }
    }

    private void downloadAllTrafficFromRemote() {
        PaginationInfo paginationInfo;
        int pageNumber = 0;
        Optional<String> currentLastUuid = Optional.ofNullable((String)this.tigerRemoteProxyClient.getLastMessageUuid().get());
        int pageSize = this.tigerRemoteProxyClient.getTigerProxyConfiguration().getTrafficDownloadPageSize();
        do {
            paginationInfo = this.downloadTrafficPageFromRemoteAndAddToQueue(pageSize, currentLastUuid);
            currentLastUuid = Optional.ofNullable(paginationInfo.getLastUuid()).filter(StringUtils::isNotEmpty);
            if (++pageNumber <= 100) continue;
            log.warn("Interrupting traffic-download: Reached 100 downloads! (Maybe the influx of traffic on the upstream proxy is greater then our downstream-sped?)");
            return;
        } while (paginationInfo.getAvailableMessages() > pageSize);
    }

    private PaginationInfo downloadTrafficPageFromRemoteAndAddToQueue(int pageSize, Optional<String> currentLastUuid) {
        String downloadUrl = this.getRemoteProxyUrl() + "/webui/trafficLog.tgr";
        log.debug("{}Downloading missed traffic from '{}', starting from {}. page-size {} (currently cached {} messages)", new Object[]{this.tigerRemoteProxyClient.proxyName(), currentLastUuid, downloadUrl, pageSize, this.getRbelLogger().getMessageHistory().size()});
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("pageSize", pageSize);
        currentLastUuid.ifPresent(uuid -> parameters.put("lastMsgUuid", (Integer)uuid));
        HttpResponse response = ((GetRequest)Unirest.get((String)downloadUrl).queryString(parameters)).asString();
        if (response.getStatus() != 200) {
            throw new TigerRemoteProxyClientException("Error while downloading message from remote '" + downloadUrl + "': " + (String)response.getBody());
        }
        this.parseTrafficChunk((String)response.getBody());
        return PaginationInfo.of((HttpResponse)response);
    }

    private RbelLogger getRbelLogger() {
        return this.tigerRemoteProxyClient.getRbelLogger();
    }

    private String getRemoteProxyUrl() {
        return this.tigerRemoteProxyClient.getRemoteProxyUrl();
    }

    @ConstructorProperties(value={"tigerRemoteProxyClient"})
    @Generated
    public TigerRemoteTrafficDownloader(TigerRemoteProxyClient tigerRemoteProxyClient) {
        this.tigerRemoteProxyClient = tigerRemoteProxyClient;
    }
}

