/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.util.RbelMessagePostProcessor;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFileReadingFilter
implements RbelMessagePostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxyFileReadingFilter.class);
    private final String filterExpression;
    private final Map<String, RbelElement> deletedMessages = new HashMap();

    public void performMessagePostConversionProcessing(RbelElement message, RbelConverter converter, JSONObject messageObject) {
        if (this.isKeepMessage(message)) {
            RbelElement deletedPartner;
            if (messageObject.has("pairedMessageUuid") && (deletedPartner = (RbelElement)this.deletedMessages.get(messageObject.getString("pairedMessageUuid"))) != null) {
                this.deletedMessages.remove(deletedPartner.getUuid());
            }
        } else if (messageObject.has("pairedMessageUuid")) {
            RbelElement partnerMessage = (RbelElement)this.deletedMessages.get(messageObject.getString("pairedMessageUuid"));
            if (partnerMessage != null) {
                converter.removeMessage(message);
                converter.removeMessage(partnerMessage);
            }
        } else {
            this.deletedMessages.put(message.getUuid(), message);
        }
    }

    private boolean isKeepMessage(RbelElement message) {
        return TigerJexlExecutor.matchesAsJexlExpression((Object)message, (String)this.filterExpression);
    }

    @ConstructorProperties(value={"filterExpression"})
    @Generated
    public ProxyFileReadingFilter(String filterExpression) {
        this.filterExpression = filterExpression;
    }
}

