/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelElementConvertionPair;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyParsingException;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MockServerToRbelConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MockServerToRbelConverter.class);
    private final RbelConverter rbelConverter;

    public CompletableFuture<RbelElement> convertResponse(HttpResponse response, String senderUrl, String receiverUrl, CompletableFuture<RbelElement> pairedParsedRequest, Optional<ZonedDateTime> timestamp) {
        if (log.isTraceEnabled()) {
            log.trace("Converting response {}, headers {}, body {}", new Object[]{response, response.getHeaders(), response.getBodyAsString()});
        }
        return this.rbelConverter.parseMessageAsync(new RbelElementConvertionPair(this.responseToRbelMessage(response), pairedParsedRequest), this.convertUri(senderUrl), (RbelHostname)RbelHostname.fromString((String)receiverUrl).orElse(null), timestamp).thenApply(element -> MockServerToRbelConverter.addHttpResponseFacetIfNotPresent((HttpResponse)response, (RbelElement)element));
    }

    private static RbelElement addHttpResponseFacetIfNotPresent(HttpResponse response, RbelElement element) {
        if (!element.hasFacet(RbelHttpResponseFacet.class)) {
            element.addFacet((RbelFacet)RbelHttpResponseFacet.builder().responseCode(RbelElement.builder().parentNode(element).rawContent(response.getStatusCode().toString().getBytes()).build()).build());
        }
        return element;
    }

    public CompletableFuture<RbelElement> convertRequest(HttpRequest request, String protocolAndHost, Optional<ZonedDateTime> timestamp) {
        if (request.getParsedRbelMessage() != null) {
            return CompletableFuture.completedFuture(request.getParsedRbelMessage());
        }
        if (log.isTraceEnabled()) {
            log.trace("Converting request {}, headers {}, body {}", new Object[]{request, request.getHeaders(), request.getBodyAsString()});
        }
        return this.rbelConverter.parseMessageAsync(new RbelElementConvertionPair(this.requestToRbelMessage(request)), (RbelHostname)RbelHostname.fromString((String)request.getRemoteAddress()).orElse(null), this.convertUri(protocolAndHost), timestamp).thenApply(e -> this.addHttpRequestFacetIfNotPresent(request, e));
    }

    public RbelElement convertErrorResponse(HttpRequest request, String protocolAndHost) {
        return this.rbelConverter.parseMessage(new byte[0], this.convertUri(protocolAndHost), (RbelHostname)RbelHostname.fromString((String)request.getRemoteAddress()).orElse(null), Optional.of(ZonedDateTime.now()));
    }

    private RbelElement addHttpRequestFacetIfNotPresent(HttpRequest request, RbelElement element) {
        if (!element.hasFacet(RbelHttpRequestFacet.class)) {
            element.addFacet((RbelFacet)RbelHttpRequestFacet.builder().path(RbelElement.wrap((RbelElement)element, (Object)request.getPath())).method(RbelElement.wrap((RbelElement)element, (Object)request.getMethod())).build());
        }
        return element;
    }

    private RbelHostname convertUri(String protocolAndHost) {
        try {
            new URI(protocolAndHost);
            return RbelHostname.generateFromUrl((String)protocolAndHost).orElse(null);
        }
        catch (URISyntaxException e) {
            throw new TigerProxyParsingException("Unable to parse hostname from '" + protocolAndHost + "'", (Exception)e);
        }
    }

    public RbelElement responseToRbelMessage(HttpResponse response) {
        byte[] httpMessage = this.responseToRawMessage(response);
        return RbelElement.builder().rawContent(httpMessage).build();
    }

    public RbelElement requestToRbelMessage(HttpRequest request) {
        byte[] httpMessage = this.requestToRawMessage(request);
        return RbelElement.builder().rawContent(httpMessage).build();
    }

    private byte[] requestToRawMessage(HttpRequest request) {
        byte[] httpRequestHeader = (request.getMethod() + " " + this.getRequestUrl(request) + " HTTP/1.1\r\n" + this.formatHeaderList(request.getHeaderList()) + "\r\n\r\n").getBytes();
        return Arrays.concatenate((byte[])httpRequestHeader, (byte[])request.getBodyAsRawBytes());
    }

    private byte[] responseToRawMessage(HttpResponse response) {
        byte[] httpResponseHeader = ("HTTP/1.1 " + response.getStatusCode() + " " + (response.getReasonPhrase() != null ? response.getReasonPhrase() : "") + "\r\n" + this.formatHeaderList(response.getHeaderList()) + "\r\n\r\n").getBytes(StandardCharsets.US_ASCII);
        return Arrays.concatenate((byte[])httpResponseHeader, (byte[])response.getBodyAsRawBytes());
    }

    private String formatHeaderList(List<Header> headerList) {
        return headerList.stream().map(h -> h.getValues().stream().map(value -> h.getName() + ": " + value).collect(Collectors.joining("\r\n"))).collect(Collectors.joining("\r\n"));
    }

    private String getRequestUrl(HttpRequest request) {
        StringJoiner pathToQueryJoiner = new StringJoiner("?");
        if (StringUtils.isEmpty((CharSequence)request.getPath())) {
            pathToQueryJoiner.add("/");
        } else {
            pathToQueryJoiner.add(request.getPath());
        }
        if (request.getQueryStringParameters() != null && request.getQueryStringParameters().getEntries() != null) {
            pathToQueryJoiner.add(request.getQueryStringParameters().getRawParameterString());
        }
        return pathToQueryJoiner.toString();
    }

    @ConstructorProperties(value={"rbelConverter"})
    @Generated
    public MockServerToRbelConverter(RbelConverter rbelConverter) {
        this.rbelConverter = rbelConverter;
    }
}

