/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.configuration.RbelConfiguration;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.RbelErpVauDecrpytionConverter;
import de.gematik.rbellogger.converter.RbelVauEpaConverter;
import de.gematik.rbellogger.converter.initializers.RbelKeyFolderInitializer;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.file.RbelFileWriter;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRoute;
import de.gematik.test.tiger.common.pki.KeyMgr;
import de.gematik.test.tiger.proxy.IRbelMessageListener;
import de.gematik.test.tiger.proxy.ITigerProxy;
import de.gematik.test.tiger.proxy.certificate.TlsFacet;
import de.gematik.test.tiger.proxy.client.ProxyFileReadingFilter;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyStartupException;
import de.gematik.test.tiger.proxy.vau.RbelVauSessionListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyPair;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import kong.unirest.GetRequest;
import kong.unirest.Unirest;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTigerProxy
implements ITigerProxy,
AutoCloseable {
    private static final String FIX_VAU_KEY = "-----BEGIN PRIVATE KEY-----\nMIGIAgEAMBQGByqGSM49AgEGCSskAwMCCAEBBwRtMGsCAQEEIAeOzpSQT8a/mQDM\n7Uxa9NzU++vFhbIFS2Nsw/djM73uoUQDQgAEIfr+3Iuh71R3mVooqXlPhjVd8wXx\n9Yr8iPh+kcZkNTongD49z2cL0wXzuSP5Fb/hGTidhpw1ZYKMib1CIjH59A==\n-----END PRIVATE KEY-----\n";
    private final List<IRbelMessageListener> rbelMessageListeners = new ArrayList();
    private final TigerProxyConfiguration tigerProxyConfiguration;
    private RbelLogger rbelLogger;
    private RbelFileWriter rbelFileWriter;
    private Optional<String> name;
    protected final Logger log;
    private final ExecutorService trafficParserExecutor = Executors.newCachedThreadPool();
    private AtomicBoolean fileParsedCompletely = new AtomicBoolean(false);
    private AtomicReference<RuntimeException> fileParsingException = new AtomicReference();
    private boolean isShuttingDown = false;

    protected AbstractTigerProxy(TigerProxyConfiguration configuration) {
        this(configuration, null);
    }

    protected AbstractTigerProxy(TigerProxyConfiguration configuration, @Nullable RbelLogger rbelLogger) {
        this.log = LoggerFactory.getLogger(AbstractTigerProxy.class);
        this.name = Optional.ofNullable(configuration.getName());
        if (configuration.getTls() == null) {
            throw new TigerProxyStartupException("no TLS-configuration found!");
        }
        this.rbelLogger = rbelLogger == null ? this.buildRbelLoggerConfiguration(configuration).constructRbelLogger() : rbelLogger;
        if (!configuration.isActivateRbelParsing()) {
            this.rbelLogger.getRbelConverter().removeAllConverterPlugins();
        }
        this.addFixVauKey();
        this.initializeFileWriter();
        this.tigerProxyConfiguration = configuration;
        if (configuration.getFileSaveInfo() != null && StringUtils.isNotEmpty((CharSequence)configuration.getFileSaveInfo().getSourceFile())) {
            this.readTrafficFromSourceFile(configuration.getFileSaveInfo().getSourceFile());
        } else {
            this.fileParsedCompletely.set(true);
        }
    }

    private void initializeFileWriter() {
        this.rbelFileWriter = new RbelFileWriter(this.rbelLogger.getRbelConverter());
        this.rbelFileWriter.preSaveListener.add((el, json) -> el.getFacet(TracingMessagePairFacet.class).filter(pairFacet -> pairFacet.getResponse().equals(el)).ifPresent(pairFacet -> json.put("pairedMessageUuid", (Object)pairFacet.getRequest().getUuid())));
    }

    private void readTrafficFromSourceFile(String sourceFile) {
        new Thread(() -> {
            try {
                this.readTrafficFromTgrFile(sourceFile);
                this.fileParsedCompletely.set(true);
            }
            catch (RuntimeException e) {
                this.fileParsingException.set(e);
            }
        }, "readTrafficFromSourceFile").start();
    }

    public synchronized List<RbelElement> readTrafficFromTgrFile(String sourceFile) {
        this.log.info("Trying to read traffic from file '{}'...", (Object)sourceFile);
        try {
            String rbelFileContent = Files.readString(Path.of(sourceFile, new String[0]), StandardCharsets.UTF_8);
            List readElements = this.readTrafficFromString(rbelFileContent);
            this.log.info("Successfully read and parsed traffic from file '{}'!", (Object)sourceFile);
            return readElements;
        }
        catch (IOException | RuntimeException e) {
            throw new TigerProxyStartupException("Error while parsing traffic file '" + sourceFile + "'", e);
        }
    }

    public synchronized List<RbelElement> readTrafficFromString(String tgrFileContent) {
        try {
            this.rbelFileWriter.postConversionListener.add(TracingMessagePairFacet.pairingPostProcessor);
            this.rbelFileWriter.postConversionListener.add(TracingMessagePairFacet.updateHttpFacetsBasedOnPairsPostProcessor);
            if (this.getTigerProxyConfiguration().getFileSaveInfo() != null && StringUtils.isNotEmpty((CharSequence)this.getTigerProxyConfiguration().getFileSaveInfo().getReadFilter())) {
                this.rbelFileWriter.postConversionListener.add(new ProxyFileReadingFilter(this.getTigerProxyConfiguration().getFileSaveInfo().getReadFilter()));
            }
            List list = this.rbelFileWriter.convertFromRbelFile(tgrFileContent);
            return list;
        }
        finally {
            this.rbelFileWriter.postConversionListener.remove(TracingMessagePairFacet.pairingPostProcessor);
            this.rbelFileWriter.postConversionListener.remove(TracingMessagePairFacet.updateHttpFacetsBasedOnPairsPostProcessor);
        }
    }

    private void addFixVauKey() {
        KeyPair keyPair = KeyMgr.readEcdsaKeypairFromPkcs8Pem((byte[])FIX_VAU_KEY.getBytes(StandardCharsets.UTF_8));
        RbelKey rbelPublicVauKey = RbelKey.builder().keyName("fixVauKey_public").key((Key)keyPair.getPublic()).precedence(0).build();
        RbelKey rbelPrivateVauKey = RbelKey.builder().keyName("fixVauKey_public").key((Key)keyPair.getPrivate()).precedence(0).matchingPublicKey(rbelPublicVauKey).build();
        this.rbelLogger.getRbelKeyManager().addKey(rbelPublicVauKey);
        this.rbelLogger.getRbelKeyManager().addKey(rbelPrivateVauKey);
    }

    private RbelConfiguration buildRbelLoggerConfiguration(TigerProxyConfiguration configuration) {
        RbelConfiguration rbelConfiguration = new RbelConfiguration();
        if (configuration.getKeyFolders() != null) {
            configuration.getKeyFolders().forEach(folder -> rbelConfiguration.addInitializer((Consumer)new RbelKeyFolderInitializer(folder)));
        }
        if (configuration.isActivateEpaVauAnalysis()) {
            rbelConfiguration.addPostConversionListener((RbelConverterPlugin)new RbelVauSessionListener());
            rbelConfiguration.addAdditionalConverter((RbelConverterPlugin)new RbelVauEpaConverter());
        }
        if (configuration.isActivateErpVauAnalysis()) {
            rbelConfiguration.addAdditionalConverter((RbelConverterPlugin)new RbelErpVauDecrpytionConverter());
        }
        rbelConfiguration.setActivateVauEpa3Parsing(configuration.isActivateEpa3VauAnalysis());
        this.initializeFileSaver(configuration);
        rbelConfiguration.setActivateAsn1Parsing(configuration.isActivateAsn1Parsing());
        rbelConfiguration.setRbelBufferSizeInMb(configuration.getRbelBufferSizeInMb());
        rbelConfiguration.setSkipParsingWhenMessageLargerThanKb(configuration.getSkipParsingWhenMessageLargerThanKb());
        rbelConfiguration.setManageBuffer(true);
        return rbelConfiguration;
    }

    private void initializeFileSaver(TigerProxyConfiguration configuration) {
        if (configuration.getFileSaveInfo() != null && configuration.getFileSaveInfo().isWriteToFile()) {
            if (configuration.getFileSaveInfo().isClearFileOnBoot() && new File(configuration.getFileSaveInfo().getFilename()).exists()) {
                try {
                    FileUtils.delete((File)new File(configuration.getFileSaveInfo().getFilename()));
                }
                catch (IOException e) {
                    throw new TigerProxyStartupException("Error while deleting file on startup '" + configuration.getFileSaveInfo().getFilename() + "'");
                }
            }
            this.addRbelMessageListener(msg -> {
                String msgString = this.rbelFileWriter.convertToRbelFileString(msg);
                try {
                    FileUtils.writeStringToFile((File)new File(configuration.getFileSaveInfo().getFilename()), (String)msgString, (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (IOException e) {
                    this.log.warn("Error while saving to file '" + configuration.getFileSaveInfo().getFilename() + "':", (Throwable)e);
                }
            });
        }
    }

    public List<RbelElement> getRbelMessagesList() {
        return this.rbelLogger.getMessageList();
    }

    public void addKey(String keyid, Key key) {
        this.rbelLogger.getRbelKeyManager().addKey(keyid, key, 110);
    }

    public void triggerListener(RbelElement element) {
        this.getRbelMessageListeners().forEach(listener -> listener.triggerNewReceivedMessage(element));
    }

    public void addRbelMessageListener(IRbelMessageListener listener) {
        this.rbelMessageListeners.add(listener);
    }

    public void clearAllRoutes() {
        this.getRoutes().stream().filter(route -> !route.isInternalRoute()).map(TigerRoute::getId).forEach(arg_0 -> ((AbstractTigerProxy)this).removeRoute(arg_0));
    }

    public void removeRbelMessageListener(IRbelMessageListener listener) {
        this.rbelMessageListeners.remove(listener);
    }

    protected void waitForRemoteTigerProxyToBeOnline(String url) {
        LocalDateTime pollingStart = LocalDateTime.now();
        while (!this.isShuttingDown && !this.isGivenTigerProxyHealthy(url)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.log.debug("InterruptedException while waiting for remote-proxy '{}' to be healthy", (Object)url);
                Thread.currentThread().interrupt();
            }
            if (!pollingStart.plus(this.getTigerProxyConfiguration().getConnectionTimeoutInSeconds(), ChronoUnit.SECONDS).isBefore(LocalDateTime.now())) continue;
            throw new TigerProxyStartupException("Timeout while waiting for remote-proxy '" + url + "' to be healthy");
        }
        if (this.isShuttingDown) {
            this.log.warn("Aborting waitForRemoteTigerProxyToBeOnline at '{}'", (Object)url);
        }
    }

    private boolean isGivenTigerProxyHealthy(String url) {
        try {
            this.log.debug("Waiting for tiger-proxy at '{}' to be online...", (Object)url);
            ((GetRequest)Unirest.get((String)url).connectTimeout(this.getTigerProxyConfiguration().getConnectionTimeoutInSeconds() * 1000)).asEmpty();
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public String proxyName() {
        return this.name.map(s -> s + ": ").orElse("");
    }

    public void clearAllMessages() {
        this.getRbelLogger().getRbelConverter().clearAllMessages();
    }

    public Boolean isFileParsed() {
        if (this.fileParsingException.get() != null) {
            throw (RuntimeException)this.fileParsingException.get();
        }
        return this.fileParsedCompletely.get();
    }

    public Deque<RbelElement> getRbelMessages() {
        return this.getRbelLogger().getMessageHistory();
    }

    @Override
    public void close() {
        this.isShuttingDown = true;
        this.trafficParserExecutor.shutdown();
    }

    @Generated
    public List<IRbelMessageListener> getRbelMessageListeners() {
        return this.rbelMessageListeners;
    }

    @Generated
    public TigerProxyConfiguration getTigerProxyConfiguration() {
        return this.tigerProxyConfiguration;
    }

    @Generated
    public RbelLogger getRbelLogger() {
        return this.rbelLogger;
    }

    @Generated
    public RbelFileWriter getRbelFileWriter() {
        return this.rbelFileWriter;
    }

    @Generated
    public AtomicBoolean getFileParsedCompletely() {
        return this.fileParsedCompletely;
    }

    @Generated
    public AtomicReference<RuntimeException> getFileParsingException() {
        return this.fileParsingException;
    }

    @Generated
    public boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    @Generated
    public void setRbelLogger(RbelLogger rbelLogger) {
        this.rbelLogger = rbelLogger;
    }

    @Generated
    public void setRbelFileWriter(RbelFileWriter rbelFileWriter) {
        this.rbelFileWriter = rbelFileWriter;
    }

    @Generated
    public void setName(Optional<String> name) {
        this.name = name;
    }

    @Generated
    public void setFileParsedCompletely(AtomicBoolean fileParsedCompletely) {
        this.fileParsedCompletely = fileParsedCompletely;
    }

    @Generated
    public void setFileParsingException(AtomicReference<RuntimeException> fileParsingException) {
        this.fileParsingException = fileParsingException;
    }

    @Generated
    public void setShuttingDown(boolean isShuttingDown) {
        this.isShuttingDown = isShuttingDown;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTigerProxy)) {
            return false;
        }
        AbstractTigerProxy other = (AbstractTigerProxy)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isShuttingDown() != other.isShuttingDown()) {
            return false;
        }
        List this$rbelMessageListeners = this.getRbelMessageListeners();
        List other$rbelMessageListeners = other.getRbelMessageListeners();
        if (this$rbelMessageListeners == null ? other$rbelMessageListeners != null : !((Object)this$rbelMessageListeners).equals(other$rbelMessageListeners)) {
            return false;
        }
        TigerProxyConfiguration this$tigerProxyConfiguration = this.getTigerProxyConfiguration();
        TigerProxyConfiguration other$tigerProxyConfiguration = other.getTigerProxyConfiguration();
        if (this$tigerProxyConfiguration == null ? other$tigerProxyConfiguration != null : !this$tigerProxyConfiguration.equals(other$tigerProxyConfiguration)) {
            return false;
        }
        RbelLogger this$rbelLogger = this.getRbelLogger();
        RbelLogger other$rbelLogger = other.getRbelLogger();
        if (this$rbelLogger == null ? other$rbelLogger != null : !this$rbelLogger.equals(other$rbelLogger)) {
            return false;
        }
        RbelFileWriter this$rbelFileWriter = this.getRbelFileWriter();
        RbelFileWriter other$rbelFileWriter = other.getRbelFileWriter();
        if (this$rbelFileWriter == null ? other$rbelFileWriter != null : !this$rbelFileWriter.equals(other$rbelFileWriter)) {
            return false;
        }
        Optional this$name = this.getName();
        Optional other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        ExecutorService this$trafficParserExecutor = this.getTrafficParserExecutor();
        ExecutorService other$trafficParserExecutor = other.getTrafficParserExecutor();
        if (this$trafficParserExecutor == null ? other$trafficParserExecutor != null : !this$trafficParserExecutor.equals(other$trafficParserExecutor)) {
            return false;
        }
        AtomicBoolean this$fileParsedCompletely = this.getFileParsedCompletely();
        AtomicBoolean other$fileParsedCompletely = other.getFileParsedCompletely();
        if (this$fileParsedCompletely == null ? other$fileParsedCompletely != null : !this$fileParsedCompletely.equals(other$fileParsedCompletely)) {
            return false;
        }
        AtomicReference this$fileParsingException = this.getFileParsingException();
        AtomicReference other$fileParsingException = other.getFileParsingException();
        return !(this$fileParsingException == null ? other$fileParsingException != null : !this$fileParsingException.equals(other$fileParsingException));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTigerProxy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShuttingDown() ? 79 : 97);
        List $rbelMessageListeners = this.getRbelMessageListeners();
        result = result * 59 + ($rbelMessageListeners == null ? 43 : ((Object)$rbelMessageListeners).hashCode());
        TigerProxyConfiguration $tigerProxyConfiguration = this.getTigerProxyConfiguration();
        result = result * 59 + ($tigerProxyConfiguration == null ? 43 : $tigerProxyConfiguration.hashCode());
        RbelLogger $rbelLogger = this.getRbelLogger();
        result = result * 59 + ($rbelLogger == null ? 43 : $rbelLogger.hashCode());
        RbelFileWriter $rbelFileWriter = this.getRbelFileWriter();
        result = result * 59 + ($rbelFileWriter == null ? 43 : $rbelFileWriter.hashCode());
        Optional $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        ExecutorService $trafficParserExecutor = this.getTrafficParserExecutor();
        result = result * 59 + ($trafficParserExecutor == null ? 43 : $trafficParserExecutor.hashCode());
        AtomicBoolean $fileParsedCompletely = this.getFileParsedCompletely();
        result = result * 59 + ($fileParsedCompletely == null ? 43 : $fileParsedCompletely.hashCode());
        AtomicReference $fileParsingException = this.getFileParsingException();
        result = result * 59 + ($fileParsingException == null ? 43 : $fileParsingException.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractTigerProxy(rbelMessageListeners=" + this.getRbelMessageListeners() + ", tigerProxyConfiguration=" + this.getTigerProxyConfiguration() + ", rbelLogger=" + this.getRbelLogger() + ", rbelFileWriter=" + this.getRbelFileWriter() + ", name=" + this.getName() + ", log=" + this.getLog() + ", trafficParserExecutor=" + this.getTrafficParserExecutor() + ", fileParsedCompletely=" + this.getFileParsedCompletely() + ", fileParsingException=" + this.getFileParsingException() + ", isShuttingDown=" + this.isShuttingDown() + ")";
    }

    @Generated
    public Optional<String> getName() {
        return this.name;
    }

    @Generated
    public Logger getLog() {
        return this.log;
    }

    @Generated
    public ExecutorService getTrafficParserExecutor() {
        return this.trafficParserExecutor;
    }

    static {
        TlsFacet.init();
    }
}

