/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.socket.tls;

import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAndCertificateFactory;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class NettySslContextFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettySslContextFactory.class);
    private final Configuration configuration;
    private final KeyAndCertificateFactory keyAndCertificateFactory;
    private final Map<String, SslContext> clientSslContexts = new ConcurrentHashMap();
    private SslContext serverSslContext = null;
    private final boolean forServer;

    public NettySslContextFactory(Configuration configuration, boolean forServer) {
        this.configuration = configuration;
        this.forServer = forServer;
        this.keyAndCertificateFactory = this.createKeyAndCertificateFactory();
        System.setProperty("https.protocols", configuration.tlsProtocols());
        configuration.nettySslContextFactoryCustomizer().accept(this);
        if (configuration.proactivelyInitialiseTLS()) {
            this.createServerSslContext();
        }
    }

    public KeyAndCertificateFactory createKeyAndCertificateFactory() {
        if (this.configuration.customKeyAndCertificateFactorySupplier() != null) {
            return this.configuration.customKeyAndCertificateFactorySupplier().buildKeyAndCertificateFactory(this.forServer, this.configuration);
        }
        throw new RuntimeException("No KeyAndCertificateFactorySupplier supplied!");
    }

    public synchronized SslContext createClientSslContext(boolean enableHttp2) {
        String key = "enableHttp2=" + enableHttp2;
        SslContext clientSslContext = (SslContext)this.clientSslContexts.get(key);
        if (clientSslContext != null && !this.configuration.rebuildTLSContext()) {
            return clientSslContext;
        }
        return this.buildFreshClientSslContext(enableHttp2);
    }

    private SslContext buildFreshClientSslContext(boolean enableHttp2) {
        try {
            if (this.keyAndCertificateFactory.certificateNotYetCreated()) {
                this.keyAndCertificateFactory.buildAndSavePrivateKeyAndX509Certificate();
            }
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().protocols(this.configuration.tlsProtocols().split(",")).keyManager(this.forwardProxyPrivateKey(), this.forwardProxyCertificateChain());
            if (enableHttp2) {
                NettySslContextFactory.configureALPN((SslContextBuilder)sslContextBuilder);
            }
            switch (1.$SwitchMap$de$gematik$test$tiger$mockserver$socket$tls$ForwardProxyTLSX509CertificatesTrustManager[this.configuration.forwardProxyTLSX509CertificatesTrustManagerType().ordinal()]) {
                case 1: {
                    sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                    break;
                }
                case 2: {
                    ArrayList<X509Certificate> mockServerX509Certificates = new ArrayList<X509Certificate>();
                    mockServerX509Certificates.add(this.keyAndCertificateFactory.x509Certificate());
                    mockServerX509Certificates.add(this.keyAndCertificateFactory.certificateAuthorityX509Certificate());
                    sslContextBuilder.trustManager(this.jvmCAX509TrustCertificates(mockServerX509Certificates));
                    break;
                }
                case 3: {
                    sslContextBuilder.trustManager(this.customCAX509TrustCertificates());
                }
            }
            SslContext clientSslContext = this.buildClientSslContext((SslContextBuilder)this.configuration.sslClientContextBuilderCustomizer().apply(sslContextBuilder));
            this.clientSslContexts.put("enableHttp2=" + enableHttp2, clientSslContext);
            this.configuration.rebuildTLSContext(false);
            return clientSslContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creating SSL context for client", e);
        }
    }

    private SslContext buildClientSslContext(SslContextBuilder builder) throws SSLException {
        if (this.configuration.clientSslContextBuilderFunction() == null) {
            return builder.build();
        }
        return (SslContext)this.configuration.clientSslContextBuilderFunction().apply(builder);
    }

    private PrivateKey forwardProxyPrivateKey() {
        return this.keyAndCertificateFactory.privateKey();
    }

    private X509Certificate[] forwardProxyCertificateChain() {
        return this.keyAndCertificateFactory.certificateChain().toArray(new X509Certificate[0]);
    }

    private X509Certificate[] jvmCAX509TrustCertificates(List<X509Certificate> additionalX509Certificates) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        return Arrays.stream(trustManagerFactory.getTrustManagers()).filter(X509TrustManager.class::isInstance).flatMap(trustManager -> Arrays.stream(((X509TrustManager)trustManager).getAcceptedIssuers())).collect(() -> additionalX509Certificates, List::add, List::addAll).toArray(new X509Certificate[0]);
    }

    private X509Certificate[] customCAX509TrustCertificates() {
        ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
        x509Certificates.add(this.keyAndCertificateFactory.x509Certificate());
        x509Certificates.add(this.keyAndCertificateFactory.certificateAuthorityX509Certificate());
        return x509Certificates.toArray(new X509Certificate[0]);
    }

    public synchronized SslContext createServerSslContext() {
        if (!(this.serverSslContext == null || this.keyAndCertificateFactory.certificateNotYetCreated() || this.configuration.rebuildServerTlsContext() && !this.configuration.preventCertificateDynamicUpdate())) {
            return this.serverSslContext;
        }
        try {
            this.keyAndCertificateFactory.buildAndSavePrivateKeyAndX509Certificate();
            log.debug("using certificate authority serial:{}issuer:{}subject:{}and certificate serial:{}issuer:{}subject:{}", new Object[]{this.keyAndCertificateFactory.certificateAuthorityX509Certificate().getSerialNumber(), this.keyAndCertificateFactory.certificateAuthorityX509Certificate().getIssuerX500Principal(), this.keyAndCertificateFactory.certificateAuthorityX509Certificate().getSubjectX500Principal(), this.keyAndCertificateFactory.x509Certificate().getSerialNumber(), this.keyAndCertificateFactory.x509Certificate().getIssuerX500Principal(), this.keyAndCertificateFactory.x509Certificate().getSubjectX500Principal()});
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((PrivateKey)this.keyAndCertificateFactory.privateKey(), (Iterable)this.keyAndCertificateFactory.certificateChain()).protocols(this.configuration.tlsProtocols().split(",")).clientAuth(this.configuration.tlsMutualAuthenticationRequired() != false ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL);
            NettySslContextFactory.configureALPN((SslContextBuilder)sslContextBuilder);
            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            this.serverSslContext = ((SslContextBuilder)this.configuration.sslServerContextBuilderCustomizer().apply(sslContextBuilder)).build();
            this.configuration.rebuildServerTlsContext(false);
            return this.serverSslContext;
        }
        catch (Exception e) {
            log.error("Exception creating SSL context for server", (Throwable)e);
            throw new RuntimeException("exception creating SSL context for server", e);
        }
    }

    private static void configureALPN(SslContextBuilder sslContextBuilder) {
        Consumer<SslContextBuilder> configureALPN = contextBuilder -> contextBuilder.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
        if (SslProvider.isAlpnSupported((SslProvider)SslContext.defaultServerProvider())) {
            configureALPN.accept(sslContextBuilder.sslProvider(SslContext.defaultServerProvider()));
        } else if (SslProvider.isAlpnSupported((SslProvider)SslProvider.JDK)) {
            configureALPN.accept(sslContextBuilder.sslProvider(SslProvider.JDK));
        } else if (SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL)) {
            configureALPN.accept(sslContextBuilder.sslProvider(SslProvider.OPENSSL));
        }
    }
}

