/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.gematik.test.tiger.mockserver.exception.ExceptionHandling;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectMapperFactory {
    private static ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), (boolean)false);
    private static final ObjectWriter prettyPrintWriter = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), (boolean)false).writerWithDefaultPrettyPrinter();
    private static final ObjectWriter prettyPrintWriterThatSerialisesDefaultFields = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), (boolean)true).writerWithDefaultPrettyPrinter();
    private static final ObjectWriter writer = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), (boolean)false).writer();

    public static ObjectMapper createObjectMapper() {
        if (objectMapper == null) {
            objectMapper = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), (boolean)false);
        }
        return objectMapper;
    }

    public static ObjectMapper createObjectMapper(JsonSerializer ... additionJsonSerializers) {
        if (additionJsonSerializers == null || additionJsonSerializers.length == 0) {
            if (objectMapper == null) {
                objectMapper = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), (boolean)false);
            }
            return objectMapper;
        }
        return ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Arrays.asList(additionJsonSerializers), (boolean)false);
    }

    public static ObjectMapper createObjectMapper(JsonDeserializer ... replacementJsonDeserializers) {
        if (replacementJsonDeserializers == null || replacementJsonDeserializers.length == 0) {
            if (objectMapper == null) {
                objectMapper = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), (boolean)false);
            }
            return objectMapper;
        }
        return ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Arrays.asList(replacementJsonDeserializers), Collections.emptyList(), (boolean)false);
    }

    public static ObjectWriter createObjectMapper(boolean pretty, boolean serialiseDefaultValues, JsonSerializer ... additionJsonSerializers) {
        if (additionJsonSerializers == null || additionJsonSerializers.length == 0) {
            if (pretty && serialiseDefaultValues) {
                return prettyPrintWriterThatSerialisesDefaultFields;
            }
            if (pretty) {
                return prettyPrintWriter;
            }
            return writer;
        }
        if (pretty) {
            return ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Arrays.asList(additionJsonSerializers), (boolean)serialiseDefaultValues).writerWithDefaultPrettyPrinter();
        }
        return ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Arrays.asList(additionJsonSerializers), (boolean)serialiseDefaultValues).writer();
    }

    public static ObjectMapper buildObjectMapperWithoutRemovingEmptyValues() {
        ObjectMapper objectMapper = new ObjectMapper();
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, false));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, false));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(MapperFeature.ALLOW_COERCION_OF_SCALARS, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, false));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(MapperFeature.AUTO_DETECT_GETTERS, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_MISSING_VALUES, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(JsonParser.Feature.IGNORE_UNDEFINED, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true));
        ExceptionHandling.handleThrowable(() -> objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true));
        return objectMapper;
    }

    public static ObjectMapper buildObjectMapperWithOnlyConfigurationDefaults() {
        ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapperWithoutRemovingEmptyValues();
        ExceptionHandling.handleThrowable(() -> objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT));
        ExceptionHandling.handleThrowable(() -> objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL));
        ExceptionHandling.handleThrowable(() -> objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY));
        objectMapper.registerModule((Module)new JavaTimeModule());
        return objectMapper;
    }

    private static ObjectMapper buildObjectMapperWithDeserializerAndSerializers(List<JsonDeserializer> replacementJsonDeserializers, List<JsonSerializer> replacementJsonSerializers, boolean serialiseDefaultValues) {
        ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapperWithOnlyConfigurationDefaults();
        SimpleModule module = new SimpleModule();
        ObjectMapperFactory.addDeserializers((SimpleModule)module, (JsonDeserializer[])replacementJsonDeserializers.toArray(new JsonDeserializer[0]));
        ObjectMapperFactory.addSerializers((SimpleModule)module, (JsonSerializer[])replacementJsonSerializers.toArray(new JsonSerializer[0]), (boolean)serialiseDefaultValues);
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    private static void addDeserializers(SimpleModule module, JsonDeserializer[] replacementJsonDeserializers) {
        HashMap<Class, JsonDeserializer> jsonDeserializersByType = new HashMap<Class, JsonDeserializer>();
        for (JsonDeserializer additionJsonDeserializer : replacementJsonDeserializers) {
            jsonDeserializersByType.put(additionJsonDeserializer.handledType(), additionJsonDeserializer);
        }
        for (Map.Entry entry : jsonDeserializersByType.entrySet()) {
            module.addDeserializer((Class)entry.getKey(), (JsonDeserializer)entry.getValue());
        }
    }

    private static void addSerializers(SimpleModule module, JsonSerializer[] replacementJsonSerializers, boolean serialiseDefaultValues) {
        HashMap<Class, JsonSerializer> jsonSerializersByType = new HashMap<Class, JsonSerializer>();
        for (JsonSerializer additionJsonSerializer : replacementJsonSerializers) {
            jsonSerializersByType.put(additionJsonSerializer.handledType(), additionJsonSerializer);
        }
        for (Map.Entry entry : jsonSerializersByType.entrySet()) {
            module.addSerializer((Class)entry.getKey(), (JsonSerializer)entry.getValue());
        }
    }
}

