/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.proxyconfiguration;

import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.ObjectWithJsonToString;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProxyConfiguration
extends ObjectWithJsonToString {
    private final Type type;
    private final InetSocketAddress proxyAddress;
    private final String username;
    private final String password;

    private ProxyConfiguration(Type type, InetSocketAddress proxyAddress, String username, String password) {
        this.type = type;
        this.proxyAddress = proxyAddress;
        this.username = username;
        this.password = password;
    }

    public static List<ProxyConfiguration> proxyConfiguration(Configuration configuration) {
        InetSocketAddress socksProxySocketAddress;
        InetSocketAddress httpsProxySocketAddress;
        ArrayList<ProxyConfiguration> proxyConfigurations = new ArrayList<ProxyConfiguration>();
        String username = configuration.forwardProxyAuthenticationUsername();
        String password = configuration.forwardProxyAuthenticationPassword();
        InetSocketAddress httpProxySocketAddress = configuration.forwardHttpProxy();
        if (httpProxySocketAddress != null) {
            proxyConfigurations.add(ProxyConfiguration.proxyConfiguration((Type)Type.HTTP, (InetSocketAddress)httpProxySocketAddress, (String)username, (String)password));
        }
        if ((httpsProxySocketAddress = configuration.forwardHttpsProxy()) != null) {
            proxyConfigurations.add(ProxyConfiguration.proxyConfiguration((Type)Type.HTTPS, (InetSocketAddress)httpsProxySocketAddress, (String)username, (String)password));
        }
        if ((socksProxySocketAddress = configuration.forwardSocksProxy()) != null) {
            if (proxyConfigurations.isEmpty()) {
                proxyConfigurations.add(ProxyConfiguration.proxyConfiguration((Type)Type.SOCKS5, (InetSocketAddress)socksProxySocketAddress, (String)username, (String)password));
            } else {
                throw new IllegalArgumentException("Invalid proxy configuration it is not possible to configure HTTP or HTTPS proxy at the same time as a SOCKS proxy, please choose either HTTP(S) proxy OR a SOCKS proxy");
            }
        }
        return proxyConfigurations;
    }

    public static ProxyConfiguration proxyConfiguration(Type type, String address) {
        return ProxyConfiguration.proxyConfiguration((Type)type, (String)address, null, null);
    }

    public static ProxyConfiguration proxyConfiguration(Type type, InetSocketAddress address) {
        return ProxyConfiguration.proxyConfiguration((Type)type, (InetSocketAddress)address, null, null);
    }

    public static ProxyConfiguration proxyConfiguration(Type type, String address, String username, String password) {
        String[] addressParts = address.split(":");
        if (addressParts.length != 2) {
            throw new IllegalArgumentException("Proxy address must be in the format <host>:<ip>, for example 127.0.0.1:9090 or localhost:9090");
        }
        try {
            return ProxyConfiguration.proxyConfiguration((Type)type, (InetSocketAddress)new InetSocketAddress(addressParts[0], Integer.parseInt(addressParts[1])), (String)username, (String)password);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Proxy address port \"" + addressParts[1] + "\" into an integer");
        }
    }

    public static ProxyConfiguration proxyConfiguration(Type type, InetSocketAddress address, String username, String password) {
        return new ProxyConfiguration(type, address, username, password);
    }

    public Type getType() {
        return this.type;
    }

    public InetSocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public ProxyConfiguration addProxyAuthenticationHeader(HttpRequest httpRequest) {
        if (StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password)) {
            httpRequest.withHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString(), new String[]{"Basic " + Base64.encode((ByteBuf)Unpooled.copiedBuffer((CharSequence)(this.username + ":" + this.password), (Charset)StandardCharsets.UTF_8), (boolean)false).toString(StandardCharsets.US_ASCII)});
        }
        return this;
    }
}

