/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty.proxy.relay;

import de.gematik.test.tiger.mockserver.exception.ExceptionHandling;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownstreamProxyRelayHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownstreamProxyRelayHandler.class);
    private final Channel upstreamChannel;

    public DownstreamProxyRelayHandler(Channel upstreamChannel) {
        super(false);
        this.upstreamChannel = upstreamChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
        ctx.write((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpResponse response) {
        this.upstreamChannel.writeAndFlush((Object)response).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                ctx.read();
            } else {
                if (this.isNotSocketClosedException(future.cause())) {
                    log.error("exception while returning writing {}", (Object)response, (Object)future.cause());
                }
                future.channel().close();
            }
        }));
    }

    private boolean isNotSocketClosedException(Throwable cause) {
        return !(cause instanceof ClosedChannelException) && !(cause instanceof ClosedSelectorException);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ExceptionHandling.closeOnFlush((Channel)this.upstreamChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException((Throwable)cause)) {
            log.error("exception caught by downstream relay handler -> closing pipeline {}", (Object)ctx.channel(), (Object)cause);
        }
        ExceptionHandling.closeOnFlush((Channel)ctx.channel());
    }
}

