/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty.proxy;

import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.exception.ExceptionHandling;
import de.gematik.test.tiger.mockserver.formatting.StringFormatter;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpActionHandler;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.mockserver.model.BinaryProxyListener;
import de.gematik.test.tiger.mockserver.netty.unification.PortUnificationHandler;
import de.gematik.test.tiger.mockserver.scheduler.Scheduler;
import de.gematik.test.tiger.mockserver.uuid.UUIDService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class BinaryHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryHandler.class);
    private final Configuration configuration;
    private final Scheduler scheduler;
    private final NettyHttpClient httpClient;
    private final BinaryProxyListener binaryExchangeCallback;

    public BinaryHandler(Configuration configuration, Scheduler scheduler, NettyHttpClient httpClient) {
        super(true);
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.httpClient = httpClient;
        this.binaryExchangeCallback = configuration.binaryProxyListener();
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf byteBuf) {
        BinaryMessage binaryRequest = BinaryMessage.bytes((byte[])ByteBufUtil.getBytes((ByteBuf)byteBuf));
        String logCorrelationId = UUIDService.getUUID();
        log.info("received binary request: {}", (Object)ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()));
        InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress((ChannelHandlerContext)ctx);
        if (remoteAddress != null) {
            this.sendMessage(ctx, binaryRequest, logCorrelationId, remoteAddress);
        } else {
            log.info("unknown message format, only HTTP requests are supported for mocking or HTTP & binary requests for proxying, but request is not being proxied and request is not valid HTTP, found request in binary: {} in utf8 text: {}", (Object)ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), (Object)new String(binaryRequest.getBytes(), StandardCharsets.UTF_8));
            ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])"unknown message format, only HTTP requests are supported for mocking or HTTP & binary requests for proxying, but request is not being proxied and request is not valid HTTP".getBytes(StandardCharsets.UTF_8)));
            ctx.close();
        }
    }

    private void sendMessage(ChannelHandlerContext ctx, BinaryMessage binaryRequest, String logCorrelationId, InetSocketAddress remoteAddress) {
        CompletableFuture binaryResponseFuture = this.httpClient.sendRequest(binaryRequest, PortUnificationHandler.isSslEnabledUpstream((Channel)ctx.channel()), remoteAddress, this.configuration.socketConnectionTimeoutInMillis());
        if (this.configuration.forwardBinaryRequestsWithoutWaitingForResponse()) {
            this.processNotWaitingForResponse(ctx, binaryRequest, logCorrelationId, remoteAddress, binaryResponseFuture);
        } else {
            this.processWaitingForResponse(ctx, binaryRequest, logCorrelationId, remoteAddress, binaryResponseFuture);
        }
    }

    private void processNotWaitingForResponse(ChannelHandlerContext ctx, BinaryMessage binaryRequest, String logCorrelationId, InetSocketAddress remoteAddress, CompletableFuture<BinaryMessage> binaryResponseFuture) {
        if (this.binaryExchangeCallback != null) {
            this.binaryExchangeCallback.onProxy(binaryRequest, binaryResponseFuture, (SocketAddress)remoteAddress, ctx.channel().remoteAddress());
        }
        this.scheduler.submit(binaryResponseFuture, () -> {
            try {
                BinaryMessage binaryResponse = (BinaryMessage)binaryResponseFuture.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                if (binaryResponse != null) {
                    log.info("returning binary response:{}from:{}for forwarded binary request:{}", new Object[]{StringFormatter.formatBytes((byte[])binaryResponse.getBytes()), remoteAddress, StringFormatter.formatBytes((byte[])binaryRequest.getBytes())});
                    ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])binaryResponse.getBytes()));
                }
            }
            catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.warn("exception {} sending hex {} to {} closing connection", new Object[]{e.getMessage(), ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), remoteAddress});
                ctx.close();
            }
        }, false);
    }

    private void processWaitingForResponse(ChannelHandlerContext ctx, BinaryMessage binaryRequest, String logCorrelationId, InetSocketAddress remoteAddress, CompletableFuture<BinaryMessage> binaryResponseFuture) {
        this.scheduler.submit(binaryResponseFuture, () -> {
            try {
                BinaryMessage binaryResponse = (BinaryMessage)binaryResponseFuture.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                log.info("returning binary response:{}from:{}for forwarded binary request:{}", new Object[]{StringFormatter.formatBytes((byte[])binaryResponse.getBytes()), remoteAddress, StringFormatter.formatBytes((byte[])binaryRequest.getBytes())});
                if (this.binaryExchangeCallback != null) {
                    this.binaryExchangeCallback.onProxy(binaryRequest, binaryResponseFuture, (SocketAddress)remoteAddress, ctx.channel().remoteAddress());
                }
                ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])binaryResponse.getBytes()));
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.warn("exception {} sending hex {} to {} closing connection", new Object[]{e.getMessage(), ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), remoteAddress, e});
                ctx.close();
            }
        }, false);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException((Throwable)cause)) {
            log.error("exception caught by {} handler -> closing pipeline {}", new Object[]{this.getClass(), ctx.channel(), cause});
        }
        ExceptionHandling.closeOnFlush((Channel)ctx.channel());
    }
}

