/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.mockserver.model.Body;
import de.gematik.test.tiger.mockserver.model.BodyWithContentType;
import de.gematik.test.tiger.mockserver.model.MediaType;
import java.nio.charset.Charset;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class StringBody
extends BodyWithContentType<String> {
    public static final MediaType DEFAULT_CONTENT_TYPE = MediaType.create((String)"text", (String)"plain");
    private final boolean subString;
    private final String value;
    private final byte[] rawBytes;

    public StringBody(String value) {
        this(value, null, false, null);
    }

    public StringBody(String value, Charset charset) {
        this(value, null, false, charset != null ? DEFAULT_CONTENT_TYPE.withCharset(charset) : null);
    }

    public StringBody(String value, MediaType contentType) {
        this(value, null, false, contentType);
    }

    public StringBody(String value, byte[] rawBytes, boolean subString, MediaType contentType) {
        super(Body.Type.STRING, contentType);
        this.value = StringUtils.isNotBlank((CharSequence)value) ? value : "";
        this.subString = subString;
        this.rawBytes = rawBytes == null && value != null ? value.getBytes(this.determineCharacterSet(contentType, MediaType.DEFAULT_TEXT_HTTP_CHARACTER_SET)) : rawBytes;
    }

    public static StringBody exact(String body) {
        return new StringBody(body);
    }

    public static StringBody exact(String body, Charset charset) {
        return new StringBody(body, charset);
    }

    public static StringBody exact(String body, MediaType contentType) {
        return new StringBody(body, contentType);
    }

    public static StringBody subString(String body) {
        return new StringBody(body, null, true, null);
    }

    public static StringBody subString(String body, Charset charset) {
        return new StringBody(body, null, true, charset != null ? DEFAULT_CONTENT_TYPE.withCharset(charset) : null);
    }

    public static StringBody subString(String body, MediaType contentType) {
        return new StringBody(body, null, true, contentType);
    }

    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public boolean isSubString() {
        return this.subString;
    }

    public String toString() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringBody)) {
            return false;
        }
        StringBody other = (StringBody)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSubString() != other.isSubString()) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return Arrays.equals(this.getRawBytes(), other.getRawBytes());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StringBody;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSubString() ? 79 : 97);
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + Arrays.hashCode(this.getRawBytes());
        return result;
    }
}

