/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import de.gematik.test.tiger.mockserver.model.KeyMatchStyle;
import de.gematik.test.tiger.mockserver.model.KeyToMultiValue;
import de.gematik.test.tiger.mockserver.model.ObjectWithJsonToString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public abstract class KeysToMultiValues<T extends KeyToMultiValue, K extends KeysToMultiValues>
extends ObjectWithJsonToString {
    private KeyMatchStyle keyMatchStyle = KeyMatchStyle.SUB_SET;
    private final Multimap<String, String> multimap;
    private final K k = this;

    protected KeysToMultiValues() {
        this.multimap = LinkedHashMultimap.create();
    }

    protected KeysToMultiValues(Multimap<String, String> multimap) {
        this.multimap = LinkedHashMultimap.create(multimap);
    }

    public abstract T build(String var1, Collection<String> var2);

    protected abstract void isModified();

    public KeyMatchStyle getKeyMatchStyle() {
        return this.keyMatchStyle;
    }

    public KeysToMultiValues<T, K> withKeyMatchStyle(KeyMatchStyle keyMatchStyle) {
        this.keyMatchStyle = keyMatchStyle;
        return this;
    }

    public K withEntries(Map<String, List<String>> entries) {
        this.isModified();
        this.multimap.clear();
        for (String name : entries.keySet()) {
            for (String value : entries.get(name)) {
                this.withEntry(name, new String[]{value});
            }
        }
        return (K)this.k;
    }

    public K withEntries(List<T> entries) {
        this.isModified();
        this.multimap.clear();
        if (entries != null) {
            for (KeyToMultiValue entry : entries) {
                this.withEntry(entry);
            }
        }
        return (K)this.k;
    }

    @SafeVarargs
    public final K withEntries(T ... entries) {
        if (ArrayUtils.isNotEmpty((Object[])entries)) {
            this.withEntries(Arrays.asList(entries));
        }
        return (K)this.k;
    }

    public K withEntry(T entry) {
        if (entry != null) {
            this.isModified();
            if (entry.getValues().isEmpty()) {
                this.multimap.put((Object)entry.getName(), null);
            } else {
                this.multimap.putAll((Object)entry.getName(), (Iterable)entry.getValues());
            }
        }
        return (K)this.k;
    }

    public K withEntry(String name, String ... values) {
        this.isModified();
        if (values == null || values.length == 0) {
            this.multimap.put((Object)name, (Object)"");
        } else {
            this.multimap.putAll((Object)name, () -> Arrays.stream(values).iterator());
        }
        return (K)this.k;
    }

    public K withEntry(String name, List<String> values) {
        this.isModified();
        if (values == null || values.isEmpty()) {
            this.multimap.put((Object)name, null);
        } else {
            this.multimap.putAll((Object)name, values);
        }
        return (K)this.k;
    }

    public boolean remove(String name) {
        boolean exists = false;
        if (name != null) {
            this.isModified();
            for (String key : this.multimap.keySet().toArray(new String[0])) {
                if (!key.equalsIgnoreCase(name)) continue;
                this.multimap.removeAll((Object)key);
                exists = true;
            }
        }
        return exists;
    }

    public K replaceEntry(T entry) {
        if (entry != null) {
            this.isModified();
            this.remove(entry.getName());
            this.multimap.putAll((Object)entry.getName(), (Iterable)entry.getValues());
        }
        return (K)this.k;
    }

    public K replaceEntryIfExists(T entry) {
        if (entry != null) {
            this.isModified();
            if (this.remove(entry.getName())) {
                this.multimap.putAll((Object)entry.getName(), (Iterable)entry.getValues());
            }
        }
        return (K)this.k;
    }

    public List<T> getEntries() {
        if (!this.isEmpty()) {
            ArrayList<KeyToMultiValue> headers = new ArrayList<KeyToMultiValue>();
            for (String String2 : this.multimap.keySet().toArray(new String[0])) {
                headers.add(this.build(String2, this.multimap.get((Object)String2)));
            }
            return headers;
        }
        return Collections.emptyList();
    }

    public Set<String> keySet() {
        return this.multimap.keySet();
    }

    public Multimap<String, String> getMultimap() {
        return this.multimap;
    }

    public List<String> getValues(String name) {
        if (!this.isEmpty() && name != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (String key : this.multimap.keySet().toArray(new String[0])) {
                if (key == null || !key.equalsIgnoreCase(name)) continue;
                values.addAll(this.multimap.get((Object)key));
            }
            return values;
        }
        return Collections.emptyList();
    }

    String getFirstValue(String name) {
        if (!this.isEmpty()) {
            for (String key : this.multimap.keySet().toArray(new String[0])) {
                String next;
                Collection Strings;
                if (key == null || !key.equalsIgnoreCase(name) || (Strings = this.multimap.get((Object)key)).isEmpty() || (next = (String)Strings.iterator().next()) == null) continue;
                return next;
            }
        }
        return "";
    }

    public boolean containsEntry(String name) {
        if (!this.isEmpty()) {
            for (String key : this.multimap.keySet().toArray(new String[0])) {
                if (key == null || !key.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsEntry(String name, String value) {
        if (!this.isEmpty() && name != null && value != null) {
            for (String entryKey : this.multimap.keySet().toArray(new String[0])) {
                Collection Strings;
                if (entryKey == null || !entryKey.equalsIgnoreCase(name) || (Strings = this.multimap.get((Object)entryKey)) == null) continue;
                for (String entryValue : Strings.toArray(new String[0])) {
                    if (!value.equalsIgnoreCase(entryValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.multimap.isEmpty();
    }

    public abstract K clone();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeysToMultiValues)) {
            return false;
        }
        KeysToMultiValues that = (KeysToMultiValues)o;
        return Objects.equals(this.multimap, that.multimap);
    }

    public int hashCode() {
        return Objects.hash(this.multimap);
    }
}

