/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Multimap;
import de.gematik.test.tiger.mockserver.model.Action;
import de.gematik.test.tiger.mockserver.model.BinaryBody;
import de.gematik.test.tiger.mockserver.model.BodyWithContentType;
import de.gematik.test.tiger.mockserver.model.Cookie;
import de.gematik.test.tiger.mockserver.model.Cookies;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.Headers;
import de.gematik.test.tiger.mockserver.model.HttpMessage;
import de.gematik.test.tiger.mockserver.model.HttpStatusCode;
import de.gematik.test.tiger.mockserver.model.KeyToMultiValue;
import de.gematik.test.tiger.mockserver.model.MediaType;
import de.gematik.test.tiger.mockserver.model.StringBody;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpResponse
extends Action<HttpResponse>
implements HttpMessage<HttpResponse, BodyWithContentType> {
    private int hashCode;
    private Integer statusCode;
    private String reasonPhrase;
    private BodyWithContentType body;
    private Headers headers;
    private Cookies cookies;
    private Integer streamId = null;

    public static HttpResponse response() {
        return new HttpResponse();
    }

    public static HttpResponse response(String body) {
        return new HttpResponse().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody(body);
    }

    public static HttpResponse notFoundResponse() {
        return new HttpResponse().withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase());
    }

    public HttpResponse withStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        this.hashCode = 0;
        return this;
    }

    public HttpResponse withReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
        this.hashCode = 0;
        return this;
    }

    public HttpResponse withBody(String body) {
        if (body != null) {
            this.body = new StringBody(body);
            this.hashCode = 0;
        }
        return this;
    }

    public HttpResponse withBody(String body, Charset charset) {
        if (body != null) {
            this.body = new StringBody(body, charset);
            this.hashCode = 0;
        }
        return this;
    }

    public HttpResponse withBody(String body, MediaType contentType) {
        if (body != null) {
            this.body = new StringBody(body, contentType);
            this.hashCode = 0;
        }
        return this;
    }

    public HttpResponse withBody(byte[] body) {
        this.body = new BinaryBody(body);
        this.hashCode = 0;
        return this;
    }

    public HttpResponse withBody(BodyWithContentType body) {
        this.body = body;
        this.hashCode = 0;
        return this;
    }

    @JsonIgnore
    public byte[] getBodyAsRawBytes() {
        return this.body != null ? this.body.getRawBytes() : new byte[]{};
    }

    @JsonIgnore
    public String getBodyAsString() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    private Headers getOrCreateHeaders() {
        if (this.headers == null) {
            this.headers = new Headers(new Header[0]);
            this.hashCode = 0;
        }
        return this.headers;
    }

    public HttpResponse withHeaders(Headers headers) {
        this.headers = headers == null || headers.isEmpty() ? null : headers;
        this.hashCode = 0;
        return this;
    }

    public HttpResponse withHeader(Header header) {
        this.getOrCreateHeaders().withEntry((KeyToMultiValue)header);
        this.hashCode = 0;
        return this;
    }

    public HttpResponse withHeader(String name, String ... values) {
        if (values.length == 0) {
            values = new String[]{".*"};
        }
        this.getOrCreateHeaders().withEntry(name, values);
        this.hashCode = 0;
        return this;
    }

    public HttpResponse replaceHeader(Header header) {
        this.getOrCreateHeaders().replaceEntry((KeyToMultiValue)header);
        this.hashCode = 0;
        return this;
    }

    public List<Header> getHeaderList() {
        if (this.headers != null) {
            return this.headers.getEntries();
        }
        return Collections.emptyList();
    }

    public List<String> getHeader(String name) {
        if (this.headers != null) {
            return this.headers.getValues(name);
        }
        return Collections.emptyList();
    }

    public String getFirstHeader(String name) {
        if (this.headers != null) {
            return this.headers.getFirstValue(name);
        }
        return "";
    }

    public HttpResponse removeHeader(String name) {
        if (this.headers != null) {
            this.headers.remove(name);
            this.hashCode = 0;
        }
        return this;
    }

    public boolean containsHeader(String name, String value) {
        if (this.headers != null) {
            return this.headers.containsEntry(name, value);
        }
        return false;
    }

    private Cookies getOrCreateCookies() {
        if (this.cookies == null) {
            this.cookies = new Cookies(new Cookie[0]);
            this.hashCode = 0;
        }
        return this.cookies;
    }

    public HttpResponse withCookies(Cookies cookies) {
        this.cookies = cookies == null || cookies.isEmpty() ? null : cookies;
        this.hashCode = 0;
        return this;
    }

    public List<Cookie> getCookieList() {
        if (this.cookies != null) {
            return this.cookies.getEntries();
        }
        return Collections.emptyList();
    }

    public HttpResponse withStreamId(Integer streamId) {
        this.streamId = streamId;
        this.hashCode = 0;
        return this;
    }

    @JsonIgnore
    public Action.Type getType() {
        return Action.Type.RESPONSE;
    }

    public HttpResponse clone() {
        return ((HttpResponse)HttpResponse.response().withStatusCode(this.statusCode).withReasonPhrase(this.reasonPhrase).withBody(this.body).withHeaders(this.headers != null ? this.headers.clone() : null).withCookies(this.cookies != null ? this.cookies.clone() : null).withDelay(this.getDelay())).withStreamId(this.streamId);
    }

    public Multimap<String, String> getHeaderMultimap() {
        return this.headers.getMultimap();
    }

    @Generated
    public HttpResponse() {
    }

    @Generated
    public int getHashCode() {
        return this.hashCode;
    }

    @Generated
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    @Generated
    public BodyWithContentType getBody() {
        return this.body;
    }

    @Generated
    public Headers getHeaders() {
        return this.headers;
    }

    @Generated
    public Cookies getCookies() {
        return this.cookies;
    }

    @Generated
    public Integer getStreamId() {
        return this.streamId;
    }

    @Generated
    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    @Generated
    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    @Generated
    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    @Generated
    public void setBody(BodyWithContentType body) {
        this.body = body;
    }

    @Generated
    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    @Generated
    public void setCookies(Cookies cookies) {
        this.cookies = cookies;
    }

    @Generated
    public void setStreamId(Integer streamId) {
        this.streamId = streamId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getHashCode() != other.getHashCode()) {
            return false;
        }
        Integer this$statusCode = this.getStatusCode();
        Integer other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        Integer this$streamId = this.getStreamId();
        Integer other$streamId = other.getStreamId();
        if (this$streamId == null ? other$streamId != null : !((Object)this$streamId).equals(other$streamId)) {
            return false;
        }
        String this$reasonPhrase = this.getReasonPhrase();
        String other$reasonPhrase = other.getReasonPhrase();
        if (this$reasonPhrase == null ? other$reasonPhrase != null : !this$reasonPhrase.equals(other$reasonPhrase)) {
            return false;
        }
        BodyWithContentType this$body = this.getBody();
        BodyWithContentType other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Headers this$headers = this.getHeaders();
        Headers other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        Cookies this$cookies = this.getCookies();
        Cookies other$cookies = other.getCookies();
        return !(this$cookies == null ? other$cookies != null : !this$cookies.equals(other$cookies));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHashCode();
        Integer $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        Integer $streamId = this.getStreamId();
        result = result * 59 + ($streamId == null ? 43 : ((Object)$streamId).hashCode());
        String $reasonPhrase = this.getReasonPhrase();
        result = result * 59 + ($reasonPhrase == null ? 43 : $reasonPhrase.hashCode());
        BodyWithContentType $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Headers $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        Cookies $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : $cookies.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpResponse(hashCode=" + this.getHashCode() + ", statusCode=" + this.getStatusCode() + ", reasonPhrase=" + this.getReasonPhrase() + ", body=" + this.getBody() + ", headers=" + this.getHeaders() + ", cookies=" + this.getCookies() + ", streamId=" + this.getStreamId() + ")";
    }
}

