/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.mockserver.character.Character;
import de.gematik.test.tiger.mockserver.model.BinaryBody;
import de.gematik.test.tiger.mockserver.model.Body;
import de.gematik.test.tiger.mockserver.model.Cookie;
import de.gematik.test.tiger.mockserver.model.Cookies;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.Headers;
import de.gematik.test.tiger.mockserver.model.HttpMessage;
import de.gematik.test.tiger.mockserver.model.KeyToMultiValue;
import de.gematik.test.tiger.mockserver.model.MockserverX509CertificateWrapper;
import de.gematik.test.tiger.mockserver.model.Not;
import de.gematik.test.tiger.mockserver.model.Parameter;
import de.gematik.test.tiger.mockserver.model.Parameters;
import de.gematik.test.tiger.mockserver.model.Protocol;
import de.gematik.test.tiger.mockserver.model.RequestDefinition;
import de.gematik.test.tiger.mockserver.model.SocketAddress;
import de.gematik.test.tiger.mockserver.model.StringBody;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpRequest
extends RequestDefinition
implements HttpMessage<HttpRequest, Body> {
    private String method = "";
    private String path = "";
    private Parameters pathParameters;
    private Parameters queryStringParameters;
    private Body body = null;
    private Headers headers;
    private Cookies cookies;
    private Boolean keepAlive = null;
    private Boolean secure = null;
    private Protocol protocol = null;
    private Integer streamId = null;
    private List<MockserverX509CertificateWrapper> clientCertificateChain;
    private String tlsVersion = null;
    private String cipherSuite = null;
    private SocketAddress socketAddress;
    private String localAddress;
    private String remoteAddress;
    private Boolean forwardProxyRequest = true;
    private RbelElement parsedRbelMessage = null;

    public static HttpRequest request() {
        return new HttpRequest();
    }

    public static HttpRequest request(String path) {
        return new HttpRequest().setPath(path);
    }

    public Boolean isSecure() {
        if (this.secure == null) {
            if (this.tlsVersion != null || this.cipherSuite != null) {
                this.setSecure(Boolean.valueOf(true));
            } else if (this.socketAddress != null && this.socketAddress.getScheme() != null) {
                this.setSecure(Boolean.valueOf(this.socketAddress.getScheme() == SocketAddress.Scheme.HTTPS));
            }
        }
        return this.secure;
    }

    public HttpRequest setSocketAddress(SocketAddress socketAddress) {
        this.socketAddress = socketAddress;
        if (socketAddress != null && socketAddress.getScheme() != null) {
            this.secure = socketAddress.getScheme() == SocketAddress.Scheme.HTTPS;
        }
        return this;
    }

    public HttpRequest setSocketAddress(String host, Integer port, SocketAddress.Scheme scheme) {
        this.setSocketAddress(new SocketAddress().withHost(host).withPort(port).withScheme(scheme));
        return this;
    }

    public HttpRequest setSocketAddress(Boolean isSecure, String host, Integer port) {
        if (StringUtils.isNotBlank((CharSequence)host)) {
            String[] hostParts = host.split(":");
            boolean secure = Boolean.TRUE.equals(isSecure);
            if (hostParts.length > 1) {
                this.setSocketAddress(hostParts[0], Integer.valueOf(port != null ? port : Integer.parseInt(hostParts[1])), secure ? SocketAddress.Scheme.HTTPS : SocketAddress.Scheme.HTTP);
            } else if (secure) {
                this.setSocketAddress(host, Integer.valueOf(port != null ? port : 443), SocketAddress.Scheme.HTTPS);
            } else {
                this.setSocketAddress(host, Integer.valueOf(port != null ? port : 80), SocketAddress.Scheme.HTTP);
            }
        }
        return this;
    }

    public boolean matches(String method) {
        return this.method.equals(method);
    }

    public boolean matches(String method, String ... paths) {
        boolean matches = false;
        for (String path : paths) {
            boolean bl = matches = this.method.equals(method) && this.path.equals(path);
            if (matches) break;
        }
        return matches;
    }

    public Parameters getPathParameters() {
        return this.pathParameters;
    }

    public List<Parameter> getQueryStringParameterList() {
        if (this.getQueryStringParameters() == null || this.getQueryStringParameters().isEmpty()) {
            return List.of();
        }
        return this.getQueryStringParameters().getEntries();
    }

    public HttpRequest withPathParameters(Parameters parameters) {
        this.pathParameters = parameters == null || parameters.isEmpty() ? null : parameters;
        return this;
    }

    private Parameters getOrCreateQueryStringParameters() {
        if (this.queryStringParameters == null) {
            this.queryStringParameters = new Parameters(new Parameter[0]);
        }
        return this.queryStringParameters;
    }

    public HttpRequest withQueryStringParameter(String name, String ... values) {
        this.getOrCreateQueryStringParameters().withEntry(name, values);
        return this;
    }

    public HttpRequest withBody(String body) {
        this.body = new StringBody(body);
        return this;
    }

    public HttpRequest withBody(String body, Charset charset) {
        if (body != null) {
            this.body = new StringBody(body, charset);
        }
        return this;
    }

    public HttpRequest withBody(byte[] body) {
        this.body = new BinaryBody(body);
        return this;
    }

    public HttpRequest withBody(Body body) {
        this.body = body;
        return this;
    }

    @JsonIgnore
    public byte[] getBodyAsRawBytes() {
        return this.body != null ? this.body.getRawBytes() : new byte[]{};
    }

    @JsonIgnore
    public String getBodyAsString() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    public Headers getHeaders() {
        if (this.headers == null) {
            this.headers = new Headers(new Header[0]);
        }
        return this.headers;
    }

    public HttpRequest withHeaders(Headers headers) {
        this.headers = headers == null || headers.isEmpty() ? null : headers;
        return this;
    }

    public HttpRequest withHeader(Header header) {
        this.getHeaders().withEntry((KeyToMultiValue)header);
        return this;
    }

    public HttpRequest withHeader(String name, String ... values) {
        if (values.length == 0) {
            values = new String[]{".*"};
        }
        this.getHeaders().withEntry((KeyToMultiValue)Header.header((String)name, (String[])values));
        return this;
    }

    public HttpRequest replaceHeader(Header header) {
        this.getHeaders().replaceEntry((KeyToMultiValue)header);
        return this;
    }

    public List<Header> getHeaderList() {
        if (this.headers != null) {
            return this.headers.getEntries();
        }
        return Collections.emptyList();
    }

    public List<String> getHeader(String name) {
        if (this.headers != null) {
            return this.headers.getValues(name);
        }
        return Collections.emptyList();
    }

    public String getFirstHeader(String name) {
        if (this.headers != null) {
            return this.headers.getFirstValue(name);
        }
        return "";
    }

    public boolean containsHeader(String name, String value) {
        if (this.headers != null) {
            return this.headers.containsEntry(name, value);
        }
        return false;
    }

    public HttpRequest removeHeader(String name) {
        if (this.headers != null) {
            this.headers.remove(name);
        }
        return this;
    }

    public HttpRequest withCookies(Cookies cookies) {
        this.cookies = cookies == null || cookies.isEmpty() ? null : cookies;
        return this;
    }

    public List<Cookie> getCookieList() {
        if (this.cookies != null) {
            return this.cookies.getEntries();
        }
        return Collections.emptyList();
    }

    public InetSocketAddress socketAddressFromHostHeader() {
        if (this.socketAddress != null && this.socketAddress.getHost() != null) {
            boolean isSsl = this.socketAddress.getScheme() != null && this.socketAddress.getScheme().equals((Object)SocketAddress.Scheme.HTTPS);
            return new InetSocketAddress(this.socketAddress.getHost(), this.socketAddress.getPort() != null ? this.socketAddress.getPort() : (isSsl ? 443 : 80));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getFirstHeader(HttpHeaderNames.HOST.toString()))) {
            boolean isSsl = this.isSecure() != null && this.isSecure() != false;
            String[] hostHeaderParts = this.getFirstHeader(HttpHeaderNames.HOST.toString()).split(":");
            return new InetSocketAddress(hostHeaderParts[0], hostHeaderParts.length > 1 ? Integer.parseInt(hostHeaderParts[1]) : (isSsl ? 443 : 80));
        }
        throw new IllegalArgumentException("Host header must be provided to determine remote socket address, the request does not include the \"Host\" header:" + Character.NEW_LINE + this);
    }

    public HttpRequest shallowClone() {
        return ((HttpRequest)HttpRequest.not((Not)HttpRequest.request(), (Boolean)this.not)).setMethod(this.method).setPath(this.path).setPathParameters(this.pathParameters).setQueryStringParameters(this.queryStringParameters).setBody(this.body).setHeaders(this.headers).setCookies(this.cookies).setKeepAlive(this.keepAlive).setSecure(this.secure).setProtocol(this.protocol).setStreamId(this.streamId).setClientCertificateChain(this.clientCertificateChain).setSocketAddress(this.socketAddress).setLocalAddress(this.localAddress).setRemoteAddress(this.remoteAddress);
    }

    public HttpRequest clone() {
        return ((HttpRequest)HttpRequest.not((Not)HttpRequest.request(), (Boolean)this.not)).setMethod(this.method).setPath(this.path).setPathParameters(this.pathParameters != null ? this.pathParameters.clone() : null).setQueryStringParameters(this.queryStringParameters != null ? this.queryStringParameters.clone() : null).withBody(this.body).withHeaders(this.headers != null ? this.headers.clone() : null).withCookies(this.cookies != null ? this.cookies.clone() : null).setKeepAlive(this.keepAlive).setSecure(this.secure).setProtocol(this.protocol).setStreamId(this.streamId).setClientCertificateChain(this.clientCertificateChain != null && !this.clientCertificateChain.isEmpty() ? this.clientCertificateChain.stream().map(c -> MockserverX509CertificateWrapper.with((X509Certificate)c.certificate())).toList() : null).setSocketAddress(this.socketAddress).setLocalAddress(this.localAddress).setRemoteAddress(this.remoteAddress);
    }

    public String getMethodOrDefault(String fallback) {
        return Optional.ofNullable(this.method).filter(StringUtils::isNotEmpty).orElse(fallback);
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public Parameters getQueryStringParameters() {
        return this.queryStringParameters;
    }

    @Generated
    public Body getBody() {
        return this.body;
    }

    @Generated
    public Cookies getCookies() {
        return this.cookies;
    }

    @Generated
    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    @Generated
    public Boolean getSecure() {
        return this.secure;
    }

    @Generated
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Generated
    public Integer getStreamId() {
        return this.streamId;
    }

    @Generated
    public List<MockserverX509CertificateWrapper> getClientCertificateChain() {
        return this.clientCertificateChain;
    }

    @Generated
    public String getTlsVersion() {
        return this.tlsVersion;
    }

    @Generated
    public String getCipherSuite() {
        return this.cipherSuite;
    }

    @Generated
    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    @Generated
    public String getLocalAddress() {
        return this.localAddress;
    }

    @Generated
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Generated
    public Boolean getForwardProxyRequest() {
        return this.forwardProxyRequest;
    }

    @Generated
    public RbelElement getParsedRbelMessage() {
        return this.parsedRbelMessage;
    }

    @Generated
    public HttpRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    @Generated
    public HttpRequest setPath(String path) {
        this.path = path;
        return this;
    }

    @Generated
    public HttpRequest setPathParameters(Parameters pathParameters) {
        this.pathParameters = pathParameters;
        return this;
    }

    @Generated
    public HttpRequest setQueryStringParameters(Parameters queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
        return this;
    }

    @Generated
    public HttpRequest setBody(Body body) {
        this.body = body;
        return this;
    }

    @Generated
    public HttpRequest setHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    @Generated
    public HttpRequest setCookies(Cookies cookies) {
        this.cookies = cookies;
        return this;
    }

    @Generated
    public HttpRequest setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    @Generated
    public HttpRequest setSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    @Generated
    public HttpRequest setProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @Generated
    public HttpRequest setStreamId(Integer streamId) {
        this.streamId = streamId;
        return this;
    }

    @Generated
    public HttpRequest setClientCertificateChain(List<MockserverX509CertificateWrapper> clientCertificateChain) {
        this.clientCertificateChain = clientCertificateChain;
        return this;
    }

    @Generated
    public HttpRequest setTlsVersion(String tlsVersion) {
        this.tlsVersion = tlsVersion;
        return this;
    }

    @Generated
    public HttpRequest setCipherSuite(String cipherSuite) {
        this.cipherSuite = cipherSuite;
        return this;
    }

    @Generated
    public HttpRequest setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    @Generated
    public HttpRequest setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    @Generated
    public HttpRequest setForwardProxyRequest(Boolean forwardProxyRequest) {
        this.forwardProxyRequest = forwardProxyRequest;
        return this;
    }

    @Generated
    public HttpRequest setParsedRbelMessage(RbelElement parsedRbelMessage) {
        this.parsedRbelMessage = parsedRbelMessage;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$keepAlive = this.getKeepAlive();
        Boolean other$keepAlive = other.getKeepAlive();
        if (this$keepAlive == null ? other$keepAlive != null : !((Object)this$keepAlive).equals(other$keepAlive)) {
            return false;
        }
        Boolean this$secure = this.getSecure();
        Boolean other$secure = other.getSecure();
        if (this$secure == null ? other$secure != null : !((Object)this$secure).equals(other$secure)) {
            return false;
        }
        Integer this$streamId = this.getStreamId();
        Integer other$streamId = other.getStreamId();
        if (this$streamId == null ? other$streamId != null : !((Object)this$streamId).equals(other$streamId)) {
            return false;
        }
        Boolean this$forwardProxyRequest = this.getForwardProxyRequest();
        Boolean other$forwardProxyRequest = other.getForwardProxyRequest();
        if (this$forwardProxyRequest == null ? other$forwardProxyRequest != null : !((Object)this$forwardProxyRequest).equals(other$forwardProxyRequest)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Parameters this$pathParameters = this.getPathParameters();
        Parameters other$pathParameters = other.getPathParameters();
        if (this$pathParameters == null ? other$pathParameters != null : !this$pathParameters.equals(other$pathParameters)) {
            return false;
        }
        Parameters this$queryStringParameters = this.getQueryStringParameters();
        Parameters other$queryStringParameters = other.getQueryStringParameters();
        if (this$queryStringParameters == null ? other$queryStringParameters != null : !this$queryStringParameters.equals(other$queryStringParameters)) {
            return false;
        }
        Body this$body = this.getBody();
        Body other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Headers this$headers = this.getHeaders();
        Headers other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        Cookies this$cookies = this.getCookies();
        Cookies other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !this$cookies.equals(other$cookies)) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        List this$clientCertificateChain = this.getClientCertificateChain();
        List other$clientCertificateChain = other.getClientCertificateChain();
        if (this$clientCertificateChain == null ? other$clientCertificateChain != null : !((Object)this$clientCertificateChain).equals(other$clientCertificateChain)) {
            return false;
        }
        String this$tlsVersion = this.getTlsVersion();
        String other$tlsVersion = other.getTlsVersion();
        if (this$tlsVersion == null ? other$tlsVersion != null : !this$tlsVersion.equals(other$tlsVersion)) {
            return false;
        }
        String this$cipherSuite = this.getCipherSuite();
        String other$cipherSuite = other.getCipherSuite();
        if (this$cipherSuite == null ? other$cipherSuite != null : !this$cipherSuite.equals(other$cipherSuite)) {
            return false;
        }
        SocketAddress this$socketAddress = this.getSocketAddress();
        SocketAddress other$socketAddress = other.getSocketAddress();
        if (this$socketAddress == null ? other$socketAddress != null : !this$socketAddress.equals(other$socketAddress)) {
            return false;
        }
        String this$localAddress = this.getLocalAddress();
        String other$localAddress = other.getLocalAddress();
        if (this$localAddress == null ? other$localAddress != null : !this$localAddress.equals(other$localAddress)) {
            return false;
        }
        String this$remoteAddress = this.getRemoteAddress();
        String other$remoteAddress = other.getRemoteAddress();
        if (this$remoteAddress == null ? other$remoteAddress != null : !this$remoteAddress.equals(other$remoteAddress)) {
            return false;
        }
        RbelElement this$parsedRbelMessage = this.getParsedRbelMessage();
        RbelElement other$parsedRbelMessage = other.getParsedRbelMessage();
        return !(this$parsedRbelMessage == null ? other$parsedRbelMessage != null : !this$parsedRbelMessage.equals(other$parsedRbelMessage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $keepAlive = this.getKeepAlive();
        result = result * 59 + ($keepAlive == null ? 43 : ((Object)$keepAlive).hashCode());
        Boolean $secure = this.getSecure();
        result = result * 59 + ($secure == null ? 43 : ((Object)$secure).hashCode());
        Integer $streamId = this.getStreamId();
        result = result * 59 + ($streamId == null ? 43 : ((Object)$streamId).hashCode());
        Boolean $forwardProxyRequest = this.getForwardProxyRequest();
        result = result * 59 + ($forwardProxyRequest == null ? 43 : ((Object)$forwardProxyRequest).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Parameters $pathParameters = this.getPathParameters();
        result = result * 59 + ($pathParameters == null ? 43 : $pathParameters.hashCode());
        Parameters $queryStringParameters = this.getQueryStringParameters();
        result = result * 59 + ($queryStringParameters == null ? 43 : $queryStringParameters.hashCode());
        Body $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Headers $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        Cookies $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : $cookies.hashCode());
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        List $clientCertificateChain = this.getClientCertificateChain();
        result = result * 59 + ($clientCertificateChain == null ? 43 : ((Object)$clientCertificateChain).hashCode());
        String $tlsVersion = this.getTlsVersion();
        result = result * 59 + ($tlsVersion == null ? 43 : $tlsVersion.hashCode());
        String $cipherSuite = this.getCipherSuite();
        result = result * 59 + ($cipherSuite == null ? 43 : $cipherSuite.hashCode());
        SocketAddress $socketAddress = this.getSocketAddress();
        result = result * 59 + ($socketAddress == null ? 43 : $socketAddress.hashCode());
        String $localAddress = this.getLocalAddress();
        result = result * 59 + ($localAddress == null ? 43 : $localAddress.hashCode());
        String $remoteAddress = this.getRemoteAddress();
        result = result * 59 + ($remoteAddress == null ? 43 : $remoteAddress.hashCode());
        RbelElement $parsedRbelMessage = this.getParsedRbelMessage();
        result = result * 59 + ($parsedRbelMessage == null ? 43 : $parsedRbelMessage.hashCode());
        return result;
    }
}

